/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.noteattachment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDao;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentGroup;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentPersonnel;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentServiceImpl;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentStatus;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentType;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentTypeGroup;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentProtocolBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolAttachmentServiceImplTest {
    private Mockery context = new JUnit4Mockery();

    @Test(expected=IllegalArgumentException.class)
    public void getStatusFromCodeNullCode() {
        BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        paService.getStatusFromCode(null);
        this.context.assertIsSatisfied();
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTypeFromCodeNullCode() {
        BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        paService.getTypeFromCode(null);
        this.context.assertIsSatisfied();
    }

    @Test
    public void getStatusFromCodeGoodCode() {
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        final ProtocolAttachmentStatus status = new ProtocolAttachmentStatus();
        status.setCode("1");
        status.setDescription("a desc");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.oneOf(boService)).findByPrimaryKey(ProtocolAttachmentStatus.class, Collections.singletonMap("code", "1"));
                this.will(1.returnValue((Object)status));
            }
        });
        ProtocolAttachmentStatus gotStatus = (ProtocolAttachmentStatus)paService.getStatusFromCode("1");
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be equal", (Object)gotStatus, (Matcher)Is.is((Object)status));
    }

    @Test
    public void getTypeFromCodeGoodCode() {
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        final ProtocolAttachmentType type = new ProtocolAttachmentType();
        type.setCode("1");
        type.setDescription("a desc");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.oneOf(boService)).findByPrimaryKey(ProtocolAttachmentType.class, Collections.singletonMap("code", "1"));
                this.will(2.returnValue((Object)type));
            }
        });
        ProtocolAttachmentType gotType = (ProtocolAttachmentType)paService.getTypeFromCode("1");
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be equal", (Object)gotType, (Matcher)Is.is((Object)type));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTypesForGroupNullCode() {
        BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        paService.getTypesForGroup(null);
        this.context.assertIsSatisfied();
    }

    @Test
    public void getTypesForGroupFound() {
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        final ProtocolAttachmentType type = new ProtocolAttachmentType();
        type.setCode("1");
        type.setDescription("a desc");
        List<ProtocolAttachmentType> types = Collections.singletonList(type);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ProtocolAttachmentTypeGroup typeGroup = new ProtocolAttachmentTypeGroup();
                typeGroup.setType(type);
                typeGroup.setGroup(new ProtocolAttachmentGroup("1", "a group desc"));
                ((BusinessObjectService)this.oneOf(boService)).findMatching(ProtocolAttachmentTypeGroup.class, Collections.singletonMap("groupCode", "1"));
                this.will(3.returnValue(Collections.singletonList(typeGroup)));
            }
        });
        Collection gotTypes = paService.getTypesForGroup("1");
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be equal", (Object)gotTypes, (Matcher)Is.is(types));
    }

    @Test
    public void getTypesForGroupNotFound() {
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        ArrayList types = new ArrayList();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.oneOf(boService)).findMatching(ProtocolAttachmentTypeGroup.class, Collections.singletonMap("groupCode", "1"));
                this.will(4.returnValue(null));
            }
        });
        Collection gotTypes = paService.getTypesForGroup("1");
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be equal", (Object)gotTypes, (Matcher)Is.is(types));
    }

    @Test(expected=IllegalArgumentException.class)
    public void getPersonNullId() {
        BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        paService.getPerson(null);
        this.context.assertIsSatisfied();
    }

    @Test
    public void getPersonGoodId() {
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        final ProtocolPerson person = new ProtocolPerson();
        person.setProtocolPersonId(Integer.valueOf(1));
        person.setPersonName("Foo bar");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.oneOf(boService)).findByPrimaryKey(ProtocolPerson.class, Collections.singletonMap("protocolPersonId", 1));
                this.will(5.returnValue((Object)person));
            }
        });
        ProtocolPerson gotPerson = (ProtocolPerson)paService.getPerson(Integer.valueOf(1));
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be equal", (Object)gotPerson, (Matcher)Is.is((Object)person));
    }

    @Test
    public void testIsSharedFile() {
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        ProtocolAttachmentPersonnel attachment = new ProtocolAttachmentPersonnel();
        ProtocolAttachmentPersonnel attachment1 = new ProtocolAttachmentPersonnel();
        final ArrayList<ProtocolAttachmentPersonnel> attachments = new ArrayList<ProtocolAttachmentPersonnel>();
        attachments.add(attachment);
        attachments.add(attachment1);
        attachment.setFileId(Long.valueOf(1L));
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.oneOf(boService)).findMatching(ProtocolAttachmentPersonnel.class, Collections.singletonMap("fileId", 1L));
                this.will(6.returnValue((Object)attachments));
            }
        });
        boolean isSharedFile = paService.isSharedFile((ProtocolAttachmentPersonnelBase)attachment);
        Assert.assertTrue((boolean)isSharedFile);
    }

    @Test
    public void testIsNewAttachment() {
        final BusinessObjectService boService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolAttachmentServiceImpl paService = new ProtocolAttachmentServiceImpl(boService, (ProtocolDao)this.context.mock(ProtocolDao.class));
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        Protocol protocol = this.createProtocol();
        protocol.setSequenceNumber(Integer.valueOf(1));
        attachment.setProtocol((ProtocolBase)protocol);
        attachment.setAttachmentVersion(Integer.valueOf(1));
        attachment.setDocumentId(Integer.valueOf(1));
        attachment.setProtocolNumber(protocol.getProtocolNumber());
        attachment.setSequenceNumber(Integer.valueOf(1));
        final ArrayList attachments = new ArrayList();
        final HashMap<String, Object> keyMap = new HashMap<String, Object>();
        keyMap.put("protocolNumber", attachment.getProtocolNumber());
        keyMap.put("sequenceNumber", attachment.getSequenceNumber() - 1);
        keyMap.put("attachmentVersion", attachment.getAttachmentVersion());
        keyMap.put("documentId", attachment.getDocumentId());
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.oneOf(boService)).findMatching(ProtocolAttachmentProtocol.class, keyMap);
                this.will(7.returnValue((Object)attachments));
            }
        });
        boolean isSharedFile = paService.isNewAttachmentVersion((ProtocolAttachmentProtocolBase)attachment);
        Assert.assertTrue((boolean)isSharedFile);
    }

    private Protocol createProtocol() {
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocol.setProtocolId(Long.valueOf(1L));
        protocol.setProtocolNumber("0906000001");
        return protocol;
    }
}

