/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.noteattachment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentType;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentTypeByGroupValuesFinder;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.KeyValuesFinder;

public class ProtocolAttachmentTypeByGroupValuesFinderTest {
    private Mockery context = new JUnit4Mockery();

    @Test(expected=IllegalStateException.class)
    public void getTypeInvalidGroupCode() {
        ProtocolAttachmentTypeByGroupValuesFinder finder = new ProtocolAttachmentTypeByGroupValuesFinder();
        finder.getKeyValues();
    }

    @Test
    public void getTypeNullFilterTypes() {
        final KeyValuesFinder usedFinder = (KeyValuesFinder)this.context.mock(KeyValuesFinder.class);
        ProtocolAttachmentTypeByGroupValuesFinder finder = new ProtocolAttachmentTypeByGroupValuesFinder(){

            KeyValuesFinder createKeyValuesFinder() {
                return usedFinder;
            }
        };
        finder.setGroupCode("1");
        finder.setFilterTypes(null);
        final ArrayList kv = new ArrayList();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KeyValuesFinder)this.oneOf(usedFinder)).getKeyValues();
                this.will(2.returnValue((Object)kv));
            }
        });
        List gotKv = finder.getKeyValues();
        this.context.assertIsSatisfied();
        Assert.assertThat((String)"Should be equal", (Object)gotKv, (Matcher)Is.is(kv));
    }

    @Test
    public void getTypeWithFilterTypes() {
        final KeyValuesFinder usedFinder = (KeyValuesFinder)this.context.mock(KeyValuesFinder.class);
        ProtocolAttachmentTypeByGroupValuesFinder<ProtocolAttachmentProtocol> finder = new ProtocolAttachmentTypeByGroupValuesFinder<ProtocolAttachmentProtocol>(){

            KeyValuesFinder createKeyValuesFinder() {
                return usedFinder;
            }
        };
        finder.setGroupCode("1");
        ProtocolAttachmentProtocol pa = new ProtocolAttachmentProtocol();
        ProtocolAttachmentType type = new ProtocolAttachmentType();
        type.setCode("1");
        pa.setType((ProtocolAttachmentTypeBase)type);
        pa.setType((ProtocolAttachmentTypeBase)new ProtocolAttachmentType("1", "a desc"));
        List<ProtocolAttachmentProtocol> filterTypes = Collections.singletonList(pa);
        finder.setFilterTypes(filterTypes);
        final ArrayList<ConcreteKeyValue> kv = new ArrayList<ConcreteKeyValue>();
        ConcreteKeyValue kl1 = new ConcreteKeyValue("1", "a desc");
        ConcreteKeyValue kl2 = new ConcreteKeyValue("2", "a desc");
        kv.add(kl1);
        kv.add(kl2);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((KeyValuesFinder)this.oneOf(usedFinder)).getKeyValues();
                this.will(4.returnValue((Object)kv));
            }
        });
        List gotKv = finder.getKeyValues();
        this.context.assertIsSatisfied();
        for (KeyValue aKv : gotKv) {
            if (!"1".equals(aKv.getKey())) continue;
            Assert.fail((String)"contains a type that should be filtered");
        }
        Assert.assertThat((String)"Should be equal", (Object)gotKv.size(), (Matcher)Is.is((Object)1));
    }
}

