/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.notification;

import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.actions.ProtocolAction;
import org.kuali.kra.irb.actions.ProtocolActionType;
import org.kuali.kra.irb.actions.ProtocolStatus;
import org.kuali.kra.irb.actions.submit.ProtocolReviewType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionQualifierType;
import org.kuali.kra.irb.actions.submit.ProtocolSubmissionType;
import org.kuali.kra.irb.notification.IRBNotificationRenderer;
import org.kuali.kra.irb.notification.IRBReplacementParameters;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.protocol.ProtocolType;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.protocol.ProtocolTypeBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.service.BusinessObjectService;

public class IRBNotificationRendererTest
extends KcUnitTestBase {
    private static final String DOCUMENT_NUMBER_VAL = "{DOCUMENT_NUMBER}_VAL";
    private static final String PROTOCOL_NUMBER_VAL = "{PROTOCOL_NUMBER}_VAL";
    private static final String SEQUENCE_NUMBER_VAL = "0";
    private static final String PROTOCOL_TITLE_VAL = "{PROTOCOL_TITLE}_VAL";
    private static final String PI_NAME_VAL = "{PI_NAME}_VAL";
    private static final String LEAD_UNIT_VAL = "{LEAD_UNIT}_VAL";
    private static final String LEAD_UNIT_NAME_VAL = "{LEAD_UNIT_NAME}_VAL";
    private static final String LAST_SUBMISSION_TYPE_CODE_VAL = "{LAST_SUBMISSION_TYPE_CODE}_VAL";
    private static final String LAST_SUBMISSION_NAME_VAL = "{LAST_SUBMISSION_NAME}_VAL";
    private static final String LAST_SUBMISSION_TYPE_QUAL_CODE_VAL = "{LAST_SUBMISSION_TYPE_QUAL_CODE}_VAL";
    private static final String LAST_SUBMISSION_TYPE_QUAL_NAME_VAL = "{LAST_SUBMISSION_TYPE_QUAL_NAME}_VAL";
    private static final String LAST_ACTION_TYPE_CODE_VAL = "{LAST_ACTION_TYPE_CODE}_VAL";
    private static final String LAST_ACTION_NAME_VAL = "{LAST_ACTION_NAME}_VAL";
    private static final String PROTOCOL_TYPE_CODE_VAL = "{PROTOCOL_TYPE_CODE}_VAL";
    private static final String PROTOCOL_TYPE_DESCRIPTION_VAL = "{PROTOCOL_TYPE_DESCRIPTION}_VAL";
    private static final String PROTOCOL_STATUS_CODE_VAL = "{PROTOCOL_STATUS_CODE}_VAL";
    private static final String PROTOCOL_STATUS_DESCRIPTION_VAL = "{PROTOCOL_STATUS_DESCRIPTION}_VAL";
    private static final String SUBMISSION_STATUS_CODE_VAL = "{SUBMISSION_STATUS_CODE}_VAL";
    private static final String SUBMISSION_STATUS_NAME_VAL = null;
    private static final String PROTOCOL_REVIEW_TYPE_DESC_VAL = "{PROTOCOL_REVIEW_TYPE_DESC}_VAL";
    private static final String COMMITTEE_NAME_VAL = "{COMMITTEE_NAME}_VAL";
    private static final String PROTOCOL_INITIAL_APPROVAL_DATE_VAL = "10-Oct-2010";
    private static final String PROTOCOL_LAST_APPROVAL_DATE_VAL = "11-Nov-2011";
    private static final String PROTOCOL_EXPIRATION_DATE_VAL = "12-Dec-2012";
    private static final String PROTOCOL_REVIEW_TYPE_CODE_VAL = "PROTOCOL_REVIEW_TYPE_CODE_VAL";
    private static final String COMMITTEE_ID_VAL = "COMMITTEE_ID_VAL";
    private static final Integer SEQUENCE_NUMBER_INTEGER_VAL = 0;
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testNumberOfParameterNames() {
        IRBNotificationRendererTest.assertEquals((long)24L, (long)IRBReplacementParameters.REPLACEMENT_PARAMETERS.length);
    }

    @Test
    public void testGetDefaultReplacementParameters() throws ParseException {
        final ProtocolPerson principalInvestigator = new ProtocolPerson();
        principalInvestigator.setFullName(PI_NAME_VAL);
        final ProtocolAction lastProtocolAction = new ProtocolAction();
        lastProtocolAction.setProtocolActionTypeCode(LAST_ACTION_TYPE_CODE_VAL);
        final ProtocolSubmission protocolSubmission = new ProtocolSubmission();
        protocolSubmission.setSubmissionTypeCode(LAST_SUBMISSION_TYPE_CODE_VAL);
        protocolSubmission.setSubmissionTypeQualifierCode(LAST_SUBMISSION_TYPE_QUAL_CODE_VAL);
        protocolSubmission.setSubmissionStatusCode(SUBMISSION_STATUS_CODE_VAL);
        protocolSubmission.setProtocolReviewTypeCode(PROTOCOL_REVIEW_TYPE_CODE_VAL);
        protocolSubmission.setCommitteeId(COMMITTEE_ID_VAL);
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }

            public ProtocolPerson getPrincipalInvestigator() {
                return principalInvestigator;
            }

            public String getLeadUnitNumber() {
                return IRBNotificationRendererTest.LEAD_UNIT_VAL;
            }

            public String getLeadUnitName() {
                return IRBNotificationRendererTest.LEAD_UNIT_NAME_VAL;
            }

            public ProtocolAction getLastProtocolAction() {
                return lastProtocolAction;
            }

            public ProtocolSubmission getProtocolSubmission() {
                return protocolSubmission;
            }
        };
        this.setUpProtocolFields(protocol);
        BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.setUpExpectations(businessObjectService);
        IRBNotificationRenderer renderer = new IRBNotificationRenderer(protocol);
        renderer.setBusinessObjectService(businessObjectService);
        Map nameValueMap = renderer.getDefaultReplacementParameters();
        IRBNotificationRendererTest.assertEquals((long)27L, (long)nameValueMap.size());
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_NUMBER_VAL, nameValueMap.get("{PROTOCOL_NUMBER}"));
        IRBNotificationRendererTest.assertEquals((Object)PI_NAME_VAL, nameValueMap.get("{PI_NAME}"));
        IRBNotificationRendererTest.assertEquals((Object)LEAD_UNIT_VAL, nameValueMap.get("{LEAD_UNIT}"));
        IRBNotificationRendererTest.assertEquals((Object)LEAD_UNIT_NAME_VAL, nameValueMap.get("{LEAD_UNIT_NAME}"));
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_STATUS_CODE_VAL, nameValueMap.get("{PROTOCOL_STATUS_CODE}"));
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_STATUS_DESCRIPTION_VAL, nameValueMap.get("{PROTOCOL_STATUS_DESCRIPTION}"));
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_TITLE_VAL, nameValueMap.get("{PROTOCOL_TITLE}"));
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_TYPE_CODE_VAL, nameValueMap.get("{PROTOCOL_TYPE_CODE}"));
        IRBNotificationRendererTest.assertEquals((Object)SEQUENCE_NUMBER_VAL, nameValueMap.get("{SEQUENCE_NUMBER}"));
        IRBNotificationRendererTest.assertEquals((Object)SUBMISSION_STATUS_CODE_VAL, nameValueMap.get("{SUBMISSION_STATUS_CODE}"));
        IRBNotificationRendererTest.assertEquals((Object)SUBMISSION_STATUS_NAME_VAL, nameValueMap.get("{SUBMISSION_STATUS_NAME}"));
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_TYPE_DESCRIPTION_VAL, nameValueMap.get("{PROTOCOL_TYPE_DESCRIPTION}"));
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_INITIAL_APPROVAL_DATE_VAL, nameValueMap.get("{PROTOCOL_INITIAL_APPROVAL_DATE}"));
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_LAST_APPROVAL_DATE_VAL, nameValueMap.get("{PROTOCOL_LAST_APPROVAL_DATE}"));
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_EXPIRATION_DATE_VAL, nameValueMap.get("{PROTOCOL_EXPIRATION_DATE}"));
        IRBNotificationRendererTest.assertEquals((Object)DOCUMENT_NUMBER_VAL, nameValueMap.get("{DOCUMENT_NUMBER}"));
        IRBNotificationRendererTest.assertEquals((Object)LAST_ACTION_TYPE_CODE_VAL, nameValueMap.get("{LAST_ACTION_TYPE_CODE}"));
        IRBNotificationRendererTest.assertEquals((Object)LAST_ACTION_NAME_VAL, nameValueMap.get("{LAST_ACTION_NAME}"));
        IRBNotificationRendererTest.assertEquals((Object)LAST_SUBMISSION_TYPE_CODE_VAL, nameValueMap.get("{LAST_SUBMISSION_TYPE_CODE}"));
        IRBNotificationRendererTest.assertEquals((Object)LAST_SUBMISSION_NAME_VAL, nameValueMap.get("{LAST_SUBMISSION_NAME}"));
        IRBNotificationRendererTest.assertEquals((Object)LAST_SUBMISSION_TYPE_QUAL_CODE_VAL, nameValueMap.get("{LAST_SUBMISSION_TYPE_QUAL_CODE}"));
        IRBNotificationRendererTest.assertEquals((Object)LAST_SUBMISSION_TYPE_QUAL_NAME_VAL, nameValueMap.get("{LAST_SUBMISSION_TYPE_QUAL_NAME}"));
        IRBNotificationRendererTest.assertEquals((Object)PROTOCOL_REVIEW_TYPE_DESC_VAL, nameValueMap.get("{PROTOCOL_REVIEW_TYPE_DESC}"));
        IRBNotificationRendererTest.assertEquals((Object)COMMITTEE_NAME_VAL, nameValueMap.get("{COMMITTEE_NAME}"));
        protocol.setApprovalDate(null);
        protocol.setLastApprovalDate(null);
        protocol.setExpirationDate(null);
        protocol.setProtocolType(null);
        BusinessObjectService businessObjectService2 = (BusinessObjectService)this.context.mock(BusinessObjectService.class, "mock2");
        this.setUpExpectations(businessObjectService2);
        renderer.setBusinessObjectService(businessObjectService2);
        nameValueMap = renderer.getDefaultReplacementParameters();
        IRBNotificationRendererTest.assertEquals((long)23L, (long)nameValueMap.size());
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{PROTOCOL_INITIAL_APPROVAL_DATE}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{PROTOCOL_LAST_APPROVAL_DATE}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{PROTOCOL_EXPIRATION_DATE}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{PROTOCOL_TYPE_DESCRIPTION}"));
        protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }

            public ProtocolPerson getPrincipalInvestigator() {
                return principalInvestigator;
            }

            public String getLeadUnitNumber() {
                return IRBNotificationRendererTest.LEAD_UNIT_VAL;
            }

            public String getLeadUnitName() {
                return IRBNotificationRendererTest.LEAD_UNIT_NAME_VAL;
            }

            public ProtocolAction getLastProtocolAction() {
                return null;
            }

            public ProtocolSubmission getProtocolSubmission() {
                return null;
            }
        };
        this.setUpProtocolFields(protocol);
        renderer = new IRBNotificationRenderer(protocol);
        BusinessObjectService businessObjectService3 = (BusinessObjectService)this.context.mock(BusinessObjectService.class, "mock3");
        this.setUpExpectations(businessObjectService3);
        renderer.setBusinessObjectService(businessObjectService3);
        nameValueMap = renderer.getDefaultReplacementParameters();
        IRBNotificationRendererTest.assertEquals((long)15L, (long)nameValueMap.size());
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{PROTOCOL_INITIAL_APPROVAL_DATE}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{PROTOCOL_LAST_APPROVAL_DATE}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{PROTOCOL_EXPIRATION_DATE}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{LAST_SUBMISSION_NAME}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{LAST_SUBMISSION_TYPE_CODE}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{LAST_SUBMISSION_TYPE_QUAL_CODE}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{LAST_SUBMISSION_TYPE_QUAL_NAME}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{SUBMISSION_STATUS_CODE}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{PROTOCOL_REVIEW_TYPE_DESC}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{COMMITTEE_NAME}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{LAST_ACTION_NAME}"));
        IRBNotificationRendererTest.assertFalse((boolean)nameValueMap.containsKey("{LAST_ACTION_TYPE_CODE}"));
    }

    private void setUpExpectations(final BusinessObjectService businessObjectService) {
        final HashMap<String, String> protocolActionTypeFieldValues = new HashMap<String, String>();
        protocolActionTypeFieldValues.put("protocolActionTypeCode", LAST_ACTION_TYPE_CODE_VAL);
        final ArrayList<3> returnActionTypes = new ArrayList<3>();
        returnActionTypes.add(new ProtocolActionType(){

            public String getDescription() {
                return IRBNotificationRendererTest.LAST_ACTION_NAME_VAL;
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolActionType.class, protocolActionTypeFieldValues);
                this.will(4.returnValue((Object)returnActionTypes));
            }
        });
        final HashMap<String, String> protocolSubmissionTypeFieldValues = new HashMap<String, String>();
        protocolSubmissionTypeFieldValues.put("submissionTypeCode", LAST_SUBMISSION_TYPE_CODE_VAL);
        final ArrayList<5> returnSubmissionTypes = new ArrayList<5>();
        returnSubmissionTypes.add(new ProtocolSubmissionType(){

            public String getDescription() {
                return IRBNotificationRendererTest.LAST_SUBMISSION_NAME_VAL;
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolSubmissionType.class, protocolSubmissionTypeFieldValues);
                this.will(6.returnValue((Object)returnSubmissionTypes));
            }
        });
        final HashMap<String, String> protocolSubmissionQualifierTypeFieldValues = new HashMap<String, String>();
        protocolSubmissionQualifierTypeFieldValues.put("submissionQualifierTypeCode", LAST_SUBMISSION_TYPE_QUAL_CODE_VAL);
        final ArrayList<7> returnSubmissionQualifierTypes = new ArrayList<7>();
        returnSubmissionQualifierTypes.add(new ProtocolSubmissionQualifierType(){

            public String getDescription() {
                return IRBNotificationRendererTest.LAST_SUBMISSION_TYPE_QUAL_NAME_VAL;
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolSubmissionQualifierType.class, protocolSubmissionQualifierTypeFieldValues);
                this.will(8.returnValue((Object)returnSubmissionQualifierTypes));
            }
        });
        final HashMap<String, String> protocolReviewTypeFieldValues = new HashMap<String, String>();
        protocolReviewTypeFieldValues.put("reviewTypeCode", PROTOCOL_REVIEW_TYPE_CODE_VAL);
        final ArrayList<9> returnReviewTypes = new ArrayList<9>();
        returnReviewTypes.add(new ProtocolReviewType(){

            public String getDescription() {
                return IRBNotificationRendererTest.PROTOCOL_REVIEW_TYPE_DESC_VAL;
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolReviewType.class, protocolReviewTypeFieldValues);
                this.will(10.returnValue((Object)returnReviewTypes));
            }
        });
        final HashMap<String, String> committeeFieldValues = new HashMap<String, String>();
        committeeFieldValues.put("committeeId", COMMITTEE_ID_VAL);
        final ArrayList<11> returnCommittees = new ArrayList<11>();
        returnCommittees.add(new Committee(){

            public String getCommitteeName() {
                return IRBNotificationRendererTest.COMMITTEE_NAME_VAL;
            }
        });
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(Committee.class, committeeFieldValues);
                this.will(12.returnValue((Object)returnCommittees));
            }
        });
    }

    private void setUpProtocolFields(Protocol protocol) throws ParseException {
        protocol.setProtocolNumber(PROTOCOL_NUMBER_VAL);
        protocol.setProtocolStatusCode(PROTOCOL_STATUS_CODE_VAL);
        ProtocolStatus protocolStatus = new ProtocolStatus();
        protocolStatus.setDescription(PROTOCOL_STATUS_DESCRIPTION_VAL);
        protocol.setProtocolStatus((ProtocolStatusBase)protocolStatus);
        ProtocolDocument protocolDocument = new ProtocolDocument();
        protocolDocument.setDocumentNumber(DOCUMENT_NUMBER_VAL);
        ProtocolType protocolType = new ProtocolType();
        protocolType.setDescription(PROTOCOL_TYPE_DESCRIPTION_VAL);
        protocol.setProtocolDocument((ProtocolDocumentBase)protocolDocument);
        protocol.setTitle(PROTOCOL_TITLE_VAL);
        protocol.setProtocolTypeCode(PROTOCOL_TYPE_CODE_VAL);
        protocol.setProtocolType((ProtocolTypeBase)protocolType);
        protocol.setSequenceNumber(SEQUENCE_NUMBER_INTEGER_VAL);
        protocol.setApprovalDate(new Date(new SimpleDateFormat("d'-'MMM'-'yyyy").parse(PROTOCOL_INITIAL_APPROVAL_DATE_VAL).getTime()));
        protocol.setLastApprovalDate(new Date(new SimpleDateFormat("d'-'MMM'-'yyyy").parse(PROTOCOL_LAST_APPROVAL_DATE_VAL).getTime()));
        protocol.setExpirationDate(new Date(new SimpleDateFormat("d'-'MMM'-'yyyy").parse(PROTOCOL_EXPIRATION_DATE_VAL).getTime()));
    }
}

