/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.personnel;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.personnel.ProtocolPersonnelAuditRule;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.document.Document;

public class ProtocolPersonnelAuditRuleTest
extends ProtocolRuleTestBase {
    private ProtocolPersonnelAuditRule auditRule;
    private ProtocolDocument document;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.auditRule = new ProtocolPersonnelAuditRule();
        this.document = this.getNewProtocolDocument();
        this.setProtocolRequiredFields(this.document);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.auditRule = null;
        super.tearDown();
    }

    @Test
    public void invalidInvestigatorMatch() throws Exception {
        this.document.getProtocol().getProtocolPerson(0).setAffiliationTypeCode(Constants.AFFILIATION_STUDENT_INVESTIGATOR_TYPE);
        ProtocolPersonnelAuditRuleTest.assertFalse((String)"Audit Rule should produce audit errors", (boolean)this.auditRule.processRunAuditBusinessRules((Document)this.document));
        ProtocolPersonnelAuditRuleTest.assertEquals((long)1L, (long)KNSGlobalVariables.getAuditErrorMap().size());
    }
}

