/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.personnel;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.personnel.AddProtocolPersonnelEvent;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.SaveProtocolPersonnelEvent;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.protocol.personnel.AddProtocolPersonnelEventBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelRuleBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonnelService;
import org.kuali.kra.protocol.personnel.SaveProtocolPersonnelEventBase;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;

public class ProtocolPersonnelRuleTest
extends ProtocolRuleTestBase {
    private ProtocolPersonnelRuleBase rule;
    private static final String CO_INVESTIGATOR_PERSON_ID = "10000000003";
    private static final String CO_INVESTIGATOR_NAME = "Nicholas Majors";
    private static final String CO_INVESTIGATOR_ROLE_ID = "COI";
    private static final String CORRESPONDENT_ROLE_ID = "CRC";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProtocolPersonnelRuleBase(){

            public ProtocolPersonnelService getProtocolPersonnelServiceHook() {
                return (ProtocolPersonnelService)ProtocolPersonnelRuleTest.this.getService(ProtocolPersonnelService.class);
            }
        };
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        super.tearDown();
    }

    @Test
    public void testPersonnelSaveValid() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        this.setProtocolRequiredFields(document);
        boolean rulesPassed = this.rule.processSaveProtocolPersonnelEvent((SaveProtocolPersonnelEventBase)this.getSaveProtocolPersonnelEvent(document));
        MessageMap errorMap = GlobalVariables.getMessageMap();
        ProtocolPersonnelRuleTest.assertTrue((boolean)rulesPassed);
        ProtocolPersonnelRuleTest.assertEquals((long)0L, (long)errorMap.getErrorCount());
    }

    @Test
    public void testPersonnelSaveInvalid() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        this.setProtocolRequiredFields(document);
        document.getProtocol().getProtocolPersons().remove(0);
        boolean rulesPassed = this.rule.processSaveProtocolPersonnelEvent((SaveProtocolPersonnelEventBase)this.getSaveProtocolPersonnelEvent(document));
        ProtocolPersonnelRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        ProtocolPersonnelRuleTest.assertTrue((boolean)errorMap.containsMessageKey("error.investigator.notFound"));
    }

    @Test
    public void testAddPersonnelValid() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        this.setProtocolRequiredFields(document);
        boolean rulesPassed = this.rule.processAddProtocolPersonnelEvent((AddProtocolPersonnelEventBase)this.getAddProtocolPersonnelEvent(document, this.getCoInvestigator()));
        ProtocolPersonnelRuleTest.assertTrue((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        ProtocolPersonnelRuleTest.assertEquals((long)0L, (long)errorMap.getErrorCount());
    }

    @Test
    public void testAddPersonnelInValid() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        this.setProtocolRequiredFields(document);
        boolean rulesPassed = this.rule.processAddProtocolPersonnelEvent((AddProtocolPersonnelEventBase)this.getAddProtocolPersonnelEvent(document, this.getPrincipalInvestigator()));
        ProtocolPersonnelRuleTest.assertFalse((boolean)rulesPassed);
        MessageMap errorMap = GlobalVariables.getMessageMap();
        ProtocolPersonnelRuleTest.assertTrue((boolean)errorMap.containsMessageKey("error.protocolPersonnel.pi.already.exists"));
    }

    private ProtocolPerson getCoInvestigator() {
        return this.getProtocolPerson(CO_INVESTIGATOR_PERSON_ID, CO_INVESTIGATOR_NAME, CO_INVESTIGATOR_ROLE_ID);
    }

    private AddProtocolPersonnelEvent getAddProtocolPersonnelEvent(ProtocolDocument document, ProtocolPerson newProtocolPerson) throws Exception {
        AddProtocolPersonnelEvent event = new AddProtocolPersonnelEvent("", document, newProtocolPerson);
        return event;
    }

    private SaveProtocolPersonnelEvent getSaveProtocolPersonnelEvent(ProtocolDocument document) throws Exception {
        SaveProtocolPersonnelEvent event = new SaveProtocolPersonnelEvent("", document);
        return event;
    }
}

