/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.personnel;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.Constants;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentPersonnel;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolPersonTrainingService;
import org.kuali.kra.irb.personnel.ProtocolPersonnelService;
import org.kuali.kra.irb.personnel.ProtocolPersonnelServiceImpl;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.irb.protocol.location.ProtocolLocationService;
import org.kuali.kra.irb.test.mocks.MockProtocolPersonTrainingService;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentPersonnelBase;
import org.kuali.kra.protocol.personnel.ProtocolPersonBase;
import org.kuali.kra.protocol.protocol.location.ProtocolLocationBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolPersonnelServiceTest
extends KcUnitTestBase {
    protected static final String CO_INVESTIGATOR_PERSON_ID = "10000000003";
    protected static final String CO_INVESTIGATOR_NAME = "Nicholas Majors";
    protected static final String CO_INVESTIGATOR_ROLE_ID = "COI";
    protected static final String CO_INVESTIGATOR_UNIT = "000001";
    protected static final String CO_INVESTIGATOR_OBJ_ID = "dhafjkhadlkjfha";
    protected static final String PRINCIPAL_INVESTIGATOR_ROLE_ID = "PI";
    protected static final String PRINCIPAL_INVESTIGATOR_UNIT = "IN-CARD";
    protected static final String PRINCIPAL_INVESTIGATOR_PERSON_ID = "10000000001";
    protected static final String PRINCIPAL_INVESTIGATOR_NAME = "Joe Tester";
    protected static final String CORRESPONDENT_ROLE_ID = "CRC";
    protected static final String PERSON_ID = "personId";
    private ProtocolPersonTrainingService protocolPersonTrainingService;
    private ProtocolPersonnelServiceImpl protocolPersonnelService;
    private ProtocolPersonnelService service;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.protocolPersonTrainingService = this.buildPersonTrainingService();
        this.protocolPersonnelService = (ProtocolPersonnelServiceImpl)KraServiceLocator.getService(ProtocolPersonnelService.class);
        this.service = (ProtocolPersonnelService)KraServiceLocator.getService(ProtocolPersonnelService.class);
        this.protocolPersonnelService.setProtocolPersonTrainingService((org.kuali.kra.protocol.personnel.ProtocolPersonTrainingService)this.protocolPersonTrainingService);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        this.service = null;
        this.protocolPersonnelService = null;
        super.tearDown();
    }

    @Test
    public void testCorrectClass() {
        ProtocolPersonnelServiceTest.assertTrue((String)"Should be the same", (boolean)this.service.getClass().equals(ProtocolPersonnelServiceImpl.class));
        ProtocolPersonnelServiceTest.assertTrue((String)"Should be the same", (boolean)this.protocolPersonnelService.getClass().equals(ProtocolPersonnelServiceImpl.class));
    }

    @Test
    public void testAddProtocolPerson() throws Exception {
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        this.protocolPersonnelService.addProtocolPerson((ProtocolBase)protocol, (ProtocolPersonBase)this.getCoInvestigatorPerson());
        ProtocolPersonnelServiceTest.assertEquals((long)1L, (long)protocol.getProtocolPersons().size());
    }

    @Test
    public void testDelProtocolPerson() throws Exception {
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        ProtocolPerson protocolPerson = this.getCoInvestigatorPerson();
        protocolPerson.setDelete(true);
        protocol.getProtocolPersons().add(protocolPerson);
        ProtocolPersonnelServiceTest.assertEquals((long)1L, (long)protocol.getProtocolPersons().size());
        this.service.deleteProtocolPerson((ProtocolBase)protocol);
        ProtocolPersonnelServiceTest.assertEquals((long)0L, (long)protocol.getProtocolPersons().size());
    }

    @Test
    public void testAddProtocolAttachmentPersonnel() {
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }

            protected ProtocolLocationService getProtocolLocationService() {
                return new ProtocolLocationService(){

                    public void addDefaultProtocolLocation(ProtocolBase protocol) {
                    }

                    public void addProtocolLocation(ProtocolBase protocol, ProtocolLocationBase protocolLocation) {
                    }

                    public void clearProtocolLocationAddress(ProtocolBase protocol, int lineNumber) {
                    }
                };
            }
        };
        ProtocolPerson protocolPerson = this.getCoInvestigatorPerson();
        protocol.getProtocolPersons().add(protocolPerson);
        ProtocolAttachmentPersonnel newAttachment = new ProtocolAttachmentPersonnel();
        this.service.addProtocolPersonAttachment((ProtocolBase)protocol, (ProtocolAttachmentPersonnelBase)newAttachment, 0);
        ProtocolPersonnelServiceTest.assertEquals((long)1L, (long)protocol.getProtocolPerson(0).getAttachmentPersonnels().size());
    }

    @Test
    public void testAddProtocolUnit() throws Exception {
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }

            protected ProtocolLocationService getProtocolLocationService() {
                return new ProtocolLocationService(){

                    public void addDefaultProtocolLocation(ProtocolBase protocol) {
                    }

                    public void addProtocolLocation(ProtocolBase protocol, ProtocolLocationBase protocolLocation) {
                    }

                    public void clearProtocolLocationAddress(ProtocolBase protocol, int lineNumber) {
                    }
                };
            }
        };
        ProtocolPerson protocolPerson = this.getCoInvestigatorPerson();
        ArrayList<ProtocolUnit> protocolPersonUnits = new ArrayList<ProtocolUnit>();
        protocol.getProtocolPersons().add(protocolPerson);
        protocolPersonUnits.add(this.getProtocolUnit());
        this.service.addProtocolPersonUnit(protocolPersonUnits, (ProtocolPersonBase)protocolPerson, 0);
        ProtocolPersonnelServiceTest.assertEquals((long)1L, (long)protocol.getProtocolPerson(0).getProtocolUnits().size());
    }

    @Test
    public void testIsPIExists() throws Exception {
        ArrayList<ProtocolPerson> protocolPersons = new ArrayList<ProtocolPerson>();
        protocolPersons.add(this.getPrincipalInvestigatorPerson());
        protocolPersons.add(this.getCoInvestigatorPerson());
        boolean piExists = this.service.isPIExists(protocolPersons);
        ProtocolPersonnelServiceTest.assertTrue((boolean)piExists);
    }

    @Test
    public void testDuplicatePerson() throws Exception {
        ArrayList<ProtocolPerson> protocolPersons = new ArrayList<ProtocolPerson>();
        protocolPersons.add(this.getPrincipalInvestigatorPerson());
        ProtocolPerson coi = this.getCoInvestigatorPerson();
        coi.setPersonId(CO_INVESTIGATOR_PERSON_ID);
        protocolPersons.add(coi);
        boolean isDuplicate = this.service.isDuplicatePerson(protocolPersons, (ProtocolPersonBase)this.getPrincipalInvestigatorPerson());
        ProtocolPersonnelServiceTest.assertTrue((boolean)isDuplicate);
    }

    @Test
    public void testPIPerson() throws Exception {
        ArrayList<ProtocolPerson> protocolPersons = new ArrayList<ProtocolPerson>();
        protocolPersons.add(this.getPrincipalInvestigatorPerson());
        protocolPersons.add(this.getCoInvestigatorPerson());
        ProtocolPerson investigator = (ProtocolPerson)this.service.getPrincipalInvestigator(protocolPersons);
        ProtocolPersonnelServiceTest.assertEquals((Object)investigator.getProtocolPersonRoleId(), (Object)PRINCIPAL_INVESTIGATOR_ROLE_ID);
    }

    @Test
    public void testSwitchInvestigatorCoInvestigatorRole() throws Exception {
        List<ProtocolPerson> protocolPersons = this.getProtocolPersons();
        ProtocolPersonnelServiceTest.assertEquals((Object)protocolPersons.get(0).getProtocolPersonRoleId(), (Object)PRINCIPAL_INVESTIGATOR_ROLE_ID);
        ProtocolPersonnelServiceTest.assertEquals((Object)protocolPersons.get(1).getProtocolPersonRoleId(), (Object)CO_INVESTIGATOR_ROLE_ID);
        protocolPersons.get(0).setProtocolPersonRoleId(CO_INVESTIGATOR_ROLE_ID);
        this.service.switchInvestigatorCoInvestigatorRole(protocolPersons);
        ProtocolPersonnelServiceTest.assertEquals((Object)protocolPersons.get(0).getProtocolPersonRoleId(), (Object)CO_INVESTIGATOR_ROLE_ID);
        ProtocolPersonnelServiceTest.assertEquals((Object)protocolPersons.get(1).getProtocolPersonRoleId(), (Object)PRINCIPAL_INVESTIGATOR_ROLE_ID);
    }

    @Test
    public void testInValidStudentFacultyMatch() throws Exception {
        List<ProtocolPerson> protocolPersons = this.getProtocolPersons();
        boolean isInvalidMatch = this.service.isValidStudentFacultyMatch(protocolPersons);
        ProtocolPersonnelServiceTest.assertTrue((boolean)isInvalidMatch);
        ((ProtocolPersonBase)protocolPersons.get(0)).setAffiliationTypeCode(this.getStudentAffiliationType());
        isInvalidMatch = this.service.isValidStudentFacultyMatch(protocolPersons);
        ProtocolPersonnelServiceTest.assertFalse((boolean)isInvalidMatch);
    }

    @Test
    public void testSelectProtocolUnit() throws Exception {
        List<ProtocolPerson> protocolPersons = this.getProtocolPersons();
        ((ProtocolPersonBase)protocolPersons.get(0)).setSelectedUnit(1);
        ((ProtocolPersonBase)protocolPersons.get(0)).getProtocolUnits().addAll(this.getProtocolUnits());
        this.service.selectProtocolUnit(protocolPersons);
        ProtocolPersonnelServiceTest.assertEquals((long)((ProtocolPersonBase)protocolPersons.get(0)).getSelectedUnit(), (long)0L);
    }

    private List<ProtocolPerson> getProtocolPersons() {
        ArrayList<ProtocolPerson> protocolPersons = new ArrayList<ProtocolPerson>();
        protocolPersons.add(this.getPrincipalInvestigatorPerson());
        protocolPersons.add(this.getCoInvestigatorPerson());
        return protocolPersons;
    }

    private ProtocolPerson getCoInvestigatorPerson() {
        ProtocolPerson protocolPerson = new ProtocolPerson();
        protocolPerson.setPersonName(CO_INVESTIGATOR_NAME);
        protocolPerson.setProtocolPersonRoleId(CO_INVESTIGATOR_ROLE_ID);
        protocolPerson.setPreviousPersonRoleId(CO_INVESTIGATOR_ROLE_ID);
        protocolPerson.setObjectId(CO_INVESTIGATOR_OBJ_ID);
        return protocolPerson;
    }

    private ProtocolPerson getPrincipalInvestigatorPerson() {
        ProtocolPerson protocolPerson = new ProtocolPerson();
        protocolPerson.setPersonId(PRINCIPAL_INVESTIGATOR_PERSON_ID);
        protocolPerson.setPersonName(PRINCIPAL_INVESTIGATOR_NAME);
        protocolPerson.setPreviousPersonRoleId(PRINCIPAL_INVESTIGATOR_ROLE_ID);
        protocolPerson.setProtocolPersonRoleId(PRINCIPAL_INVESTIGATOR_ROLE_ID);
        return protocolPerson;
    }

    private ProtocolUnit getProtocolUnit() {
        ProtocolUnit protocolUnit = new ProtocolUnit();
        protocolUnit.setUnitNumber(PRINCIPAL_INVESTIGATOR_UNIT);
        protocolUnit.setLeadUnitFlag(false);
        return protocolUnit;
    }

    private List<ProtocolUnit> getProtocolUnits() {
        ArrayList<ProtocolUnit> protocolUnits = new ArrayList<ProtocolUnit>();
        ProtocolUnit protocolUnit = new ProtocolUnit();
        protocolUnit.setUnitNumber(PRINCIPAL_INVESTIGATOR_UNIT);
        protocolUnit.setLeadUnitFlag(true);
        protocolUnits.add(protocolUnit);
        protocolUnit = new ProtocolUnit();
        protocolUnit.setUnitNumber(CO_INVESTIGATOR_UNIT);
        protocolUnit.setLeadUnitFlag(false);
        return protocolUnits;
    }

    private MockProtocolPersonTrainingService buildPersonTrainingService() {
        MockProtocolPersonTrainingService personTrainingService = new MockProtocolPersonTrainingService();
        return personTrainingService;
    }

    private Integer getStudentAffiliationType() {
        return Constants.AFFILIATION_STUDENT_INVESTIGATOR_TYPE;
    }

    private Protocol buildProtocol() {
        Protocol myProto = new Protocol();
        myProto.setObjectId("a;lkjdfiahiudhbnvak");
        return myProto;
    }
}

