/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol;

import java.util.Calendar;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.irb.protocol.ProtocolNumberServiceImpl;
import org.kuali.rice.krad.service.SequenceAccessorService;

@RunWith(value=JMock.class)
public class ProtocolNumberServiceTest {
    private static final Long sequenceNumber = new Long(562L);
    private Mockery context = new JUnit4Mockery();
    private String expectedProtocolNumber;

    @Before
    public void setUp() {
        Calendar calendar = Calendar.getInstance();
        this.expectedProtocolNumber = this.getYear(calendar) + this.getMonth(calendar) + "000" + sequenceNumber;
    }

    @Test
    public void testProtocolNumber() {
        ProtocolNumberServiceImpl protocolNumberService = new ProtocolNumberServiceImpl();
        final SequenceAccessorService sequenceAccessorService = (SequenceAccessorService)this.context.mock(SequenceAccessorService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SequenceAccessorService)this.one(sequenceAccessorService)).getNextAvailableSequenceNumber("SEQ_PROTOCOL_ID");
                this.will(1.returnValue((Object)sequenceNumber));
            }
        });
        protocolNumberService.setSequenceAccessorService(sequenceAccessorService);
        String protocolNumber = protocolNumberService.generateProtocolNumber();
        Assert.assertEquals((Object)this.expectedProtocolNumber, (Object)protocolNumber);
    }

    private String getYear(Calendar calendar) {
        int year = calendar.get(1) - 2000;
        String s = Integer.toString(year);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }

    private String getMonth(Calendar calendar) {
        int month = calendar.get(2) + 1;
        String s = Integer.toString(month);
        if (s.length() == 1) {
            s = "0" + s;
        }
        return s;
    }
}

