/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.DocumentNextvalue;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ProtocolVersionService;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolVersionServiceTest
extends KcUnitTestBase {
    private static final String PROTOCOL_NUMBER = "1021000009";
    private ProtocolVersionService protocolVersionService;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.protocolVersionService = (ProtocolVersionService)KraServiceLocator.getService(ProtocolVersionService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    @Test
    public void testVersioning() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        ProtocolDocument newProtocolDocument = (ProtocolDocument)this.protocolVersionService.versionProtocolDocument((ProtocolDocumentBase)protocolDocument);
        ProtocolVersionServiceTest.assertNotNull((Object)newProtocolDocument);
        ProtocolVersionServiceTest.assertTrue((!StringUtils.equals((String)protocolDocument.getDocumentNumber(), (String)newProtocolDocument.getDocumentNumber()) ? 1 : 0) != 0);
        ProtocolVersionServiceTest.assertTrue((protocolDocument.getProtocol().getSequenceNumber() + 1 == newProtocolDocument.getProtocol().getSequenceNumber() ? 1 : 0) != 0);
        ProtocolVersionServiceTest.assertFalse((boolean)protocolDocument.getProtocol().isActive());
        ProtocolVersionServiceTest.assertTrue((boolean)newProtocolDocument.getProtocol().isActive());
        List nextValues = newProtocolDocument.getDocumentNextvalues();
        for (DocumentNextvalue nextValue : nextValues) {
            ProtocolVersionServiceTest.assertEquals((Object)nextValue.getDocumentKey(), (Object)newProtocolDocument.getDocumentNumber());
        }
    }

    @Test
    public void testGetProtocolVersion() throws Exception {
        Protocol protocol = (Protocol)this.protocolVersionService.getProtocolVersion(PROTOCOL_NUMBER, Integer.valueOf(1));
        ProtocolVersionServiceTest.assertNull((Object)protocol);
        ProtocolDocument protocolDocument1 = ProtocolFactory.createProtocolDocument(PROTOCOL_NUMBER);
        ProtocolDocument protocolDocument2 = (ProtocolDocument)this.protocolVersionService.versionProtocolDocument((ProtocolDocumentBase)protocolDocument1);
        ProtocolDocument protocolDocument3 = (ProtocolDocument)this.protocolVersionService.versionProtocolDocument((ProtocolDocumentBase)protocolDocument2);
        protocol = (Protocol)this.protocolVersionService.getProtocolVersion(PROTOCOL_NUMBER, Integer.valueOf(2));
        ProtocolVersionServiceTest.assertNotNull((Object)protocol);
        ProtocolVersionServiceTest.assertEquals((Object)new Integer(2), (Object)protocol.getSequenceNumber());
    }
}

