/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.funding;

import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.protocol.funding.AddProtocolFundingSourceEvent;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceRule;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceService;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.rice.krad.document.Document;

public class AddProtocolFundingSourceTest {
    private Mockery context = new JUnit4Mockery();
    private final String goodFundingSourceId = "000100";
    private final String goodFundingSourceName = "Air Force";
    private final String badFundingSourceId = "goober99";
    private final String badFundingSourceName = "";
    private ProtocolFundingSource fundingSource;
    private ProtocolFundingSource badFundingSource;
    private List<ProtocolFundingSource> protocolFundingSources;
    private List<ProtocolFundingSource> emptyProtocolFundingSources;
    private ProtocolDocument doc = null;

    @Before
    public void setUp() throws Exception {
        this.fundingSource = new ProtocolFundingSource("000100", "1", "Air Force", "");
        this.protocolFundingSources = new ArrayList<ProtocolFundingSource>();
        this.protocolFundingSources.add(this.fundingSource);
        this.emptyProtocolFundingSources = new ArrayList<ProtocolFundingSource>();
        this.badFundingSource = new ProtocolFundingSource("goober99", "1", "", "");
    }

    @Test
    public void testSimple() {
        new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", (Document)AddProtocolFundingSourceTest.this.doc, AddProtocolFundingSourceTest.this.fundingSource, AddProtocolFundingSourceTest.this.emptyProtocolFundingSources);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setBusinessObjectService(null);
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)AddProtocolFundingSourceTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testDuplicate() {
        TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule> theTest = new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", (Document)AddProtocolFundingSourceTest.this.doc, AddProtocolFundingSourceTest.this.fundingSource, AddProtocolFundingSourceTest.this.protocolFundingSources);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setBusinessObjectService(null);
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)AddProtocolFundingSourceTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                Assert.assertTrue((boolean)this.getErrorMap().containsMessageKey("error.protocolFundingSource.fundingSource.duplicate"));
            }
        };
        theTest.checkRuleAssertions();
    }

    @Test
    public void testNullFundingSource() {
        TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule> theTest = new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", (Document)AddProtocolFundingSourceTest.this.doc, null, AddProtocolFundingSourceTest.this.protocolFundingSources);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setBusinessObjectService(null);
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)AddProtocolFundingSourceTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                Assert.assertTrue((boolean)this.getErrorMap().containsMessageKey("error.protocolFundingSource.fundingSourceType.notFound"));
            }
        };
        theTest.checkRuleAssertions();
    }

    @Test
    public void testBlankNumberFundingSource() {
        TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule> theTest = new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                AddProtocolFundingSourceTest.this.fundingSource.setFundingSourceNumber("");
                this.event = new AddProtocolFundingSourceEvent("", (Document)AddProtocolFundingSourceTest.this.doc, AddProtocolFundingSourceTest.this.fundingSource, AddProtocolFundingSourceTest.this.protocolFundingSources);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setBusinessObjectService(null);
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)AddProtocolFundingSourceTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                Assert.assertTrue((boolean)this.getErrorMap().containsMessageKey("error.protocolFundingSource.fundingSourceNumber.notFound"));
            }
        };
        theTest.checkRuleAssertions();
    }

    @Test
    public void testBlankNameFundingSource() {
        TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule> theTest = new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                AddProtocolFundingSourceTest.this.fundingSource.setFundingSourceName("");
                this.event = new AddProtocolFundingSourceEvent("", (Document)AddProtocolFundingSourceTest.this.doc, AddProtocolFundingSourceTest.this.fundingSource, AddProtocolFundingSourceTest.this.protocolFundingSources);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setBusinessObjectService(null);
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)AddProtocolFundingSourceTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                Assert.assertTrue((boolean)this.getErrorMap().containsMessageKey("error.protocolFundingSource.fundingSourceName.notFound"));
            }
        };
        theTest.checkRuleAssertions();
    }

    @Test
    public void testNullTypeFundingSource() {
        TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule> theTest = new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                AddProtocolFundingSourceTest.this.fundingSource.setFundingSourceTypeCode(null);
                this.event = new AddProtocolFundingSourceEvent("", (Document)AddProtocolFundingSourceTest.this.doc, AddProtocolFundingSourceTest.this.fundingSource, AddProtocolFundingSourceTest.this.protocolFundingSources);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setBusinessObjectService(null);
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)AddProtocolFundingSourceTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                Assert.assertTrue((boolean)this.getErrorMap().containsMessageKey("error.protocolFundingSource.fundingSourceType.notFound"));
            }
        };
        theTest.checkRuleAssertions();
    }

    @Test
    public void testInvalidNumberTypeFundingSource() {
        TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule> theTest = new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", (Document)AddProtocolFundingSourceTest.this.doc, AddProtocolFundingSourceTest.this.badFundingSource, AddProtocolFundingSourceTest.this.protocolFundingSources);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setBusinessObjectService(null);
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)AddProtocolFundingSourceTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                Assert.assertTrue((boolean)this.getErrorMap().containsMessageKey("error.protocolFundingSource.fundingSourceNumber.invalidForType"));
            }
        };
        theTest.checkRuleAssertions();
    }

    protected ProtocolFundingSourceService getProtocolFundingSourceService() {
        final ProtocolFundingSourceService protocolFundingSourceService = (ProtocolFundingSourceService)this.context.mock(ProtocolFundingSourceService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolFundingSourceService)this.allowing(protocolFundingSourceService)).isValidIdForType((ProtocolFundingSourceBase)AddProtocolFundingSourceTest.this.fundingSource);
                this.will(8.returnValue((Object)true));
                ((ProtocolFundingSourceService)this.one(protocolFundingSourceService)).isValidIdForType((ProtocolFundingSourceBase)AddProtocolFundingSourceTest.this.badFundingSource);
                this.will(8.returnValue((Object)false));
                ((ProtocolFundingSourceService)this.allowing(protocolFundingSourceService)).isEditable(AddProtocolFundingSourceTest.this.fundingSource.getFundingSourceTypeCode());
                this.will(8.returnValue((Object)true));
            }
        });
        return protocolFundingSourceService;
    }
}

