/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.funding;

import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.FundingSourceType;
import org.kuali.kra.irb.protocol.funding.AddProtocolFundingSourceEvent;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceRule;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceService;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class ProtocolFundingSourceRuleTest
extends KcUnitTestBase {
    private Mockery context = new JUnit4Mockery();
    private FundingSourceType fundingSponsorSourceType;
    private ProtocolFundingSource goodFundingSource;
    private ProtocolFundingSource badFundingSourceNoName;
    private ProtocolFundingSource badFundingSourceNoId;
    private ProtocolFundingSource badFundingSourceNoType;
    private ProtocolFundingSource badFundingSourceInvalidId;
    private ArrayList<ProtocolFundingSource> list = new ArrayList();
    private ArrayList<ProtocolFundingSource> duplicateList = new ArrayList();

    @Override
    @Before
    public void setUp() throws Exception {
        this.fundingSponsorSourceType = new FundingSourceType();
        this.fundingSponsorSourceType.setFundingSourceTypeCode("1");
        this.fundingSponsorSourceType.setFundingSourceTypeFlag(true);
        this.fundingSponsorSourceType.setDescription("Sponsor");
        this.goodFundingSource = new ProtocolFundingSource("000108", "1", "NAME", "TITLE");
        this.badFundingSourceNoId = new ProtocolFundingSource("", "1", "123", null);
        this.badFundingSourceNoName = new ProtocolFundingSource("123", "1", "", null);
        this.badFundingSourceNoType = new ProtocolFundingSource("123", null, "123", null);
        this.badFundingSourceInvalidId = new ProtocolFundingSource("100", "1", "COOLNESS", null);
        this.duplicateList.add(this.goodFundingSource);
    }

    @Test
    public void testSuccess() {
        new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", null, ProtocolFundingSourceRuleTest.this.goodFundingSource, (List)ProtocolFundingSourceRuleTest.this.list);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)ProtocolFundingSourceRuleTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testDuplicate() {
        new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", null, ProtocolFundingSourceRuleTest.this.goodFundingSource, (List)ProtocolFundingSourceRuleTest.this.duplicateList);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)ProtocolFundingSourceRuleTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testInvalidId() {
        new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", null, ProtocolFundingSourceRuleTest.this.badFundingSourceInvalidId, (List)ProtocolFundingSourceRuleTest.this.list);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)ProtocolFundingSourceRuleTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testNoId() {
        new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", null, ProtocolFundingSourceRuleTest.this.badFundingSourceNoId, (List)ProtocolFundingSourceRuleTest.this.list);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)ProtocolFundingSourceRuleTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testNoType() {
        new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", null, ProtocolFundingSourceRuleTest.this.badFundingSourceNoType, (List)ProtocolFundingSourceRuleTest.this.list);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)ProtocolFundingSourceRuleTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testNoName() {
        new TemplateRuleTest<AddProtocolFundingSourceEvent, ProtocolFundingSourceRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolFundingSourceEvent("", null, ProtocolFundingSourceRuleTest.this.badFundingSourceNoName, (List)ProtocolFundingSourceRuleTest.this.list);
                this.rule = new ProtocolFundingSourceRule();
                ((ProtocolFundingSourceRule)this.rule).setProtocolFundingSourceService((org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceService)ProtocolFundingSourceRuleTest.this.getProtocolFundingSourceService());
                this.expectedReturnValue = false;
            }
        };
    }

    protected ProtocolFundingSourceService getProtocolFundingSourceService() {
        final ProtocolFundingSourceService service = (ProtocolFundingSourceService)this.context.mock(ProtocolFundingSourceService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ProtocolFundingSourceService)this.allowing(service)).isValidIdForType((ProtocolFundingSourceBase)ProtocolFundingSourceRuleTest.this.goodFundingSource);
                this.will(7.returnValue((Object)true));
                ((ProtocolFundingSourceService)this.allowing(service)).isValidIdForType((ProtocolFundingSourceBase)ProtocolFundingSourceRuleTest.this.badFundingSourceNoId);
                this.will(7.returnValue((Object)true));
                ((ProtocolFundingSourceService)this.allowing(service)).isValidIdForType((ProtocolFundingSourceBase)ProtocolFundingSourceRuleTest.this.badFundingSourceNoName);
                this.will(7.returnValue((Object)true));
                ((ProtocolFundingSourceService)this.allowing(service)).isValidIdForType((ProtocolFundingSourceBase)ProtocolFundingSourceRuleTest.this.badFundingSourceNoType);
                this.will(7.returnValue((Object)true));
                ((ProtocolFundingSourceService)this.allowing(service)).isValidIdForType((ProtocolFundingSourceBase)ProtocolFundingSourceRuleTest.this.badFundingSourceInvalidId);
                this.will(7.returnValue((Object)false));
                ((ProtocolFundingSourceService)this.allowing(service)).isEditable(ProtocolFundingSourceRuleTest.this.fundingSponsorSourceType.getFundingSourceTypeCode());
                this.will(7.returnValue((Object)true));
            }
        });
        return service;
    }
}

