/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.funding;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.matchers.JUnitMatchers;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.bo.FundingSourceType;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.institutionalproposal.home.InstitutionalProposal;
import org.kuali.kra.institutionalproposal.service.InstitutionalProposalService;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSourceServiceImpl;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.protocol.protocol.funding.ProtocolFundingSourceBase;
import org.kuali.kra.service.FundingSourceTypeService;
import org.kuali.kra.service.SponsorService;
import org.kuali.kra.service.UnitService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.krad.service.BusinessObjectService;

public class ProtocolFundingSourceServiceTest
extends KcUnitTestBase {
    private Mockery context = new JUnit4Mockery();
    private ProtocolFundingSourceServiceImpl protocolFundingSourceService;
    private final String emptyNumber = "";
    private final String sponsorNumberBad = "-1";
    private Sponsor sponsorGood;
    private final String sponsorNumberAirForce = "000108";
    private String sponsorNameAirForce;
    private final String unitNumberGood = "000001";
    private final String unitNameGood = "University";
    private final String unitNumberBad = "zzzzz";
    private final String otherNumberGood = "otherId";
    private final String otherNameGood = "otherName";
    private final String devProposalNumberGood = "1";
    private final String devProposalTitleGood = "DevPropTitle";
    private final String devProposalNumberBad = "zzzzz";
    private DevelopmentProposal devProposalGood;
    private final String instProposalNumberGood = "00000001";
    private final String instProposalTitleGood = "Institutional Proposal Title";
    private final String instProposalNumberBad = "zzzzzzzz";
    private InstitutionalProposal instProposalGood;
    private final String awardNumberGood = "000001-00001";
    private final String awardTitleGood = "AwardTitle";
    private final String awardNumberBad = "zzzzzz-zzzzz";
    private Award awardGood;
    private final String sponsorSourceTypeId = "1";
    private final String unitSourceTypeId = "2";
    private final String otherSourceTypeId = "3";
    private final String developmentPropSourceTypeId = "4";
    private final String institutePropSourceTypeId = "5";
    private final String awardSourceTypeId = "6";
    private final String protocolFundingSource = "protocolHelper.newFundingSource.fundingSource";
    private final String protocolFundingSourceNumber = "protocolHelper.newFundingSource.fundingSourceNumber";
    private final String protocolFundingSourceName = "protocolHelper.newFundingSource.fundingSourceName";
    private final String protocolFundingSourceTitle = "protocolHelper.newFundingSource.fundingSourceTitle";
    private FundingSourceType fundingSponsorSourceType;
    private FundingSourceType fundingUnitSourceType;
    private FundingSourceType fundingOtherSourceType;
    private FundingSourceType fundingDevProposalSourceType;
    private FundingSourceType fundingInstProposalSourceType;
    private FundingSourceType fundingAwardSourceType;

    @Override
    @Before
    public void setUp() throws Exception {
        this.fundingSponsorSourceType = new FundingSourceType();
        this.fundingSponsorSourceType.setFundingSourceTypeCode("1");
        this.fundingSponsorSourceType.setFundingSourceTypeFlag(true);
        this.fundingSponsorSourceType.setDescription("Sponsor");
        this.fundingUnitSourceType = new FundingSourceType();
        this.fundingUnitSourceType.setFundingSourceTypeCode("2");
        this.fundingUnitSourceType.setFundingSourceTypeFlag(true);
        this.fundingUnitSourceType.setDescription("Unit");
        this.fundingOtherSourceType = new FundingSourceType();
        this.fundingOtherSourceType.setFundingSourceTypeCode("3");
        this.fundingOtherSourceType.setFundingSourceTypeFlag(true);
        this.fundingOtherSourceType.setDescription("Other");
        this.fundingDevProposalSourceType = new FundingSourceType();
        this.fundingDevProposalSourceType.setFundingSourceTypeCode("4");
        this.fundingDevProposalSourceType.setFundingSourceTypeFlag(true);
        this.fundingDevProposalSourceType.setDescription("Proposal Development");
        this.fundingInstProposalSourceType = new FundingSourceType();
        this.fundingInstProposalSourceType.setFundingSourceTypeCode("5");
        this.fundingInstProposalSourceType.setFundingSourceTypeFlag(true);
        this.fundingInstProposalSourceType.setDescription("Institutional Proposal");
        this.fundingAwardSourceType = new FundingSourceType();
        this.fundingAwardSourceType.setFundingSourceTypeCode("6");
        this.fundingAwardSourceType.setFundingSourceTypeFlag(true);
        this.fundingAwardSourceType.setDescription("Award");
        this.sponsorGood = ((SponsorService)KraServiceLocator.getService(SponsorService.class)).getSponsor("000108");
        this.sponsorNameAirForce = this.sponsorGood.getSponsorName();
        this.devProposalGood = new DevelopmentProposal();
        this.devProposalGood.setTitle("DevPropTitle");
        this.devProposalGood.setSponsor(this.sponsorGood);
        this.instProposalGood = new InstitutionalProposal();
        this.instProposalGood.setTitle("Institutional Proposal Title");
        this.instProposalGood.setSponsor(this.sponsorGood);
        this.awardGood = new Award();
        this.awardGood.setTitle("AwardTitle");
        this.awardGood.setSponsor(this.sponsorGood);
    }

    @Test
    public void testCalculateSponsorFunding() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setSponsorService(this.getSponsorService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("1", "000108", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceName().equalsIgnoreCase(this.sponsorNameAirForce));
    }

    @Test
    public void testCalculateSponsorFundingSourceBadId() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setSponsorService(this.getSponsorService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("1", "-1", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertNull((Object)fundingSource.getFundingSourceName());
    }

    @Test
    public void testCalculateSponsorFundingSourceEmptyId() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setSponsorService(this.getSponsorService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("1", "", null);
        ProtocolFundingSourceServiceTest.assertNull((Object)fundingSource);
    }

    @Test
    public void testCalculateUnitFunding() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setUnitService(this.getUnitService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("2", "000001", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource.getFundingSourceName());
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceName().equalsIgnoreCase("University"));
    }

    @Test
    public void testCalculateUnitFundingSourceBadId() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setUnitService(this.getUnitService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("2", "zzzzz", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertNull((Object)fundingSource.getFundingSourceName());
    }

    @Test
    public void testCalculateUnitFundingSourceEmptyId() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        UnitService unitService = (UnitService)this.context.mock(UnitService.class);
        this.protocolFundingSourceService.setUnitService(unitService);
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("2", "", null);
        ProtocolFundingSourceServiceTest.assertNull((Object)fundingSource);
    }

    @Test
    public void testCalculateOtherFunding() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("3", "otherId", "otherName");
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource.getFundingSourceName());
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceName().equalsIgnoreCase("otherName"));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)StringUtils.isEmpty((String)fundingSource.getFundingSourceTitle()));
    }

    @Test
    public void testCalculateOtherFundingEmptyId() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("3", "", null);
        ProtocolFundingSourceServiceTest.assertNull((Object)fundingSource);
    }

    @Test
    public void testCalculateDevProposalFunding() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        this.protocolFundingSourceService.setBusinessObjectService(this.getBusinessObjectService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("4", "1", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource.getFundingSourceName());
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceName().equalsIgnoreCase(this.sponsorNameAirForce));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceTitle().equalsIgnoreCase("DevPropTitle"));
    }

    @Test
    public void testCalculateDevProposalFundingBadID() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        this.protocolFundingSourceService.setBusinessObjectService(this.getBusinessObjectService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("4", "zzzzz", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertTrue((boolean)StringUtils.isEmpty((String)fundingSource.getFundingSourceName()));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)StringUtils.isEmpty((String)fundingSource.getFundingSourceTitle()));
    }

    @Test
    public void testCalculateDevProposalFundingNegativeEmptyID() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        this.protocolFundingSourceService.setBusinessObjectService(this.getBusinessObjectService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("4", "", null);
        ProtocolFundingSourceServiceTest.assertNull((Object)fundingSource);
    }

    @Test
    public void testCalculateInstProposalFunding() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        this.protocolFundingSourceService.setInstitutionalProposalService(this.getInstProposalService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setBusinessObjectService(this.getBusinessObjectService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("5", "00000001", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource.getFundingSourceName());
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceName().equalsIgnoreCase(this.sponsorNameAirForce));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceTitle().equalsIgnoreCase("Institutional Proposal Title"));
    }

    @Test
    public void testCalculateInstProposalFundingBadIdGoodNumber() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        this.protocolFundingSourceService.setInstitutionalProposalService(this.getInstProposalService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setBusinessObjectService(this.getBusinessObjectService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("5", "00000001", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource.getFundingSourceName());
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceName().equalsIgnoreCase(this.sponsorNameAirForce));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceTitle().equalsIgnoreCase("Institutional Proposal Title"));
    }

    @Test
    public void testCalculateInstProposalFundingBadIdBadNumber() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        this.protocolFundingSourceService.setInstitutionalProposalService(this.getInstProposalService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setBusinessObjectService(this.getBusinessObjectService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("5", "zzzzzzzz", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertTrue((boolean)StringUtils.isEmpty((String)fundingSource.getFundingSourceName()));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)StringUtils.isEmpty((String)fundingSource.getFundingSourceTitle()));
    }

    @Test
    public void testCalculateInstProposalFundingNegativeEmpty() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        this.protocolFundingSourceService.setInstitutionalProposalService(this.getInstProposalService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setBusinessObjectService(this.getBusinessObjectService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("5", "", null);
        ProtocolFundingSourceServiceTest.assertNull((Object)fundingSource);
    }

    @Test
    public void testCalculateAwardFunding() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setAwardService(this.getAwardService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("6", "000001-00001", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource.getFundingSourceName());
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceName().equalsIgnoreCase(this.sponsorNameAirForce));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceTitle().equalsIgnoreCase("AwardTitle"));
    }

    @Test
    public void testCalculateAwardFundingBadIdGoodNumber() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setAwardService(this.getAwardService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("6", "000001-00001", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource.getFundingSourceName());
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceName().equalsIgnoreCase(this.sponsorNameAirForce));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)fundingSource.getFundingSourceTitle().equalsIgnoreCase("AwardTitle"));
    }

    @Test
    public void testCalculateAwardFundingBadIdBadNumber() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setAwardService(this.getAwardService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("6", "zzzzzz-zzzzz", null);
        ProtocolFundingSourceServiceTest.assertNotNull((Object)fundingSource);
        ProtocolFundingSourceServiceTest.assertTrue((boolean)StringUtils.isEmpty((String)fundingSource.getFundingSourceName()));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)StringUtils.isEmpty((String)fundingSource.getFundingSourceTitle()));
    }

    @Test
    public void testCalculateAwardFundingEmptyId() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setAwardService(this.getAwardService());
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        ProtocolFundingSource fundingSource = (ProtocolFundingSource)this.protocolFundingSourceService.updateProtocolFundingSource("6", "", null);
        ProtocolFundingSourceServiceTest.assertNull((Object)fundingSource);
    }

    @Test
    public void testIsValidIdForTypeSponsor() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setSponsorService(this.getSponsorService());
        ProtocolFundingSource fundingSource = new ProtocolFundingSource("000108", "1", null, null);
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isValidIdForType((ProtocolFundingSourceBase)fundingSource));
        fundingSource = new ProtocolFundingSource("-1", "1", null, null);
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isValidIdForType((ProtocolFundingSourceBase)fundingSource));
    }

    @Test
    public void testIsValidIdForTypeUnit() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setUnitService(this.getUnitService());
        ProtocolFundingSource fundingSource = new ProtocolFundingSource("000001", "2", null, null);
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isValidIdForType((ProtocolFundingSourceBase)fundingSource));
        fundingSource = new ProtocolFundingSource("zzzzz", "2", null, null);
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isValidIdForType((ProtocolFundingSourceBase)fundingSource));
    }

    @Test
    public void testIsValidIdForTypeOther() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        ProtocolFundingSource fundingSource = new ProtocolFundingSource("3", "3", "otherName", null);
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isValidIdForType((ProtocolFundingSourceBase)fundingSource));
        fundingSource = new ProtocolFundingSource("3", "3", "", null);
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isValidIdForType((ProtocolFundingSourceBase)fundingSource));
    }

    @Test
    public void testIsValidIdForTypeAward() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setFundingSourceTypeService(this.getFundingSourceTypeService());
        this.protocolFundingSourceService.setAwardService(this.getAwardService());
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        ProtocolFundingSource fundingSource = new ProtocolFundingSource("000001-00001", "6", null, null);
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isValidIdForType((ProtocolFundingSourceBase)fundingSource));
        fundingSource = new ProtocolFundingSource("zzzzzz-zzzzz", "6", null, null);
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isValidIdForType((ProtocolFundingSourceBase)fundingSource));
    }

    @Test
    public void testGetLookupParameters() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        StringBuilder builder = new StringBuilder();
        Map.Entry entry = this.protocolFundingSourceService.getLookupParameters("1");
        Assert.assertNotNull((Object)entry);
        builder.append("sponsorCode:protocolHelper.newFundingSource.fundingSourceNumber,");
        builder.append("sponsorName:protocolHelper.newFundingSource.fundingSourceName");
        Assert.assertThat(entry.getValue(), (Matcher)JUnitMatchers.containsString((String)builder.toString()));
        builder.delete(0, builder.length());
        entry = this.protocolFundingSourceService.getLookupParameters("2");
        Assert.assertNotNull((Object)entry);
        builder.append("unitNumber:protocolHelper.newFundingSource.fundingSourceNumber,");
        builder.append("unitName:protocolHelper.newFundingSource.fundingSourceName");
        Assert.assertThat(entry.getValue(), (Matcher)JUnitMatchers.containsString((String)builder.toString()));
        builder.delete(0, builder.length());
        entry = this.protocolFundingSourceService.getLookupParameters("4");
        Assert.assertNotNull((Object)entry);
        builder.append("proposalNumber:protocolHelper.newFundingSource.fundingSourceNumber,");
        builder.append("sponsor.sponsorName:protocolHelper.newFundingSource.fundingSourceName,");
        builder.append("title:protocolHelper.newFundingSource.fundingSourceTitle");
        Assert.assertThat(entry.getValue(), (Matcher)JUnitMatchers.containsString((String)builder.toString()));
        builder.delete(0, builder.length());
        entry = this.protocolFundingSourceService.getLookupParameters("5");
        Assert.assertNotNull((Object)entry);
        builder.append("proposalId:protocolHelper.newFundingSource.fundingSource,");
        builder.append("proposalNumber:protocolHelper.newFundingSource.fundingSourceNumber,");
        builder.append("sponsor.sponsorName:protocolHelper.newFundingSource.fundingSourceName,");
        builder.append("title:protocolHelper.newFundingSource.fundingSourceTitle");
        Assert.assertThat(entry.getValue(), (Matcher)JUnitMatchers.containsString((String)builder.toString()));
        builder.delete(0, builder.length());
        entry = this.protocolFundingSourceService.getLookupParameters("6");
        Assert.assertNotNull((Object)entry);
        builder.append("awardId:protocolHelper.newFundingSource.fundingSource,");
        builder.append("awardNumber:protocolHelper.newFundingSource.fundingSourceNumber,");
        builder.append("sponsor.sponsorName:protocolHelper.newFundingSource.fundingSourceName,");
        builder.append("title:protocolHelper.newFundingSource.fundingSourceTitle");
        Assert.assertThat(entry.getValue(), (Matcher)JUnitMatchers.containsString((String)builder.toString()));
        try {
            entry = this.protocolFundingSourceService.getLookupParameters("3");
            ProtocolFundingSourceServiceTest.fail((String)"IllegalArgumentException was not thrown for invalid test case using OTHER");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testUpdateLookupParameter() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        Map.Entry entry = this.protocolFundingSourceService.getLookupParameters("1");
        Assert.assertNotNull((Object)entry);
        String fieldConversions = (String)entry.getValue();
        StringBuilder builder = new StringBuilder();
        builder.append("sponsorCode:protocolHelper.newFundingSource.fundingSourceNumber,");
        builder.append("sponsorName:protocolHelper.newFundingSource.fundingSourceName");
        Assert.assertThat(entry.getValue(), (Matcher)JUnitMatchers.containsString((String)builder.toString()));
        String parameter = "(!!!!)((()))";
        String updatedParam = this.protocolFundingSourceService.updateLookupParameter(parameter, "org.kuali.kra.bo.Sponsor", fieldConversions);
        Assert.assertThat((Object)updatedParam, (Matcher)JUnitMatchers.containsString((String)("(!!org.kuali.kra.bo.Sponsor!!)(((" + builder.toString() + ")))")));
    }

    @Test
    public void testIsLookupableFundingSource() throws Exception {
        String badFundingTypeCode = "-99";
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isLookupable("3"));
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isLookupable(badFundingTypeCode));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isLookupable("5"));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isLookupable("2"));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isLookupable("1"));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isLookupable("6"));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isLookupable("4"));
    }

    @Test
    public void testUpdateSourceNameEditable() throws Exception {
        this.protocolFundingSourceService = new ProtocolFundingSourceServiceImpl();
        this.protocolFundingSourceService.setParameterService(this.getParameterService());
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isEditable("5"));
        ProtocolFundingSourceServiceTest.assertTrue((boolean)this.protocolFundingSourceService.isEditable("3"));
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isEditable("6"));
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isEditable("4"));
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isEditable("1"));
        ProtocolFundingSourceServiceTest.assertFalse((boolean)this.protocolFundingSourceService.isEditable("2"));
    }

    protected SponsorService getSponsorService() {
        final SponsorService sponsorService = (SponsorService)this.context.mock(SponsorService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SponsorService)this.allowing(sponsorService)).getSponsorName("000108");
                this.will(1.returnValue((Object)ProtocolFundingSourceServiceTest.this.sponsorNameAirForce));
                ((SponsorService)this.allowing(sponsorService)).getSponsorName("-1");
                this.will(1.returnValue(null));
            }
        });
        return sponsorService;
    }

    protected UnitService getUnitService() {
        final UnitService unitService = (UnitService)this.context.mock(UnitService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((UnitService)this.allowing(unitService)).getUnitName("000001");
                this.will(2.returnValue((Object)"University"));
                ((UnitService)this.allowing(unitService)).getUnitName("zzzzz");
                this.will(2.returnValue(null));
            }
        });
        return unitService;
    }

    @Override
    protected BusinessObjectService getBusinessObjectService() {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(DevelopmentProposal.class, (Object)"1");
                this.will(3.returnValue((Object)ProtocolFundingSourceServiceTest.this.devProposalGood));
                ((BusinessObjectService)this.allowing(businessObjectService)).findBySinglePrimaryKey(DevelopmentProposal.class, (Object)"zzzzz");
                this.will(3.returnValue(null));
            }
        });
        return businessObjectService;
    }

    protected InstitutionalProposalService getInstProposalService() {
        final InstitutionalProposalService institutionalProposalService = (InstitutionalProposalService)this.context.mock(InstitutionalProposalService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((InstitutionalProposalService)this.allowing(institutionalProposalService)).getActiveInstitutionalProposalVersion("00000001");
                this.will(4.returnValue((Object)ProtocolFundingSourceServiceTest.this.instProposalGood));
                ((InstitutionalProposalService)this.allowing(institutionalProposalService)).getActiveInstitutionalProposalVersion("zzzzzzzz");
                this.will(4.returnValue(null));
                ((InstitutionalProposalService)this.allowing(institutionalProposalService)).getPendingInstitutionalProposalVersion("00000001");
                this.will(4.returnValue((Object)ProtocolFundingSourceServiceTest.this.instProposalGood));
                ((InstitutionalProposalService)this.allowing(institutionalProposalService)).getPendingInstitutionalProposalVersion("zzzzzzzz");
                this.will(4.returnValue(null));
            }
        });
        return institutionalProposalService;
    }

    protected AwardService getAwardService() {
        final AwardService awardService = (AwardService)this.context.mock(AwardService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((AwardService)this.allowing(awardService)).findAwardsForAwardNumber("000001-00001");
                this.will(5.returnValue(Collections.singletonList(ProtocolFundingSourceServiceTest.this.awardGood)));
                ((AwardService)this.allowing(awardService)).findAwardsForAwardNumber("zzzzzz-zzzzz");
                this.will(5.returnValue(Collections.emptyList()));
            }
        });
        return awardService;
    }

    @Override
    protected ParameterService getParameterService() {
        final ParameterService parameterService = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.allowing(parameterService)).parameterExists((Class)this.with(6.any(Class.class)), (String)this.with(6.any(String.class)));
                this.will(6.returnValue((Object)true));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsBoolean(ProtocolDocument.class, "irb.protocol.award.linking.enabled");
                this.will(6.returnValue((Object)true));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsBoolean(ProtocolDocument.class, "irb.protocol.development.proposal.linking.enabled");
                this.will(6.returnValue((Object)true));
                ((ParameterService)this.allowing(parameterService)).getParameterValueAsBoolean(ProtocolDocument.class, "irb.protocol.institute.proposal.linking.enabled");
                this.will(6.returnValue((Object)true));
            }
        });
        return parameterService;
    }

    protected FundingSourceTypeService getFundingSourceTypeService() {
        final FundingSourceTypeService service = (FundingSourceTypeService)this.context.mock(FundingSourceTypeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((FundingSourceTypeService)this.allowing(service)).getFundingSourceType("1");
                this.will(7.returnValue((Object)ProtocolFundingSourceServiceTest.this.fundingSponsorSourceType));
                ((FundingSourceTypeService)this.allowing(service)).getFundingSourceType("2");
                this.will(7.returnValue((Object)ProtocolFundingSourceServiceTest.this.fundingUnitSourceType));
                ((FundingSourceTypeService)this.allowing(service)).getFundingSourceType("3");
                this.will(7.returnValue((Object)ProtocolFundingSourceServiceTest.this.fundingOtherSourceType));
                ((FundingSourceTypeService)this.allowing(service)).getFundingSourceType("4");
                this.will(7.returnValue((Object)ProtocolFundingSourceServiceTest.this.fundingDevProposalSourceType));
                ((FundingSourceTypeService)this.allowing(service)).getFundingSourceType("5");
                this.will(7.returnValue((Object)ProtocolFundingSourceServiceTest.this.fundingInstProposalSourceType));
                ((FundingSourceTypeService)this.allowing(service)).getFundingSourceType("6");
                this.will(7.returnValue((Object)ProtocolFundingSourceServiceTest.this.fundingAwardSourceType));
            }
        });
        return service;
    }
}

