/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.location;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.protocol.location.AddProtocolLocationEvent;
import org.kuali.kra.irb.protocol.location.ProtocolLocation;
import org.kuali.kra.irb.protocol.location.ProtocolLocationRule;
import org.kuali.kra.irb.protocol.location.ProtocolOrganizationType;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.protocol.protocol.location.ProtocolOrganizationTypeBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ProtocolLocationRuleTest
extends ProtocolRuleTestBase {
    private static final String NEW_PROTOCOL_LOCATION = "protocolHelper.newProtocolLocation";
    private ProtocolLocationRule rule = null;
    private List<ProtocolOrganizationType> protocolOrganizationTypeList;
    private BusinessObjectService bos;
    protected static final String NEW_ORGANIZATION_VALUE = "000002";
    protected static final String OLD_ORGANIZATION_VALUE = "000001";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProtocolLocationRule();
        this.bos = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.protocolOrganizationTypeList = (List)this.bos.findAll(ProtocolOrganizationType.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        this.bos = null;
        this.protocolOrganizationTypeList = null;
        super.tearDown();
    }

    @Test
    public void checkOrganizationTypes() {
        ProtocolLocationRuleTest.assertNotNull(this.protocolOrganizationTypeList);
        ProtocolLocationRuleTest.assertTrue((this.protocolOrganizationTypeList.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAddProtocolLocationOK() throws Exception {
        ProtocolLocation newProtocolLocation = new ProtocolLocation();
        newProtocolLocation.setProtocolOrganizationType((ProtocolOrganizationTypeBase)this.protocolOrganizationTypeList.get(0));
        newProtocolLocation.setProtocolOrganizationTypeCode(this.protocolOrganizationTypeList.get(0).getProtocolOrganizationTypeCode());
        newProtocolLocation.setOrganizationId(NEW_ORGANIZATION_VALUE);
        ProtocolLocationRuleTest.assertTrue((boolean)this.rule.processAddProtocolLocationBusinessRules((org.kuali.kra.protocol.protocol.location.AddProtocolLocationEvent)this.getAddProtocolLocationEvent(newProtocolLocation)));
    }

    @Test
    public void testAddProtocolLocationInValid() throws Exception {
        ProtocolLocation newProtocolLocation = new ProtocolLocation();
        newProtocolLocation.setProtocolOrganizationType((ProtocolOrganizationTypeBase)this.protocolOrganizationTypeList.get(0));
        newProtocolLocation.setProtocolOrganizationTypeCode(this.protocolOrganizationTypeList.get(0).getProtocolOrganizationTypeCode());
        newProtocolLocation.setOrganizationId(OLD_ORGANIZATION_VALUE);
        ProtocolLocationRuleTest.assertFalse((boolean)this.rule.processAddProtocolLocationBusinessRules((org.kuali.kra.protocol.protocol.location.AddProtocolLocationEvent)this.getAddProtocolLocationEvent(newProtocolLocation)));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("protocolHelper.newProtocolLocation.organizationId");
        ProtocolLocationRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProtocolLocationRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.protocolLocation.organizationId.duplicate");
    }

    private AddProtocolLocationEvent getAddProtocolLocationEvent(ProtocolLocation newProtocolLocation) throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        AddProtocolLocationEvent event = new AddProtocolLocationEvent("", document, newProtocolLocation);
        return event;
    }
}

