/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.participant;

import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.kuali.kra.irb.protocol.participant.AddProtocolParticipantEvent;
import org.kuali.kra.irb.protocol.participant.AddProtocolParticipantRule;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.rice.kns.datadictionary.validation.charlevel.NumericValidationPattern;

public class ProtocolParticipantRuleTest
extends ProtocolRuleTestBase {
    private static final String CHILDREN_PARTICIPANT_TYPE_CD = "1";
    private static final String OTHER_PARTICIPANT_TYPE_CD = "10";
    private static final Integer NEW_PARTICIPANT_COUNT = 5;
    private static final Integer NEW_PARTICIPANT_NEG_COUNT = -5;
    private static final String NEW_PROTOCOL_PARTICIPANT_FIELD = "protocolHelper.newProtocolParticipant";
    private static final String DOT = ".";
    private static final String PARTICIPANT_TYPE_CODE_FIELD = "participantTypeCode";
    private static final String PARTICIPANT_COUNT_FIELD = "participantCount";

    @Test
    public void testAddProtocolParticipantWithCount() throws Exception {
        new TemplateRuleTest<AddProtocolParticipantEvent, AddProtocolParticipantRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolParticipantEvent(null, ProtocolParticipantRuleTest.this.getProtocolParticipant(ProtocolParticipantRuleTest.OTHER_PARTICIPANT_TYPE_CD, NEW_PARTICIPANT_COUNT), ProtocolParticipantRuleTest.this.getProtocolParticipants());
                this.rule = new AddProtocolParticipantRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testAddProtocolParticipantWithoutCount() throws Exception {
        new TemplateRuleTest<AddProtocolParticipantEvent, AddProtocolParticipantRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolParticipantEvent(null, ProtocolParticipantRuleTest.this.getProtocolParticipant(ProtocolParticipantRuleTest.OTHER_PARTICIPANT_TYPE_CD, null), ProtocolParticipantRuleTest.this.getProtocolParticipants());
                this.rule = new AddProtocolParticipantRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testAddProtocolParticipantWithNegCount() throws Exception {
        new TemplateRuleTest<AddProtocolParticipantEvent, AddProtocolParticipantRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolParticipantEvent(null, ProtocolParticipantRuleTest.this.getProtocolParticipant(ProtocolParticipantRuleTest.CHILDREN_PARTICIPANT_TYPE_CD, NEW_PARTICIPANT_NEG_COUNT), ProtocolParticipantRuleTest.this.getProtocolParticipants());
                this.rule = new AddProtocolParticipantRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolParticipantRuleTest.this.assertError(ProtocolParticipantRuleTest.PARTICIPANT_COUNT_FIELD, "error.format." + NumericValidationPattern.class.getName());
            }
        };
    }

    @Test
    public void testAddDuplicateProtocolParticipant() throws Exception {
        new TemplateRuleTest<AddProtocolParticipantEvent, AddProtocolParticipantRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolParticipantEvent(null, ProtocolParticipantRuleTest.this.getProtocolParticipant(ProtocolParticipantRuleTest.CHILDREN_PARTICIPANT_TYPE_CD, NEW_PARTICIPANT_COUNT), ProtocolParticipantRuleTest.this.getProtocolParticipants());
                this.rule = new AddProtocolParticipantRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolParticipantRuleTest.this.assertError("protocolHelper.newProtocolParticipant.participantTypeCode", "error.protocol.participantType.duplicate");
            }
        };
    }

    @Test
    public void testAddUnspecifiedProtocolParticipant() throws Exception {
        new TemplateRuleTest<AddProtocolParticipantEvent, AddProtocolParticipantRule>(){

            @Override
            protected void prerequisite() {
                this.event = new AddProtocolParticipantEvent(null, ProtocolParticipantRuleTest.this.getProtocolParticipant("", NEW_PARTICIPANT_COUNT), ProtocolParticipantRuleTest.this.getProtocolParticipants());
                this.rule = new AddProtocolParticipantRule();
                this.expectedReturnValue = false;
            }

            @Override
            public void checkRuleAssertions() {
                ProtocolParticipantRuleTest.this.assertError(ProtocolParticipantRuleTest.PARTICIPANT_TYPE_CODE_FIELD, "error.required");
            }
        };
    }

    private ProtocolParticipant getProtocolParticipant(String participantTypeCode, Integer participantCount) {
        ProtocolParticipant participant = new ProtocolParticipant();
        participant.setParticipantTypeCode(participantTypeCode);
        participant.setParticipantCount(participantCount);
        return participant;
    }

    private List<ProtocolParticipant> getProtocolParticipants() {
        ArrayList<ProtocolParticipant> participants = new ArrayList<ProtocolParticipant>();
        ProtocolParticipant participant = this.getProtocolParticipant(CHILDREN_PARTICIPANT_TYPE_CD, NEW_PARTICIPANT_COUNT);
        participants.add(participant);
        return participants;
    }
}

