/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.questionnaire;

import java.util.ArrayList;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewModule;
import org.kuali.kra.irb.actions.amendrenew.ProtocolAmendRenewal;
import org.kuali.kra.irb.questionnaire.ProtocolModuleQuestionnaireBean;
import org.kuali.kra.irb.questionnaire.ProtocolQuestionnaireAuditRule;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.protocol.actions.amendrenew.ProtocolAmendRenewalBase;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireUsage;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.ModuleQuestionnaireBean;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.rice.krad.document.Document;

public class ProtocolQuestionnaireAuditRuleTest
extends ProtocolRuleTestBase {
    private Mockery context = new JUnit4Mockery();
    private ProtocolQuestionnaireAuditRule rule;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testProcessRunAuditBusinessRules() throws Exception {
        List<Questionnaire> questionnaire = this.getQuestionnaire("4");
        AnswerHeader hdr1 = this.getAnswerHeader(questionnaire.get(0), true);
        AnswerHeader hdr2 = this.getAnswerHeader(questionnaire.get(1), true);
        AnswerHeader hdr3 = this.getAnswerHeader(questionnaire.get(2), true);
        AnswerHeader hdr4 = this.getAnswerHeader(questionnaire.get(3), true);
        AnswerHeader hdr5 = this.getAnswerHeader(questionnaire.get(4), true);
        AnswerHeader hdr6 = this.getAnswerHeader(questionnaire.get(5), true);
        AnswerHeader hdr7 = this.getAnswerHeader(questionnaire.get(6), true);
        final ArrayList<AnswerHeader> headers1 = new ArrayList<AnswerHeader>();
        headers1.add(hdr1);
        headers1.add(hdr2);
        headers1.add(hdr3);
        headers1.add(hdr4);
        headers1.add(hdr5);
        Protocol defaultProtocol = this.getNewProtocolDocument().getProtocol();
        defaultProtocol.setProtocolNumber("0");
        final ProtocolModuleQuestionnaireBean defModule = new ProtocolModuleQuestionnaireBean(defaultProtocol);
        final QuestionnaireAnswerService qnnrService1 = (QuestionnaireAnswerService)this.context.mock(QuestionnaireAnswerService.class, "case1");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionnaireAnswerService)this.allowing(qnnrService1)).getQuestionnaireAnswer((ModuleQuestionnaireBean)defModule);
                this.will(1.returnValue((Object)headers1));
            }
        });
        this.rule = new ProtocolQuestionnaireAuditRule(){

            protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
                return qnnrService1;
            }
        };
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr2.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr2.setCompleted(true);
        hdr5.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr5.setCompleted(true);
        hdr1.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr1.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr3.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr3.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr4.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr4.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr1.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr1.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr2.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr2.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr3.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr3.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr4.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr4.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr5.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        hdr5.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)defaultProtocol.getProtocolDocument()));
        final ArrayList<AnswerHeader> headers2 = new ArrayList<AnswerHeader>();
        headers2.add(hdr1);
        headers2.add(hdr2);
        headers2.add(hdr3);
        headers2.add(hdr6);
        headers2.add(hdr7);
        Protocol amendmentProtocol = this.getNewProtocolDocument().getProtocol();
        amendmentProtocol.setProtocolAmendRenewal((ProtocolAmendRenewalBase)new ProtocolAmendRenewal());
        amendmentProtocol.setProtocolNumber("0A");
        final ProtocolModuleQuestionnaireBean amendModule = new ProtocolModuleQuestionnaireBean(amendmentProtocol);
        final QuestionnaireAnswerService qnnrService2 = (QuestionnaireAnswerService)this.context.mock(QuestionnaireAnswerService.class, "case2");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionnaireAnswerService)this.allowing(qnnrService2)).getQuestionnaireAnswer((ModuleQuestionnaireBean)amendModule);
                this.will(3.returnValue((Object)headers2));
            }
        });
        this.rule = new ProtocolQuestionnaireAuditRule(){

            protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
                return qnnrService2;
            }
        };
        hdr2.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr2.setCompleted(true);
        hdr3.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr3.setCompleted(true);
        hdr7.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr7.setCompleted(true);
        hdr6.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr6.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr1.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr1.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr1.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr1.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr2.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr2.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr3.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr3.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr6.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr6.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr7.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr7.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        ProtocolAmendRenewModule parm = new ProtocolAmendRenewModule();
        parm.setProtocolModuleTypeCode("026");
        amendmentProtocol.getProtocolAmendRenewal().getModules().add(parm);
        final ArrayList<AnswerHeader> amendmentHeaders = new ArrayList<AnswerHeader>();
        amendmentHeaders.add(hdr1);
        amendmentHeaders.add(hdr2);
        amendmentHeaders.add(hdr3);
        amendmentHeaders.add(hdr6);
        amendmentHeaders.add(hdr7);
        final ArrayList<AnswerHeader> defHeaders = new ArrayList<AnswerHeader>();
        defHeaders.add(hdr1);
        defHeaders.add(hdr2);
        defHeaders.add(hdr3);
        defHeaders.add(hdr4);
        defHeaders.add(hdr5);
        final ProtocolModuleQuestionnaireBean defAmendModule = new ProtocolModuleQuestionnaireBean("7", amendmentProtocol.getProtocolNumber(), "0", amendmentProtocol.getSequenceNumber().toString(), amendmentProtocol.getProtocolDocument().getDocumentHeader().getWorkflowDocument().isApproved());
        final QuestionnaireAnswerService qnnrService3 = (QuestionnaireAnswerService)this.context.mock(QuestionnaireAnswerService.class, "case3");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionnaireAnswerService)this.allowing(qnnrService3)).getQuestionnaireAnswer((ModuleQuestionnaireBean)amendModule);
                this.will(5.returnValue((Object)amendmentHeaders));
                ((QuestionnaireAnswerService)this.allowing(qnnrService3)).getQuestionnaireAnswer((ModuleQuestionnaireBean)defAmendModule);
                this.will(5.returnValue((Object)defHeaders));
            }
        });
        this.rule = new ProtocolQuestionnaireAuditRule(){

            protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
                return qnnrService3;
            }
        };
        hdr2.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr2.setCompleted(true);
        hdr5.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr5.setCompleted(true);
        hdr1.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr1.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr3.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr3.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr4.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
        hdr4.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)amendmentProtocol.getProtocolDocument()));
    }

    @Test
    public void testProcessRunRenewalAuditBusinessRules() throws Exception {
        List<Questionnaire> questionnaire = this.getQuestionnaire("3");
        AnswerHeader hdr1 = this.getAnswerHeader(questionnaire.get(0), true);
        AnswerHeader hdr2 = this.getAnswerHeader(questionnaire.get(1), true);
        AnswerHeader hdr3 = this.getAnswerHeader(questionnaire.get(2), true);
        AnswerHeader hdr4 = this.getAnswerHeader(questionnaire.get(3), true);
        AnswerHeader hdr5 = this.getAnswerHeader(questionnaire.get(4), true);
        AnswerHeader hdr6 = this.getAnswerHeader(questionnaire.get(5), true);
        AnswerHeader hdr7 = this.getAnswerHeader(questionnaire.get(6), true);
        ArrayList<AnswerHeader> headers1 = new ArrayList<AnswerHeader>();
        headers1.add(hdr1);
        headers1.add(hdr2);
        headers1.add(hdr3);
        headers1.add(hdr4);
        headers1.add(hdr5);
        final ArrayList<AnswerHeader> headers2 = new ArrayList<AnswerHeader>();
        headers2.add(hdr1);
        headers2.add(hdr2);
        headers2.add(hdr3);
        headers2.add(hdr6);
        headers2.add(hdr7);
        Protocol renewalProtocol = this.getNewProtocolDocument().getProtocol();
        renewalProtocol.setProtocolAmendRenewal((ProtocolAmendRenewalBase)new ProtocolAmendRenewal());
        renewalProtocol.setProtocolNumber("0R");
        final ProtocolModuleQuestionnaireBean renewalModule = new ProtocolModuleQuestionnaireBean(renewalProtocol);
        final QuestionnaireAnswerService qnnrService2 = (QuestionnaireAnswerService)this.context.mock(QuestionnaireAnswerService.class, "case2");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((QuestionnaireAnswerService)this.allowing(qnnrService2)).getQuestionnaireAnswer((ModuleQuestionnaireBean)renewalModule);
                this.will(7.returnValue((Object)headers2));
            }
        });
        this.rule = new ProtocolQuestionnaireAuditRule(){

            protected QuestionnaireAnswerService getQuestionnaireAnswerService() {
                return qnnrService2;
            }
        };
        hdr2.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr2.setCompleted(true);
        hdr3.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr3.setCompleted(true);
        hdr7.setCompleted(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr7.setCompleted(true);
        hdr6.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr6.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr1.setCompleted(false);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr1.setCompleted(true);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr1.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr1.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr2.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr2.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr3.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr3.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr6.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr6.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr7.setNewerVersionPublished(true);
        Assert.assertFalse((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
        hdr7.setNewerVersionPublished(false);
        Assert.assertTrue((boolean)this.rule.processRunAuditBusinessRules((Document)renewalProtocol.getProtocolDocument()));
    }

    protected List<Questionnaire> getQuestionnaire(String subModule) {
        ArrayList<Questionnaire> questionnaire = new ArrayList<Questionnaire>();
        QuestionnaireUsage defNonMandatoryUsage1 = this.getUsage("7", "0", 1, false);
        QuestionnaireUsage defMandatoryUsage1 = this.getUsage("7", "0", 2, true);
        QuestionnaireUsage amenRenNonMandatoryUsage1 = this.getUsage("7", subModule, 1, false);
        QuestionnaireUsage amenRenMandatoryUsage1 = this.getUsage("7", subModule, 2, true);
        ArrayList<QuestionnaireUsage> usages1 = new ArrayList<QuestionnaireUsage>();
        usages1.add(defNonMandatoryUsage1);
        usages1.add(defMandatoryUsage1);
        usages1.add(amenRenNonMandatoryUsage1);
        usages1.add(amenRenMandatoryUsage1);
        Questionnaire questionnaire1 = new Questionnaire();
        questionnaire1.setQuestionnaireUsages(usages1);
        questionnaire.add(questionnaire1);
        QuestionnaireUsage defNonMandatoryUsage2 = this.getUsage("7", "0", 1, true);
        QuestionnaireUsage defMandatoryUsage2 = this.getUsage("7", "0", 2, false);
        QuestionnaireUsage amenRenNonMandatoryUsage2 = this.getUsage("7", subModule, 1, true);
        QuestionnaireUsage amenRenMandatoryUsage2 = this.getUsage("7", subModule, 2, false);
        ArrayList<QuestionnaireUsage> usages2 = new ArrayList<QuestionnaireUsage>();
        usages2.add(defNonMandatoryUsage2);
        usages2.add(defMandatoryUsage2);
        usages2.add(amenRenNonMandatoryUsage2);
        usages2.add(amenRenMandatoryUsage2);
        Questionnaire questionnaire2 = new Questionnaire();
        questionnaire2.setQuestionnaireUsages(usages2);
        questionnaire.add(questionnaire2);
        QuestionnaireUsage defNonMandatoryUsage3 = this.getUsage("7", "0", 1, false);
        QuestionnaireUsage defMandatoryUsage3 = this.getUsage("7", "0", 2, true);
        QuestionnaireUsage amenRenMandatoryUsage3 = this.getUsage("7", subModule, 1, true);
        QuestionnaireUsage amenRenNonMandatoryUsage3 = this.getUsage("7", subModule, 2, false);
        ArrayList<QuestionnaireUsage> usages3 = new ArrayList<QuestionnaireUsage>();
        usages3.add(defNonMandatoryUsage3);
        usages3.add(defMandatoryUsage3);
        usages3.add(amenRenNonMandatoryUsage3);
        usages3.add(amenRenMandatoryUsage3);
        Questionnaire questionnaire3 = new Questionnaire();
        questionnaire3.setQuestionnaireUsages(usages3);
        questionnaire.add(questionnaire3);
        QuestionnaireUsage defNonMandatoryUsage4 = this.getUsage("7", "0", 1, false);
        QuestionnaireUsage defMandatoryUsage4 = this.getUsage("7", "0", 2, true);
        ArrayList<QuestionnaireUsage> usages4 = new ArrayList<QuestionnaireUsage>();
        usages4.add(defNonMandatoryUsage4);
        usages4.add(defMandatoryUsage4);
        Questionnaire questionnaire4 = new Questionnaire();
        questionnaire4.setQuestionnaireUsages(usages4);
        questionnaire.add(questionnaire4);
        QuestionnaireUsage defNonMandatoryUsage5 = this.getUsage("7", "0", 1, true);
        QuestionnaireUsage defMandatoryUsage5 = this.getUsage("7", "0", 2, false);
        ArrayList<QuestionnaireUsage> usages5 = new ArrayList<QuestionnaireUsage>();
        usages5.add(defNonMandatoryUsage5);
        usages5.add(defMandatoryUsage5);
        Questionnaire questionnaire5 = new Questionnaire();
        questionnaire5.setQuestionnaireUsages(usages5);
        questionnaire.add(questionnaire5);
        QuestionnaireUsage amenRenNonMandatoryUsage6 = this.getUsage("7", subModule, 1, false);
        QuestionnaireUsage amenRenMandatoryUsage6 = this.getUsage("7", subModule, 2, true);
        ArrayList<QuestionnaireUsage> usages6 = new ArrayList<QuestionnaireUsage>();
        usages6.add(amenRenNonMandatoryUsage6);
        usages6.add(amenRenMandatoryUsage6);
        Questionnaire questionnaire6 = new Questionnaire();
        questionnaire6.setQuestionnaireUsages(usages6);
        questionnaire.add(questionnaire6);
        QuestionnaireUsage amenRenNonMandatoryUsage7 = this.getUsage("7", subModule, 1, true);
        QuestionnaireUsage amenRenMandatoryUsage7 = this.getUsage("7", subModule, 2, false);
        ArrayList<QuestionnaireUsage> usages7 = new ArrayList<QuestionnaireUsage>();
        usages7.add(amenRenNonMandatoryUsage7);
        usages7.add(amenRenMandatoryUsage7);
        Questionnaire questionnaire7 = new Questionnaire();
        questionnaire7.setQuestionnaireUsages(usages7);
        questionnaire.add(questionnaire7);
        return questionnaire;
    }

    private QuestionnaireUsage getUsage(String moduleCode, String subModuleCode, int qnnrSeqNumber, boolean mandatory) {
        QuestionnaireUsage usage = new QuestionnaireUsage();
        usage.setQuestionnaireSequenceNumber(Integer.valueOf(qnnrSeqNumber));
        usage.setModuleItemCode(moduleCode);
        usage.setModuleSubItemCode(subModuleCode);
        usage.setMandatory(mandatory);
        return usage;
    }

    private AnswerHeader getAnswerHeader(Questionnaire qnnr, boolean completed) {
        AnswerHeader header = new AnswerHeader();
        header.setQuestionnaire(qnnr);
        header.setCompleted(completed);
        return header;
    }
}

