/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.reference;

import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.protocol.reference.AddProtocolReferenceEvent;
import org.kuali.kra.irb.protocol.reference.ProtocolReferenceBean;
import org.kuali.kra.irb.protocol.reference.ProtocolReferenceRule;
import org.kuali.kra.irb.protocol.reference.ProtocolReferenceType;
import org.kuali.kra.irb.test.ProtocolRuleTestBase;
import org.kuali.kra.protocol.protocol.reference.AddProtocolReferenceEventBase;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public class ProtocolReferenceRuleTest
extends ProtocolRuleTestBase {
    private static final String NEW_PROTOCOLREFERENCE = "newProtocolReferenceBean";
    private ProtocolReferenceRule rule = null;
    private List<ProtocolReferenceType> protocolReferenceList;
    private BusinessObjectService bos;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.rule = new ProtocolReferenceRule();
        this.bos = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.protocolReferenceList = (List)this.bos.findAll(ProtocolReferenceType.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.rule = null;
        this.bos = null;
        this.protocolReferenceList = null;
        super.tearDown();
    }

    @Test
    public void checkCodes() {
        ProtocolReferenceRuleTest.assertNotNull(this.protocolReferenceList);
        ProtocolReferenceRuleTest.assertTrue((this.protocolReferenceList.size() > 1 ? 1 : 0) != 0);
    }

    @Test
    public void testOK() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolReferenceBean newProtocolReference = new ProtocolReferenceBean();
        newProtocolReference.setProtocolReferenceTypeCode(this.protocolReferenceList.get(0).getProtocolReferenceTypeCode());
        newProtocolReference.setReferenceKey("Test Me");
        AddProtocolReferenceEvent event = new AddProtocolReferenceEvent("", document, newProtocolReference);
        ProtocolReferenceRuleTest.assertTrue((boolean)this.rule.processAddProtocolReferenceBusinessRules((AddProtocolReferenceEventBase)event));
    }

    @Test
    public void testNotValid() throws Exception {
        ProtocolDocument document = this.getNewProtocolDocument();
        ProtocolReferenceBean newProtocolReferenceBean = new ProtocolReferenceBean();
        AddProtocolReferenceEvent event = new AddProtocolReferenceEvent("", document, newProtocolReferenceBean);
        ProtocolReferenceRuleTest.assertFalse((boolean)this.rule.processAddProtocolReferenceBusinessRules((AddProtocolReferenceEventBase)event));
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages("newProtocolReferenceBean.protocolReferenceTypeCode");
        ProtocolReferenceRuleTest.assertEquals((long)1L, (long)errors.size());
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProtocolReferenceRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.required.for.protocolReference.protocolReferenceTypeCode");
        errors = GlobalVariables.getMessageMap().getMessages("newProtocolReferenceBean.referenceKey");
        ProtocolReferenceRuleTest.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        message = (ErrorMessage)errors.get(0);
        ProtocolReferenceRuleTest.assertEquals((Object)message.getErrorKey(), (Object)"error.required.for.protocolReference.protocolReferenceKey");
    }
}

