/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.research;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.irb.protocol.research.ProtocolResearchAreaService;
import org.kuali.kra.irb.protocol.research.ProtocolResearchAreaServiceImpl;
import org.kuali.kra.protocol.ProtocolBase;

public class ProtocolResearchAreaServiceTest {
    private ResearchArea bo1;
    private ResearchArea bo2;
    private ResearchArea bo3;
    private List<ResearchArea> listOfResearchArea;
    private Protocol protocol;
    private ProtocolResearchAreaService service;

    @Before
    public void setUp() throws Exception {
        this.bo1 = new ResearchArea();
        this.bo1.setResearchAreaCode("1");
        this.bo1.setDescription("Test1");
        this.bo2 = new ResearchArea();
        this.bo2.setResearchAreaCode("2");
        this.bo2.setDescription("Test2");
        this.listOfResearchArea = new ArrayList<ResearchArea>();
        this.listOfResearchArea.add(this.bo1);
        this.listOfResearchArea.add(this.bo2);
        this.protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        this.protocol.setProtocolId(Long.valueOf(1L));
        this.service = new ProtocolResearchAreaServiceImpl();
    }

    @Test
    public void testAddProtocolResearchArea() throws Exception {
        this.service.addProtocolResearchArea((ProtocolBase)this.protocol, this.listOfResearchArea);
        Assert.assertEquals((long)2L, (long)this.protocol.getProtocolResearchAreas().size());
    }

    @Test
    public void testAddProtocolResearchAreaForDuplicate() throws Exception {
        this.service.addProtocolResearchArea((ProtocolBase)this.protocol, this.listOfResearchArea);
        Assert.assertEquals((long)2L, (long)this.protocol.getProtocolResearchAreas().size());
        this.bo3 = new ResearchArea();
        this.bo3.setResearchAreaCode("3");
        this.bo3.setDescription("Test3");
        this.listOfResearchArea.add(this.bo3);
        this.service.addProtocolResearchArea((ProtocolBase)this.protocol, this.listOfResearchArea);
        Assert.assertEquals((long)3L, (long)this.protocol.getProtocolResearchAreas().size());
    }
}

