/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.protocol.summary;

import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.AffiliationType;
import org.kuali.kra.bo.AttachmentFile;
import org.kuali.kra.bo.ExemptionType;
import org.kuali.kra.bo.FundingSourceType;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.ResearchAreaBase;
import org.kuali.kra.bo.SpecialReviewApprovalType;
import org.kuali.kra.bo.SpecialReviewType;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.ResearchArea;
import org.kuali.kra.irb.actions.ProtocolStatus;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentProtocol;
import org.kuali.kra.irb.noteattachment.ProtocolAttachmentType;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.irb.protocol.ProtocolType;
import org.kuali.kra.irb.protocol.funding.ProtocolFundingSource;
import org.kuali.kra.irb.protocol.location.ProtocolLocation;
import org.kuali.kra.irb.protocol.location.ProtocolOrganizationType;
import org.kuali.kra.irb.protocol.participant.ParticipantType;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.protocol.research.ProtocolResearchArea;
import org.kuali.kra.irb.specialreview.ProtocolSpecialReview;
import org.kuali.kra.irb.specialreview.ProtocolSpecialReviewExemption;
import org.kuali.kra.irb.summary.ParticipantSummary;
import org.kuali.kra.irb.test.ProtocolFactory;
import org.kuali.kra.protocol.actions.ProtocolStatusBase;
import org.kuali.kra.protocol.noteattachment.ProtocolAttachmentTypeBase;
import org.kuali.kra.protocol.protocol.ProtocolTypeBase;
import org.kuali.kra.protocol.protocol.location.ProtocolOrganizationTypeBase;
import org.kuali.kra.protocol.summary.AttachmentSummary;
import org.kuali.kra.protocol.summary.FundingSourceSummary;
import org.kuali.kra.protocol.summary.OrganizationSummary;
import org.kuali.kra.protocol.summary.PersonnelSummary;
import org.kuali.kra.protocol.summary.ProtocolSummary;
import org.kuali.kra.protocol.summary.ResearchAreaSummary;
import org.kuali.kra.protocol.summary.SpecialReviewSummary;
import org.kuali.kra.protocol.summary.UnitSummary;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;

public class ProtocolSummaryTest
extends KcUnitTestBase {
    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static final String PROTOCOL_NUMBER = "666";
    private static final String PRINCIPAL_INVESTIGATOR_NAME = "Terry Durkin";
    private static final String FDA_APP_NUMBER = "999";
    private static final String PROTOCOL_TYPE = "test";
    private static final String PROTOCOL_STATUS = "my status";
    private static final String TITLE = "my title";
    private static final long TEN_DAYS = 864000000L;
    private static final String REFERENCE_NUMBER_1 = "ref 1";
    private static final String REFERENCE_NUMBER_2 = "ref 2";
    private static final String DESCRIPTION = "whatever";
    private static final Object PRINCIPAL_INVESTIGATOR = "Principal Investigator";
    private static final Object UNIT_NUMBER = "BL-BL";
    private static final Object UNIT_NAME = "BLOOMINGTON CAMPUS";
    private static final String RA_DESCRIPTION = "Rocket Science";
    private static final String RA_CODE = "09.101";
    private static final String FILE_NAME = "foo.doc";
    private static final String FUNDING_SOURCE_NUMBER = "333";
    private static final String FUNDING_SOURCE_NAME = "funding name";
    private static final String FUNDING_SOURCE_TITLE = "funding title";
    private static final String FUNDING_DESCRIPTION = "funding description";
    private static final String PARTICIPANT_DESCRIPTION = "participant description";
    private static final Integer PARTICIPANT_COUNT = 5;
    private static final String ORGANIZATION_NAME = "org name";
    private static final String ORGANIZATION_TYPE = "org type";
    private static final String ORGANIZATION_FWA_NUMBER = "org fwa number";
    private static final String SPECIAL_REVIEW_DESCRIPTION = "sp description";
    private static final String SPECIAL_REVIEW_APPROVAL_TYPE_DESCRIPTION = "sp approval type";
    private static final String EXEMPTION_DESCRIPTION = "E1";
    private static final String COMMENT = "sp comment";
    private static final String NEW_PRINCIPAL_INVESTIGATOR_ID = "000000003";
    private static final String NEW_PRINCIPAL_INVESTIGATOR_NAME = "Molly Dog";
    private static final String NEW_PRINCIPAL_INVESTIGATOR_UNIT = "000001";
    private static final String NEW_PRINCIPAL_INVESTIGATOR_ROLE = "PI";
    private static final String NEW_REFERENCE_UNIT = "unit";
    private ProtocolDocument protocolDocument;
    private Date initialSubmissionDate;
    private Date approvalDate;
    private Date lastApprovalDate;
    private Date expirationDate;
    private ProtocolType protocolType;
    private ProtocolStatus protocolStatus;
    private ResearchArea researchArea;
    private FundingSourceType fundingType;
    private ParticipantType participantType;
    private Organization organization;
    private ProtocolOrganizationType organizationType;
    private SpecialReviewType mySpecialReviewType;
    private Date specialReviewApplicationDate;
    private SpecialReviewApprovalType specialReviewApprovalType;
    private List<org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewExemption> specialReviewExemptions;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.initialSubmissionDate = new Date(System.currentTimeMillis() - 1728000000L);
        this.approvalDate = new Date(System.currentTimeMillis() - 864000000L);
        this.lastApprovalDate = new Date(System.currentTimeMillis());
        this.expirationDate = new Date(System.currentTimeMillis() + 864000000L);
        this.protocolType = new ProtocolType();
        this.protocolType.setDescription(PROTOCOL_TYPE);
        this.protocolStatus = new ProtocolStatus();
        this.protocolStatus.setDescription(PROTOCOL_STATUS);
        this.researchArea = new ResearchArea();
        this.researchArea.setDescription(RA_DESCRIPTION);
        this.researchArea.setResearchAreaCode(RA_CODE);
        this.fundingType = new FundingSourceType();
        this.fundingType.setDescription(FUNDING_DESCRIPTION);
        this.participantType = new ParticipantType();
        this.participantType.setDescription(PARTICIPANT_DESCRIPTION);
        this.organizationType = new ProtocolOrganizationType();
        this.organizationType.setDescription(ORGANIZATION_TYPE);
        this.organization = new Organization();
        this.organization.setOrganizationName(ORGANIZATION_NAME);
        this.organization.setHumanSubAssurance(ORGANIZATION_FWA_NUMBER);
        this.mySpecialReviewType = new SpecialReviewType();
        this.mySpecialReviewType.setDescription(SPECIAL_REVIEW_DESCRIPTION);
        this.specialReviewApplicationDate = new Date(System.currentTimeMillis() - 1728000000L);
        this.specialReviewApprovalType = new SpecialReviewApprovalType();
        this.specialReviewApprovalType.setDescription(SPECIAL_REVIEW_APPROVAL_TYPE_DESCRIPTION);
        this.specialReviewExemptions = new ArrayList<org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewExemption>();
        ProtocolSpecialReviewExemption specialReviewExemption = new ProtocolSpecialReviewExemption();
        ExemptionType exemptionType = new ExemptionType();
        exemptionType.setDescription(EXEMPTION_DESCRIPTION);
        specialReviewExemption.setExemptionType(exemptionType);
        this.specialReviewExemptions.add((org.kuali.kra.protocol.specialreview.ProtocolSpecialReviewExemption)specialReviewExemption);
        this.protocolDocument = this.createProtocolDocument();
    }

    @Test
    public void testSummaryCreation() {
        org.kuali.kra.irb.summary.ProtocolSummary summary = this.protocolDocument.getProtocol().getProtocolSummary();
        ProtocolSummaryTest.assertNotNull((Object)summary);
        ProtocolSummaryTest.assertEquals((Object)PROTOCOL_NUMBER, (Object)summary.getProtocolNumber());
        ProtocolSummaryTest.assertEquals((Object)dateFormat.format(this.initialSubmissionDate), (Object)summary.getInitialSubmissionDate());
        ProtocolSummaryTest.assertEquals((Object)dateFormat.format(this.approvalDate), (Object)summary.getApprovalDate());
        ProtocolSummaryTest.assertEquals((Object)dateFormat.format(this.lastApprovalDate), (Object)summary.getLastApprovalDate());
        ProtocolSummaryTest.assertEquals((Object)dateFormat.format(this.expirationDate), (Object)summary.getExpirationDate());
        ProtocolSummaryTest.assertEquals((Object)this.protocolType.getDescription(), (Object)summary.getType());
        ProtocolSummaryTest.assertEquals((Object)this.protocolStatus.getDescription(), (Object)summary.getStatus());
        ProtocolSummaryTest.assertEquals((Object)TITLE, (Object)summary.getTitle());
        ProtocolSummaryTest.assertEquals((Object)PRINCIPAL_INVESTIGATOR_NAME, (Object)summary.getPiName());
        ProtocolSummaryTest.assertEquals((Object)FDA_APP_NUMBER, (Object)summary.getAdditionalInfo().getFdaApplicationNumber());
        ProtocolSummaryTest.assertEquals((Object)REFERENCE_NUMBER_1, (Object)summary.getAdditionalInfo().getReferenceId1());
        ProtocolSummaryTest.assertEquals((Object)REFERENCE_NUMBER_2, (Object)summary.getAdditionalInfo().getReferenceId2());
        ProtocolSummaryTest.assertEquals((Object)DESCRIPTION, (Object)summary.getAdditionalInfo().getDescription());
        ProtocolSummaryTest.assertEquals((long)1L, (long)summary.getPersons().size());
        ProtocolSummaryTest.assertEquals((Object)PRINCIPAL_INVESTIGATOR_NAME, (Object)((PersonnelSummary)summary.getPersons().get(0)).getName());
        ProtocolSummaryTest.assertEquals((Object)PRINCIPAL_INVESTIGATOR, (Object)((PersonnelSummary)summary.getPersons().get(0)).getRoleName());
        ProtocolSummaryTest.assertEquals((Object)"", (Object)((PersonnelSummary)summary.getPersons().get(0)).getAffiliation());
        ProtocolSummaryTest.assertEquals((long)1L, (long)((PersonnelSummary)summary.getPersons().get(0)).getUnits().size());
        ProtocolSummaryTest.assertEquals((Object)UNIT_NUMBER, (Object)((UnitSummary)((PersonnelSummary)summary.getPersons().get(0)).getUnits().get(0)).getUnitNumber());
        ProtocolSummaryTest.assertEquals((Object)UNIT_NAME, (Object)((UnitSummary)((PersonnelSummary)summary.getPersons().get(0)).getUnits().get(0)).getUnitName());
        ProtocolSummaryTest.assertEquals((long)1L, (long)summary.getResearchAreas().size());
        ProtocolSummaryTest.assertEquals((Object)RA_CODE, (Object)((ResearchAreaSummary)summary.getResearchAreas().get(0)).getResearchAreaCode());
        ProtocolSummaryTest.assertEquals((Object)RA_DESCRIPTION, (Object)((ResearchAreaSummary)summary.getResearchAreas().get(0)).getDescription());
        ProtocolSummaryTest.assertEquals((long)1L, (long)summary.getAttachments().size());
        ProtocolSummaryTest.assertEquals((Object)FILE_NAME, (Object)((AttachmentSummary)summary.getAttachments().get(0)).getFileName());
        ProtocolSummaryTest.assertEquals((long)1L, (long)summary.getFundingSources().size());
        ProtocolSummaryTest.assertEquals((Object)FUNDING_SOURCE_NUMBER, (Object)((FundingSourceSummary)summary.getFundingSources().get(0)).getFundingSource());
        ProtocolSummaryTest.assertEquals((Object)FUNDING_SOURCE_NAME, (Object)((FundingSourceSummary)summary.getFundingSources().get(0)).getFundingSourceName());
        ProtocolSummaryTest.assertEquals((Object)FUNDING_DESCRIPTION, (Object)((FundingSourceSummary)summary.getFundingSources().get(0)).getFundingSourceType());
        ProtocolSummaryTest.assertEquals((Object)FUNDING_SOURCE_TITLE, (Object)((FundingSourceSummary)summary.getFundingSources().get(0)).getFundingSourceTitle());
        ProtocolSummaryTest.assertEquals((long)1L, (long)summary.getParticipants().size());
        ProtocolSummaryTest.assertEquals((Object)PARTICIPANT_DESCRIPTION, (Object)((ParticipantSummary)summary.getParticipants().get(0)).getDescription());
        ProtocolSummaryTest.assertEquals((Object)PARTICIPANT_COUNT.toString(), (Object)((ParticipantSummary)summary.getParticipants().get(0)).getCount());
        ProtocolSummaryTest.assertEquals((long)2L, (long)summary.getOrganizations().size());
        ProtocolSummaryTest.assertEquals((Object)ORGANIZATION_NAME, (Object)((OrganizationSummary)summary.getOrganizations().get(1)).getName());
        ProtocolSummaryTest.assertEquals((Object)ORGANIZATION_TYPE, (Object)((OrganizationSummary)summary.getOrganizations().get(1)).getType());
        ProtocolSummaryTest.assertEquals((Object)ORGANIZATION_FWA_NUMBER, (Object)((OrganizationSummary)summary.getOrganizations().get(1)).getFwaNumber());
        ProtocolSummaryTest.assertEquals((long)1L, (long)summary.getSpecialReviews().size());
        ProtocolSummaryTest.assertEquals((Object)dateFormat.format(this.specialReviewApplicationDate), (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).getApplicationDate());
        ProtocolSummaryTest.assertEquals((Object)dateFormat.format(this.approvalDate), (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).getApprovalDate());
        ProtocolSummaryTest.assertEquals((Object)dateFormat.format(this.expirationDate), (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).getExpirationDate());
        ProtocolSummaryTest.assertEquals((Object)PROTOCOL_NUMBER, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).getProtocolNumber());
        ProtocolSummaryTest.assertEquals((Object)COMMENT, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).getComment());
        ProtocolSummaryTest.assertEquals((Object)SPECIAL_REVIEW_APPROVAL_TYPE_DESCRIPTION, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).getApprovalStatus());
        ProtocolSummaryTest.assertEquals((Object)SPECIAL_REVIEW_DESCRIPTION, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).getType());
        ProtocolSummaryTest.assertEquals((Object)EXEMPTION_DESCRIPTION, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).getExemptionNumbers());
    }

    @Test
    public void testCompareForNoChanges() {
        org.kuali.kra.irb.summary.ProtocolSummary summary1 = this.protocolDocument.getProtocol().getProtocolSummary();
        org.kuali.kra.irb.summary.ProtocolSummary summary2 = this.protocolDocument.getProtocol().getProtocolSummary();
        summary1.compare((ProtocolSummary)summary2);
        this.verifyComparison(summary1, false);
        summary2.compare((ProtocolSummary)summary1);
        this.verifyComparison(summary2, false);
    }

    @Test
    public void testCompareForChanges() throws Exception {
        org.kuali.kra.irb.summary.ProtocolSummary summary1 = this.protocolDocument.getProtocol().getProtocolSummary();
        Protocol protocol = ProtocolFactory.createProtocolDocument(FDA_APP_NUMBER).getProtocol();
        this.changePI(protocol);
        org.kuali.kra.irb.summary.ProtocolSummary summary2 = protocol.getProtocolSummary();
        summary1.compare((ProtocolSummary)summary2);
        this.verifyComparison(summary1, true);
        summary2.compare((ProtocolSummary)summary1);
        this.verifyComparison(summary2, true);
    }

    private void verifyComparison(org.kuali.kra.irb.summary.ProtocolSummary summary, boolean expected) {
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.isProtocolNumberChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.isInitialSubmissionDateChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.isApprovalDateChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.isLastApprovalDateChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.isExpirationDateChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.isTypeChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.isStatusChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.isTitleChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.isPiNameChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.getAdditionalInfo().isFdaApplicationNumberChanged());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.getAdditionalInfo().isReferenceId1Changed());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.getAdditionalInfo().isReferenceId2Changed());
        ProtocolSummaryTest.assertEquals((Object)expected, (Object)summary.getAdditionalInfo().isDescriptionChanged());
        if (summary.getPersons().size() > 0) {
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((PersonnelSummary)summary.getPersons().get(0)).isNameChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((PersonnelSummary)summary.getPersons().get(0)).isRoleNameChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((PersonnelSummary)summary.getPersons().get(0)).isAffiliationChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((UnitSummary)((PersonnelSummary)summary.getPersons().get(0)).getUnits().get(0)).isChanged());
        }
        if (summary.getResearchAreas().size() > 0) {
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((ResearchAreaSummary)summary.getResearchAreas().get(0)).isChanged());
        }
        if (summary.getAttachments().size() > 0) {
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((AttachmentSummary)summary.getAttachments().get(0)).isFileNameChanged());
        }
        if (summary.getFundingSources().size() > 0) {
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((FundingSourceSummary)summary.getFundingSources().get(0)).isFundingSourceChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((FundingSourceSummary)summary.getFundingSources().get(0)).isFundingSourceNameChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((FundingSourceSummary)summary.getFundingSources().get(0)).isFundingSourceTypeChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((FundingSourceSummary)summary.getFundingSources().get(0)).isFundingSourceTitleChanged());
        }
        if (summary.getParticipants().size() > 0) {
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((ParticipantSummary)summary.getParticipants().get(0)).isDescriptionChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((ParticipantSummary)summary.getParticipants().get(0)).isCountChanged());
        }
        if (summary.getOrganizations().size() > 0) {
            ProtocolSummaryTest.assertEquals((Object)false, (Object)((OrganizationSummary)summary.getOrganizations().get(0)).isNameChanged());
            ProtocolSummaryTest.assertEquals((Object)false, (Object)((OrganizationSummary)summary.getOrganizations().get(0)).isTypeChanged());
            ProtocolSummaryTest.assertEquals((Object)false, (Object)((OrganizationSummary)summary.getOrganizations().get(0)).isFwaNumberChanged());
            if (summary.getOrganizations().size() > 1) {
                ProtocolSummaryTest.assertEquals((Object)expected, (Object)((OrganizationSummary)summary.getOrganizations().get(1)).isNameChanged());
                ProtocolSummaryTest.assertEquals((Object)expected, (Object)((OrganizationSummary)summary.getOrganizations().get(1)).isTypeChanged());
                ProtocolSummaryTest.assertEquals((Object)expected, (Object)((OrganizationSummary)summary.getOrganizations().get(1)).isFwaNumberChanged());
            }
        }
        if (summary.getSpecialReviews().size() > 0) {
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).isApplicationDateChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).isApprovalDateChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).isExpirationDateChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).isProtocolNumberChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).isCommentChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).isApprovalStatusChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).isTypeChanged());
            ProtocolSummaryTest.assertEquals((Object)expected, (Object)((SpecialReviewSummary)summary.getSpecialReviews().get(0)).isExemptionNumbersChanged());
        }
    }

    private ProtocolDocument createProtocolDocument() throws Exception {
        ProtocolDocument protocolDocument = ProtocolFactory.createProtocolDocument();
        Protocol protocol = protocolDocument.getProtocol();
        protocol.setProtocolNumber(PROTOCOL_NUMBER);
        protocol.setInitialSubmissionDate(this.initialSubmissionDate);
        protocol.setApprovalDate(this.approvalDate);
        protocol.setLastApprovalDate(this.lastApprovalDate);
        protocol.setProtocolType((ProtocolTypeBase)this.protocolType);
        protocol.setExpirationDate(this.expirationDate);
        protocol.setProtocolStatus((ProtocolStatusBase)this.protocolStatus);
        protocol.setTitle(TITLE);
        protocol.setFdaApplicationNumber(FDA_APP_NUMBER);
        protocol.setReferenceNumber1(REFERENCE_NUMBER_1);
        protocol.setReferenceNumber2(REFERENCE_NUMBER_2);
        protocol.setDescription(DESCRIPTION);
        ProtocolResearchArea ras = new ProtocolResearchArea();
        ras.setResearchAreaCode(RA_CODE);
        ras.setResearchAreas((ResearchAreaBase)this.researchArea);
        protocol.getProtocolResearchAreas().add(ras);
        ProtocolAttachmentProtocol attachment = new ProtocolAttachmentProtocol();
        AttachmentFile file = new AttachmentFile();
        file.setName(FILE_NAME);
        attachment.setDocumentStatusCode("1");
        attachment.setDescription("protocol attachment");
        ProtocolAttachmentType attachmentType = new ProtocolAttachmentType();
        attachmentType.setDescription("Test Attach type");
        attachment.setType((ProtocolAttachmentTypeBase)attachmentType);
        attachment.setFile(file);
        protocol.getAttachmentProtocols().add(attachment);
        ProtocolFundingSource fundingSource = new ProtocolFundingSource();
        fundingSource.setFundingSourceType(this.fundingType);
        fundingSource.setFundingSourceNumber(FUNDING_SOURCE_NUMBER);
        fundingSource.setFundingSourceName(FUNDING_SOURCE_NAME);
        fundingSource.setFundingSourceTitle(FUNDING_SOURCE_TITLE);
        protocol.getProtocolFundingSources().add(fundingSource);
        ProtocolParticipant participant = new ProtocolParticipant();
        participant.setParticipantType(this.participantType);
        participant.setParticipantCount(PARTICIPANT_COUNT);
        protocol.getProtocolParticipants().add(participant);
        ProtocolLocation location = new ProtocolLocation();
        location.setProtocolOrganizationType((ProtocolOrganizationTypeBase)this.organizationType);
        location.setOrganization(this.organization);
        protocol.getProtocolLocations().add(location);
        ProtocolSpecialReview specialReview = new ProtocolSpecialReview();
        specialReview.setApplicationDate(this.specialReviewApplicationDate);
        specialReview.setApprovalDate(this.approvalDate);
        specialReview.setExpirationDate(this.expirationDate);
        specialReview.setProtocolNumber(PROTOCOL_NUMBER);
        specialReview.setComments(COMMENT);
        specialReview.setSpecialReviewType(this.mySpecialReviewType);
        specialReview.setApprovalType(this.specialReviewApprovalType);
        specialReview.setSpecialReviewExemptions(this.specialReviewExemptions);
        protocol.getSpecialReviews().add(specialReview);
        return protocolDocument;
    }

    private void changePI(Protocol protocol) {
        ProtocolPerson protocolPerson = ProtocolFactory.getProtocolPerson(NEW_PRINCIPAL_INVESTIGATOR_ID, NEW_PRINCIPAL_INVESTIGATOR_NAME, NEW_PRINCIPAL_INVESTIGATOR_ROLE, protocol.getProtocolNumber());
        AffiliationType affiliationType = new AffiliationType();
        affiliationType.setAffiliationTypeCode(Integer.valueOf(4));
        affiliationType.setDescription("another affiliation");
        protocolPerson.setAffiliationType(affiliationType);
        protocolPerson.setAffiliationTypeCode(Integer.valueOf(4));
        ProtocolUnit protocolUnit = new ProtocolUnit();
        protocolUnit.setUnitNumber(NEW_PRINCIPAL_INVESTIGATOR_UNIT);
        protocolUnit.setLeadUnitFlag(true);
        protocolUnit.setProtocolNumber(protocol.getProtocolNumber());
        protocolUnit.setSequenceNumber(Integer.valueOf(0));
        protocolUnit.refreshReferenceObject(NEW_REFERENCE_UNIT);
        protocolPerson.getProtocolUnits().clear();
        protocolPerson.getProtocolUnits().add(protocolUnit);
        protocol.getProtocolPersons().clear();
        protocol.getProtocolPersons().add(protocolPerson);
        protocol.setLeadUnitNumber(NEW_PRINCIPAL_INVESTIGATOR_UNIT);
        protocol.setPrincipalInvestigatorId(NEW_PRINCIPAL_INVESTIGATOR_ID);
    }
}

