/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.test;

import java.util.ArrayList;
import org.kuali.kra.common.permissions.Permissionable;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.protocol.ProtocolDocumentBase;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.GlobalVariables;

public class ProtocolFactory {
    private static final String DEFAULT_DOCUMENT_DESCRIPTION = "Protocol Document";
    private static final String PROTOCOL_NUMBER = "0906000001";
    private static final String PROTOCOL_TYPE_CODE_STR = "1";
    private static final String PROTOCOL_TITLE_STR = "New protocol test";
    private static final String PRINCIPAL_INVESTIGATOR_ID = "10000000001";
    private static final String PRINCIPAL_INVESTIGATOR_NAME = "Terry Durkin";
    private static final String PRINCIPAL_INVESTIGATOR_UNIT = "BL-BL";
    private static final String PRINCIPAL_INVESTIGATOR_ROLE = "PI";
    private static final String REFERENCE_PERSON_ROLE = "protocolPersonRole";
    private static final String REFERENCE_UNIT = "unit";

    public static ProtocolDocument createProtocolDocument() throws WorkflowException {
        return ProtocolFactory.createProtocolDocument(null);
    }

    public static ProtocolDocument createProtocolDocument(String protocolNumber) throws WorkflowException {
        return ProtocolFactory.createProtocolDocument(protocolNumber, 0);
    }

    public static ProtocolDocument createProtocolDocument(String protocolNumber, Integer sequenceNumber) throws WorkflowException {
        DocumentService documentService = KRADServiceLocatorWeb.getDocumentService();
        ProtocolDocument protocolDocument = (ProtocolDocument)documentService.getNewDocument("ProtocolDocument");
        ProtocolFactory.setProtocolRequiredFields(protocolDocument, protocolNumber);
        protocolDocument.getProtocol().setSequenceNumber(sequenceNumber);
        String principalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        KraAuthorizationService kraAuthorizationService = (KraAuthorizationService)KraServiceLocator.getService(KraAuthorizationService.class);
        if (!kraAuthorizationService.hasRole(principalId, (Permissionable)protocolDocument.getProtocol(), "Protocol Aggregator")) {
            kraAuthorizationService.addRole(principalId, "Protocol Aggregator", (Permissionable)protocolDocument.getProtocol());
        }
        if (!kraAuthorizationService.hasRole(principalId, (Permissionable)protocolDocument.getProtocol(), "ProtocolApprover")) {
            kraAuthorizationService.addRole(principalId, "ProtocolApprover", (Permissionable)protocolDocument.getProtocol());
        }
        documentService.saveDocument((Document)protocolDocument);
        return protocolDocument;
    }

    public static void setProtocolRequiredFields(ProtocolDocument document, String protocolNumber) {
        Protocol protocol = document.getProtocol();
        document.getDocumentHeader().setDocumentDescription(DEFAULT_DOCUMENT_DESCRIPTION);
        document.setDocumentNextvalues(new ArrayList());
        protocol.setProtocolDocument((ProtocolDocumentBase)document);
        protocol.setProtocolTypeCode(PROTOCOL_TYPE_CODE_STR);
        protocol.setTitle(PROTOCOL_TITLE_STR);
        protocol.setProtocolNumber(protocolNumber == null ? PROTOCOL_NUMBER : protocolNumber);
        protocol.setSequenceNumber(Integer.valueOf(0));
        ProtocolPerson protocolPerson = ProtocolFactory.getProtocolPerson(PRINCIPAL_INVESTIGATOR_ID, PRINCIPAL_INVESTIGATOR_NAME, PRINCIPAL_INVESTIGATOR_ROLE, protocolNumber);
        ProtocolUnit protocolUnit = new ProtocolUnit();
        protocolUnit.setUnitNumber(PRINCIPAL_INVESTIGATOR_UNIT);
        protocolUnit.setLeadUnitFlag(true);
        protocolUnit.setProtocolNumber(protocolNumber == null ? PROTOCOL_NUMBER : protocolNumber);
        protocolUnit.setSequenceNumber(Integer.valueOf(0));
        protocolUnit.refreshReferenceObject(REFERENCE_UNIT);
        protocolPerson.getProtocolUnits().add(protocolUnit);
        protocol.getProtocolPersons().add(protocolPerson);
        protocol.setLeadUnitNumber(PRINCIPAL_INVESTIGATOR_UNIT);
        protocol.setPrincipalInvestigatorId(PRINCIPAL_INVESTIGATOR_ID);
    }

    public static ProtocolPerson getProtocolPerson(String personId, String personName, String personRole, String protocolNumber) {
        ProtocolPerson protocolPerson = new ProtocolPerson();
        protocolPerson.setPersonId(personId);
        protocolPerson.setPersonName(personName);
        protocolPerson.setProtocolPersonRoleId(personRole);
        protocolPerson.setPreviousPersonRoleId(personRole);
        protocolPerson.setProtocolNumber(protocolNumber == null ? PROTOCOL_NUMBER : protocolNumber);
        protocolPerson.setSequenceNumber(Integer.valueOf(0));
        protocolPerson.refreshReferenceObject(REFERENCE_PERSON_ROLE);
        return protocolPerson;
    }
}

