/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.test;

import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.ProtocolDocument;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.irb.personnel.ProtocolUnit;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.util.KNSGlobalVariables;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.service.KRADServiceLocatorWeb;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.util.MessageMap;
import org.springframework.util.AutoPopulatingList;

public abstract class ProtocolRuleTestBase
extends KcUnitTestBase {
    protected DocumentService documentService = null;
    protected static final String DEFAULT_DOCUMENT_DESCRIPTION = "Protocol Document";
    protected static final String PROTOCOL_STATUS_STR = "100";
    protected static final String PROTOCOL_TYPE_CODE_STR = "1";
    protected static final String PROTOCOL_TITLE_STR = "New protocol test";
    protected static final String PRINCIPAL_INVESTIGATOR_ID = "10000000001";
    protected static final String PRINCIPAL_INVESTIGATOR_NAME = "Joe Tester";
    protected static final String PRINCIPAL_INVESTIGATOR_UNIT = "IN-CARD";
    protected static final String PRINCIPAL_INVESTIGATOR_ROLE = "PI";
    protected static final String REFERENCE_PERSON_ROLE = "protocolPersonRole";
    protected static final String REFERENCE_UNIT = "unit";

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        GlobalVariables.setMessageMap((MessageMap)new MessageMap());
        KNSGlobalVariables.setAuditErrorMap(new HashMap());
        this.documentService = KRADServiceLocatorWeb.getDocumentService();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        GlobalVariables.setUserSession(null);
        GlobalVariables.setMessageMap(null);
        KNSGlobalVariables.setAuditErrorMap(null);
        this.documentService = null;
        super.tearDown();
    }

    protected ProtocolDocument getNewProtocolDocument() throws WorkflowException {
        return (ProtocolDocument)this.documentService.getNewDocument("ProtocolDocument");
    }

    protected void setProtocolRequiredFields(ProtocolDocument document) {
        Protocol protocol = document.getProtocol();
        document.getDocumentHeader().setDocumentDescription(DEFAULT_DOCUMENT_DESCRIPTION);
        protocol.setProtocolTypeCode(PROTOCOL_TYPE_CODE_STR);
        protocol.setTitle(PROTOCOL_TITLE_STR);
        ProtocolPerson protocolPerson = this.getProtocolPerson(PRINCIPAL_INVESTIGATOR_ID, PRINCIPAL_INVESTIGATOR_NAME, PRINCIPAL_INVESTIGATOR_ROLE);
        ProtocolUnit protocolUnit = new ProtocolUnit();
        protocolUnit.setUnitNumber(PRINCIPAL_INVESTIGATOR_UNIT);
        protocolUnit.setLeadUnitFlag(true);
        protocolUnit.setProtocolNumber("0");
        protocolUnit.setSequenceNumber(Integer.valueOf(0));
        protocolUnit.refreshReferenceObject(REFERENCE_UNIT);
        protocolPerson.getProtocolUnits().add(protocolUnit);
        protocol.getProtocolPersons().add(protocolPerson);
        protocol.setLeadUnitNumber(PRINCIPAL_INVESTIGATOR_UNIT);
        protocol.setPrincipalInvestigatorId(PRINCIPAL_INVESTIGATOR_ID);
    }

    protected ProtocolPerson getProtocolPerson(String personId, String personName, String personRole) {
        ProtocolPerson protocolPerson = new ProtocolPerson();
        protocolPerson.setPersonId(personId);
        protocolPerson.setPersonName(personName);
        protocolPerson.setProtocolPersonRoleId(personRole);
        protocolPerson.setPreviousPersonRoleId(personRole);
        protocolPerson.setProtocolNumber("0");
        protocolPerson.setSequenceNumber(Integer.valueOf(0));
        protocolPerson.refreshReferenceObject(REFERENCE_PERSON_ROLE);
        return protocolPerson;
    }

    protected ProtocolPerson getPrincipalInvestigator() {
        return this.getProtocolPerson(PRINCIPAL_INVESTIGATOR_ID, PRINCIPAL_INVESTIGATOR_NAME, PRINCIPAL_INVESTIGATOR_ROLE);
    }

    protected void assertError(String propertyKey, String errorKey) {
        AutoPopulatingList errors = GlobalVariables.getMessageMap().getMessages(propertyKey);
        ProtocolRuleTestBase.assertNotNull((Object)errors);
        ProtocolRuleTestBase.assertTrue((errors.size() == 1 ? 1 : 0) != 0);
        ErrorMessage message = (ErrorMessage)errors.get(0);
        ProtocolRuleTestBase.assertNotNull((Object)message);
        ProtocolRuleTestBase.assertEquals((Object)message.getErrorKey(), (Object)errorKey);
    }
}

