/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolAdditionalInformationPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Additional Information";
    private static final String RESEARCH_AREA_TABLE_ID = "researchAreaTableId";
    private static final String OTHER_IDENTIFIERS_TABLE_ID = "other-idenfifiers-table";
    private static final String RESEARCH_AREA_TAG_ID = "protocolResearchAreas";
    private static final String PROTOCOL_REFERENCE_BEAN_PREFIX = "newProtocolReferenceBean.";
    private static final String LIST_PREFIX = "document.protocolList[0].";
    private static final String RESEARCH_AREA_CODE_ID = "researchAreaCode";
    private static final String FDA_APPLICATION_NUMBER_ID = "fdaApplicationNumber";
    private static final String REFERENCE_NUMBER_1_ID = "referenceNumber1";
    private static final String REFERENCE_NUMBER_2_ID = "referenceNumber2";
    private static final String DESCRIPTION_ID = "description";
    private static final String PROTOCOL_REFERENCE_TYPE_CODE_ID = "protocolReferenceTypeCode";
    private static final String REFERENCE_KEY_ID = "referenceKey";
    private static final String COMMENTS_ID = "comments";
    private static final String LIST_FDA_APPLICATION_NUMBER_ID = "document.protocolList[0].fdaApplicationNumber";
    private static final String LIST_REFERENCE_NUMBER_1_ID = "document.protocolList[0].referenceNumber1";
    private static final String LIST_REFERENCE_NUMBER_2_ID = "document.protocolList[0].referenceNumber2";
    private static final String LIST_DESCRIPTION_ID = "document.protocolList[0].description";
    private static final String PROTOCOL_REFERENCE_BEAN_PROTOCOL_REFERENCE_TYPE_CODE_ID = "newProtocolReferenceBean.protocolReferenceTypeCode";
    private static final String PROTOCOL_REFERENCE_BEAN_REFERENCE_KEY_ID = "newProtocolReferenceBean.referenceKey";
    private static final String PROTOCOL_REFERENCE_BEAN_COMMENTS_ID = "newProtocolReferenceBean.comments";
    private static final String RESEARCH_AREA_CODE = "01.0508";
    private static final String RESEARCH_AREA_CODE_NAME = "01.0508:TaxidermyTaxidermist";
    private static final String FDA_APPLICATION_NUMBER = "A11111";
    private static final String REFERENCE_NUMBER_1 = "0000";
    private static final String REFERENCE_NUMBER_2 = "0010";
    private static final String DESCRIPTION_1 = "keyword_to_test1";
    private static final String DESCRIPTION_2 = "test should be done based on feature";
    private static final String PROTOCOL_REFERENCE_TYPE_CODE = "COAG";
    private static final String REFERENCE_KEY = "My Test";
    private static final String DELETE_PROTOCOL_RESEARCH_AREA_BUTTON = "methodToCall.deleteProtocolResearchArea.line%d";
    private static final String ADD_PROTOCOL_REFERENCE_BUTTON = "methodToCall.addProtocolReferenceBean";
    private static final String DELETE_PROTOCOL_REFERENCE_BUTTON = "methodToCall.deleteProtocolReference.line0";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAreaOfResearchPanel() throws Exception {
        this.helper.createProtocol();
        this.helper.assertNoPageErrors();
        this.helper.openTab(TAB_ID);
        this.helper.multiLookup(RESEARCH_AREA_TAG_ID, RESEARCH_AREA_CODE_ID, RESEARCH_AREA_CODE);
        this.helper.assertTableRowCount(RESEARCH_AREA_TABLE_ID, 4);
        this.helper.assertTableCellValueContains(RESEARCH_AREA_TABLE_ID, RESEARCH_AREA_CODE_NAME);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.click(String.format(DELETE_PROTOCOL_RESEARCH_AREA_BUTTON, 1));
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageDoesNotContain(RESEARCH_AREA_CODE_NAME);
    }

    @Test
    public void testAdditionalInformationPanel() throws Exception {
        this.helper.createProtocol();
        this.helper.assertNoPageErrors();
        this.helper.openTab(TAB_ID);
        this.helper.set(LIST_FDA_APPLICATION_NUMBER_ID, FDA_APPLICATION_NUMBER);
        this.helper.set(LIST_REFERENCE_NUMBER_1_ID, REFERENCE_NUMBER_1);
        this.helper.set(LIST_REFERENCE_NUMBER_2_ID, REFERENCE_NUMBER_2);
        this.helper.set(LIST_DESCRIPTION_ID, DESCRIPTION_1);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertElementContains(LIST_FDA_APPLICATION_NUMBER_ID, FDA_APPLICATION_NUMBER);
        this.helper.assertElementContains(LIST_REFERENCE_NUMBER_1_ID, REFERENCE_NUMBER_1);
        this.helper.assertElementContains(LIST_REFERENCE_NUMBER_2_ID, REFERENCE_NUMBER_2);
        this.helper.assertElementContains(LIST_DESCRIPTION_ID, DESCRIPTION_1);
    }

    @Test
    public void testSummaryKeywordExpandedTextArea() throws Exception {
        this.helper.createProtocol();
        this.helper.assertNoPageErrors();
        this.helper.openTab(TAB_ID);
        this.helper.assertExpandedTextArea(LIST_DESCRIPTION_ID, DESCRIPTION_1, DESCRIPTION_2);
    }

    @Test
    public void testOtherIdentifiersPanel() throws Exception {
        this.helper.createProtocol();
        this.helper.assertNoPageErrors();
        this.helper.openTab(TAB_ID);
        this.helper.set(PROTOCOL_REFERENCE_BEAN_PROTOCOL_REFERENCE_TYPE_CODE_ID, PROTOCOL_REFERENCE_TYPE_CODE);
        this.helper.set(PROTOCOL_REFERENCE_BEAN_REFERENCE_KEY_ID, REFERENCE_KEY);
        this.helper.click(ADD_PROTOCOL_REFERENCE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(OTHER_IDENTIFIERS_TABLE_ID, 5);
        this.helper.assertTableCellValueContains(OTHER_IDENTIFIERS_TABLE_ID, 3, 0, PROTOCOL_REFERENCE_TYPE_CODE);
        this.helper.assertTableCellValueContains(OTHER_IDENTIFIERS_TABLE_ID, 3, 1, REFERENCE_KEY);
        this.helper.click(String.format(DELETE_PROTOCOL_REFERENCE_BUTTON, 0));
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(OTHER_IDENTIFIERS_TABLE_ID, 3);
    }

    @Test
    public void testCommentExpandedTextArea() throws Exception {
        this.helper.createProtocol();
        this.helper.assertNoPageErrors();
        this.helper.openTab(TAB_ID);
        this.helper.assertExpandedTextArea(PROTOCOL_REFERENCE_BEAN_COMMENTS_ID, DESCRIPTION_1, DESCRIPTION_2);
    }
}

