/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.web.MaintenanceDocumentSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolBatchCorrespondenceSeleniumTest
extends KcSeleniumTestBase {
    private static final String DOCUMENT_TITLE = "Batch Correspondence";
    private static final String MAINTENANCE_DOCUMENT_TITLE = "Kuali :: Batch Correspondence";
    private static final String BATCH_CORRESPONDENCE_TYPE_CODE_ID = "batchCorrespondence.batchCorrespondenceTypeCode";
    private static final String DAYS_TO_EVENT_ID = "newBatchCorrespondenceDetail.daysToEvent";
    private static final String PROTO_CORRESP_TYPE_CODE_ID = "newBatchCorrespondenceDetail.protoCorrespTypeCode";
    private static final String FINAL_ACTION_DAY_ID = "batchCorrespondence.finalActionDay";
    private static final String BATCH_CORRESPONDENCE_TYPE_CODE = "Reminder to IRB Notifications";
    private static final String DAYS_TO_EVENT = "16";
    private static final String PROTO_CORRESP_TYPE_CODE = "Renewal Reminder Letter #1";
    private static final String FINAL_ACTION_DAY = "30";
    private static final String ERROR_NUMBER_OF_DAYS_MISSING = "Number of days missing.";
    private static final String ERROR_PROTO_CORRESP_TYPE_MISSING = "Protocol correspondence type missing.";
    private static final String ERROR_FINAL_ACTION_DAY_MISSING = "Final action day missing.";
    private static final String REFRESH_BUTTON = "methodToCall.start";
    private static final String ADD_BATCH_CORRESPONDENCE_DETAIL_BUTTON = "methodToCall.addBatchCorrespondenceDetail";
    private static final String DELETE_BATCH_CORRESPONDENCE_DETAIL_BUTTON = "methodToCall.deleteBatchCorrespondenceDetail.batchCorrespondenceDetail[1]}";
    private MaintenanceDocumentSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = MaintenanceDocumentSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testBatchCorrespondenceDetail() throws Exception {
        this.helper.lookupMaintenanceDocument(DOCUMENT_TITLE);
        this.helper.assertTitleContains(MAINTENANCE_DOCUMENT_TITLE);
        this.helper.set(BATCH_CORRESPONDENCE_TYPE_CODE_ID, BATCH_CORRESPONDENCE_TYPE_CODE);
        this.helper.click(REFRESH_BUTTON);
        this.helper.assertPageDoesNotContain(DAYS_TO_EVENT);
        this.helper.click(ADD_BATCH_CORRESPONDENCE_DETAIL_BUTTON);
        this.helper.assertPageErrors();
        this.helper.assertPageContains(ERROR_NUMBER_OF_DAYS_MISSING);
        this.helper.assertPageContains(ERROR_PROTO_CORRESP_TYPE_MISSING);
        this.helper.set(DAYS_TO_EVENT_ID, DAYS_TO_EVENT);
        this.helper.set(PROTO_CORRESP_TYPE_CODE_ID, PROTO_CORRESP_TYPE_CODE);
        this.helper.click(ADD_BATCH_CORRESPONDENCE_DETAIL_BUTTON);
        this.helper.assertPageContains(DAYS_TO_EVENT);
        this.helper.click(DELETE_BATCH_CORRESPONDENCE_DETAIL_BUTTON);
        this.helper.assertPageDoesNotContain(DAYS_TO_EVENT);
        this.helper.reloadDocument();
        this.helper.assertReload();
        this.helper.set(FINAL_ACTION_DAY_ID, "");
        this.helper.saveDocument();
        this.helper.assertPageErrors();
        this.helper.assertPageContains(ERROR_FINAL_ACTION_DAY_MISSING);
        this.helper.set(FINAL_ACTION_DAY_ID, FINAL_ACTION_DAY);
        this.helper.saveDocument();
        this.helper.assertSave();
    }
}

