/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolFundingSourcePanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Funding Sources";
    private static final String TABLE_ID = "funding-source-table";
    private static final String HELPER_PREFIX = "protocolHelper.newFundingSource.";
    private static final String FUNDING_SOURCE_TYPE_CODE_ID = "fundingSourceTypeCode";
    private static final String FUNDING_SOURCE_NUMBER_ID = "fundingSourceNumber";
    private static final String FUNDING_SOURCE_NAME_ID = "fundingSourceName";
    private static final String HELPER_FUNDING_SOURCE_TYPE_CODE_ID = "protocolHelper.newFundingSource.fundingSourceTypeCode";
    private static final String HELPER_FUNDING_SOURCE_NUMBER_ID = "protocolHelper.newFundingSource.fundingSourceNumber";
    private static final String HELPER_FUNDING_SOURCE_NAME_ID = "protocolHelper.newFundingSource.fundingSourceName";
    private static final String FUNDING_SOURCE_TYPE_CODE_SPONSOR = "Sponsor";
    private static final String FUNDING_SOURCE_NUMBER_SPONSOR = "005174";
    private static final String FUNDING_SOURCE_NAME_SPONSOR = "Arkansas Enterprises for the Blind";
    private static final String FUNDING_SOURCE_TYPE_CODE_UNIT = "Unit";
    private static final String FUNDING_SOURCE_NUMBER_UNIT = "IU-UNIV";
    private static final String FUNDING_SOURCE_NAME_UNIT = "UNIVERSITY LEVEL";
    private static final String FUNDING_SOURCE_TYPE_CODE_OTHER = "Other";
    private static final String FUNDING_SOURCE_NUMBER_OTHER = "123";
    private static final String FUNDING_SOURCE_NAME_OTHER = "Other Name";
    private static final String FUNDING_SOURCE_TYPE_CODE_DEVELOPMENT_PROPOSAL = "Development Proposal";
    private static final String FUNDING_SOURCE_NUMBER_DEVELOPMENT_PROPOSAL = "10000";
    private static final String FUNDING_SOURCE_NAME_DEVELOPMENT_PROPOSAL = "Novartis Institutes for BioMedical Research Incorporated";
    private static final String FUNDING_SOURCE_TYPE_CODE_INSTITUTIONAL_PROPOSAL = "Institutional Proposal";
    private static final String FUNDING_SOURCE_NUMBER_INSTITUTIONAL_PROPOSAL = "10000";
    private static final String FUNDING_SOURCE_NAME_INSTITUTIONAL_PROPOSAL = "Institutional Proposal Title";
    private static final String FUNDING_SOURCE_TYPE_CODE_AWARD = "Award";
    private static final String FUNDING_SOURCE_NUMBER_AWARD = "010001-00001";
    private static final String FUNDING_SOURCE_NAME_AWARD = "Award Title";
    private static final String ADD_PROTOCOL_FUNDING_SOURCE_BUTTON = "methodToCall.addProtocolFundingSource";
    private static final String VIEW_PROTOCOL_FUNDING_SOURCE_BUTTON = "methodToCall.viewProtocolFundingSource.line%d";
    private static final String DELETE_PROTOCOL_FUNDING_SOURCE_BUTTON = "methodToCall.deleteProtocolFundingSource.line%d";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddViewSponsorFundingSourcePage() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_FUNDING_SOURCE_TYPE_CODE_ID, FUNDING_SOURCE_TYPE_CODE_SPONSOR);
        this.helper.set(HELPER_FUNDING_SOURCE_NUMBER_ID, FUNDING_SOURCE_NUMBER_SPONSOR);
        this.helper.click(ADD_PROTOCOL_FUNDING_SOURCE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, FUNDING_SOURCE_TYPE_CODE_SPONSOR);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, FUNDING_SOURCE_NUMBER_SPONSOR);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, FUNDING_SOURCE_NAME_SPONSOR);
        this.helper.assertPopupWindowContains(String.format(VIEW_PROTOCOL_FUNDING_SOURCE_BUTTON, 0), FUNDING_SOURCE_NUMBER_SPONSOR);
    }

    @Test
    public void testAddViewUnitFundingSourcePage() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_FUNDING_SOURCE_TYPE_CODE_ID, FUNDING_SOURCE_TYPE_CODE_UNIT);
        this.helper.set(HELPER_FUNDING_SOURCE_NUMBER_ID, FUNDING_SOURCE_NUMBER_UNIT);
        this.helper.click(ADD_PROTOCOL_FUNDING_SOURCE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, FUNDING_SOURCE_TYPE_CODE_UNIT);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, FUNDING_SOURCE_NUMBER_UNIT);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, FUNDING_SOURCE_NAME_UNIT);
        this.helper.assertPopupWindowContains(String.format(VIEW_PROTOCOL_FUNDING_SOURCE_BUTTON, 0), FUNDING_SOURCE_NUMBER_UNIT);
    }

    @Test
    public void testAddOtherFundingSourcePage() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_FUNDING_SOURCE_TYPE_CODE_ID, FUNDING_SOURCE_TYPE_CODE_OTHER);
        this.helper.set(HELPER_FUNDING_SOURCE_NUMBER_ID, FUNDING_SOURCE_NUMBER_OTHER);
        this.helper.set(HELPER_FUNDING_SOURCE_NAME_ID, FUNDING_SOURCE_NAME_OTHER);
        this.helper.click(ADD_PROTOCOL_FUNDING_SOURCE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, FUNDING_SOURCE_TYPE_CODE_OTHER);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, FUNDING_SOURCE_NUMBER_OTHER);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, FUNDING_SOURCE_NAME_OTHER);
    }

    @Ignore
    @Test
    public void testAddViewDevelopmentProposalFundingSourcePage() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_FUNDING_SOURCE_TYPE_CODE_ID, FUNDING_SOURCE_TYPE_CODE_DEVELOPMENT_PROPOSAL);
        this.helper.set(HELPER_FUNDING_SOURCE_NUMBER_ID, "10000");
        this.helper.set(HELPER_FUNDING_SOURCE_NAME_ID, FUNDING_SOURCE_NAME_DEVELOPMENT_PROPOSAL);
        this.helper.click(ADD_PROTOCOL_FUNDING_SOURCE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, FUNDING_SOURCE_TYPE_CODE_DEVELOPMENT_PROPOSAL);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, "10000");
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, FUNDING_SOURCE_NAME_DEVELOPMENT_PROPOSAL);
        this.helper.click(String.format(VIEW_PROTOCOL_FUNDING_SOURCE_BUTTON, 0));
        this.helper.assertPageContains("Proposal Number: 10000");
    }

    @Ignore
    @Test
    public void testAddViewInstitutionalProposalFundingSourcePage() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_FUNDING_SOURCE_TYPE_CODE_ID, FUNDING_SOURCE_TYPE_CODE_INSTITUTIONAL_PROPOSAL);
        this.helper.set(HELPER_FUNDING_SOURCE_NUMBER_ID, "10000");
        this.helper.set(HELPER_FUNDING_SOURCE_NAME_ID, FUNDING_SOURCE_NAME_INSTITUTIONAL_PROPOSAL);
        this.helper.click(ADD_PROTOCOL_FUNDING_SOURCE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, FUNDING_SOURCE_TYPE_CODE_INSTITUTIONAL_PROPOSAL);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, "10000");
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, FUNDING_SOURCE_NAME_INSTITUTIONAL_PROPOSAL);
        this.helper.click(String.format(VIEW_PROTOCOL_FUNDING_SOURCE_BUTTON, 0));
        this.helper.assertPageContains("Institutional Proposal ID: 10000");
    }

    @Ignore
    @Test
    public void testAddViewAwardFundingSourcePage() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_FUNDING_SOURCE_TYPE_CODE_ID, FUNDING_SOURCE_TYPE_CODE_AWARD);
        this.helper.set(HELPER_FUNDING_SOURCE_NUMBER_ID, FUNDING_SOURCE_NUMBER_AWARD);
        this.helper.set(HELPER_FUNDING_SOURCE_NAME_ID, FUNDING_SOURCE_NAME_AWARD);
        this.helper.click(ADD_PROTOCOL_FUNDING_SOURCE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, FUNDING_SOURCE_TYPE_CODE_AWARD);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, FUNDING_SOURCE_NUMBER_AWARD);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, FUNDING_SOURCE_NAME_AWARD);
        this.helper.click(String.format(VIEW_PROTOCOL_FUNDING_SOURCE_BUTTON, 0));
        this.helper.assertPageContains("Award ID: 010001-00001");
    }

    @Test
    public void testAddDeleteFundingSourcePage() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_FUNDING_SOURCE_TYPE_CODE_ID, FUNDING_SOURCE_TYPE_CODE_SPONSOR);
        this.helper.set(HELPER_FUNDING_SOURCE_NUMBER_ID, FUNDING_SOURCE_NUMBER_SPONSOR);
        this.helper.click(ADD_PROTOCOL_FUNDING_SOURCE_BUTTON);
        this.helper.set(HELPER_FUNDING_SOURCE_TYPE_CODE_ID, FUNDING_SOURCE_TYPE_CODE_UNIT);
        this.helper.set(HELPER_FUNDING_SOURCE_NUMBER_ID, FUNDING_SOURCE_NUMBER_UNIT);
        this.helper.click(ADD_PROTOCOL_FUNDING_SOURCE_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 4);
        this.helper.click(String.format(DELETE_PROTOCOL_FUNDING_SOURCE_BUTTON, 1));
        this.helper.clickYesAnswer();
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, FUNDING_SOURCE_TYPE_CODE_SPONSOR);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, FUNDING_SOURCE_NUMBER_SPONSOR);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, FUNDING_SOURCE_NAME_SPONSOR);
    }
}

