/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolLocationPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Organizations";
    private static final String TABLE_ID = "location-table";
    private static final String ERROR_ID = "tab-Organizations-div";
    private static final String HELPER_PREFIX = "protocolHelper.newProtocolLocation.";
    private static final String ORGANIZATION_ID_ID = "organizationId";
    private static final String PROTOCOL_ORGANIZATION_TYPE_CODE_ID = "protocolOrganizationTypeCode";
    private static final String HELPER_ORGANIZATION_ID = "protocolHelper.newProtocolLocation.organizationId";
    private static final String HELPER_PROTOCOL_ORGANIZATION_TYPE_CODE_ID = "protocolHelper.newProtocolLocation.protocolOrganizationTypeCode";
    private static final String ORGANIZATION_ID = "000001";
    private static final String PROTOCOL_ORGANIZATION_TYPE_CODE = "Performing Organization";
    private static final String CONTACT = "Last Name, First Name: Address Line 1 Address Line 2 Address Line 3, Kuali Coeus, MA 53421";
    private static final String HUMAN_SUB_ASSURANCE = "FWA00004881";
    private static final String ERROR_ORGANIZATION_REQUIRED = "At least one organization must be entered.";
    private static final String ADD_PROTOCOL_LOCATION_BUTTON = "methodToCall.addProtocolLocation";
    private static final String DELETE_PROTOCOL_LOCATION_BUTTON = "methodToCall.deleteProtocolLocation.line%d";
    private static final String CLEAR_PROTOCOL_LOCATION_ADDRESS_BUTTON = "methodToCall.clearProtocolLocationAddress.line%d";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testDefaultLocationPanel() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, ORGANIZATION_ID);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, CONTACT);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 3, HUMAN_SUB_ASSURANCE);
    }

    @Test
    public void testDeleteAndAddDefaultLocation() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.click(String.format(DELETE_PROTOCOL_LOCATION_BUTTON, 0));
        this.helper.set(HELPER_ORGANIZATION_ID, ORGANIZATION_ID);
        this.helper.set(HELPER_PROTOCOL_ORGANIZATION_TYPE_CODE_ID, PROTOCOL_ORGANIZATION_TYPE_CODE);
        this.helper.click(ADD_PROTOCOL_LOCATION_BUTTON);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, ORGANIZATION_ID);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, CONTACT);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 3, HUMAN_SUB_ASSURANCE);
    }

    @Test
    public void testDeleteLocation() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.click(String.format(DELETE_PROTOCOL_LOCATION_BUTTON, 0));
        this.helper.saveDocument();
        this.helper.assertPageErrors();
        this.helper.assertError(ERROR_ID, ERROR_ORGANIZATION_REQUIRED);
    }

    @Test
    public void testClearAddress() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 2, CONTACT);
        this.helper.click(String.format(CLEAR_PROTOCOL_LOCATION_ADDRESS_BUTTON, 0));
        this.helper.assertTableCellValueDoesNotContain(TABLE_ID, 2, 2, CONTACT);
    }
}

