/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolModifySubmissionActionSeleniumTest
extends KcSeleniumTestBase {
    private static final String ACTION_TAB_ID = "Request an Action";
    private static final String SUBMIT_TAB_ID = ": Submit for Review";
    private static final String TAB_ID = ":Modify Submission Request";
    private static final String SUBMIT_HELPER_PREFIX = "actionHelper.protocolSubmitAction.";
    private static final String HELPER_PREFIX = "actionHelper.protocolModifySubmissionBean.";
    private static final String SUBMISSION_TYPE_CODE_ID = "submissionTypeCode";
    private static final String PROTOCOL_REVIEW_TYPE_CODE_ID = "protocolReviewTypeCode";
    private static final String BILLABLE_ID = "billable";
    private static final String SUBMISSION_HELPER_SUBMISSION_TYPE_CODE_ID = "actionHelper.protocolSubmitAction.submissionTypeCode";
    private static final String SUBMISSION_HELPER_PROTOCOL_REVIEW_TYPE_CODE_ID = "actionHelper.protocolSubmitAction.protocolReviewTypeCode";
    private static final String HELPER_BILLABLE_ID = "actionHelper.protocolModifySubmissionBean.billable";
    private static final String SUBMISSION_TYPE_CODE = "Initial Protocol Application for Approval";
    private static final String PROTOCOL_REVIEW_TYPE_CODE = "Full";
    private static final String BILLABLE = "on";
    private static final String SUBMIT_FOR_REVIEW_BUTTON = "methodToCall.submitForReview";
    private static final String MODIFY_SUBMISSION_BUTTON = "methodToCall.modifySubmsionAction";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
        this.helper.loginBackdoor();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper.loginBackdoor();
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testBillableHasPermission() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolActionsPage();
        this.helper.openTab(ACTION_TAB_ID);
        this.helper.openTab(SUBMIT_TAB_ID);
        this.helper.set(SUBMISSION_HELPER_SUBMISSION_TYPE_CODE_ID, SUBMISSION_TYPE_CODE);
        this.helper.set(SUBMISSION_HELPER_PROTOCOL_REVIEW_TYPE_CODE_ID, PROTOCOL_REVIEW_TYPE_CODE);
        this.helper.click(SUBMIT_FOR_REVIEW_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.openTab(TAB_ID);
        this.helper.assertElementExists(BILLABLE);
        this.helper.set(HELPER_BILLABLE_ID, BILLABLE);
        this.helper.click(MODIFY_SUBMISSION_BUTTON);
        this.helper.assertElementContains(HELPER_BILLABLE_ID, BILLABLE);
    }

    @Test
    public void testBillableHasNoPermission() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolActionsPage();
        this.helper.openTab(ACTION_TAB_ID);
        this.helper.openTab(SUBMIT_TAB_ID);
        this.helper.set(SUBMISSION_HELPER_SUBMISSION_TYPE_CODE_ID, SUBMISSION_TYPE_CODE);
        this.helper.set(SUBMISSION_HELPER_PROTOCOL_REVIEW_TYPE_CODE_ID, PROTOCOL_REVIEW_TYPE_CODE);
        this.helper.click(SUBMIT_FOR_REVIEW_BUTTON);
        this.helper.assertNoPageErrors();
        String documentNumber = this.helper.getDocumentNumber();
        this.helper.closeDocument();
        this.helper.loginBackdoor("jtester");
        this.helper.docSearch(documentNumber);
        this.helper.clickProtocolActionsPage();
        this.helper.assertElementDoesNotExist(HELPER_BILLABLE_ID);
    }
}

