/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolNotesAndAttachmentsSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Protocol Attachments";
    private static final String FILE_NAME_ID = "div[id='attachmentProtocolFileName%d']";
    private static final String HELPER_PREFIX = "notesAttachmentsHelper.newAttachmentProtocol.";
    private static final String LIST_PREFIX = "document.protocolList[0].attachmentProtocols[0].";
    private static final String TYPE_CODE_ID = "typeCode";
    private static final String STATUS_CODE_ID = "statusCode";
    private static final String COMMENTS_ID = "comments";
    private static final String NEW_FILE_ID = "newFile";
    private static final String CONTACT_NAME_ID = "contactName";
    private static final String CONTACT_EMAIL_ADDRESS_ID = "contactEmailAddress";
    private static final String CONTACT_PHONE_NUMBER_ID = "contactPhoneNumber";
    private static final String DESCRIPTION_ID = "description";
    private static final String HELPER_ATTACHMENT_PROTOCOL_TYPE_CODE_ID = "notesAttachmentsHelper.newAttachmentProtocol.typeCode";
    private static final String HELPER_ATTACHMENT_PROTOCOL_STATUS_CODE_ID = "notesAttachmentsHelper.newAttachmentProtocol.statusCode";
    private static final String HELPER_ATTACHMENT_PROTOCOL_COMMENTS_ID = "notesAttachmentsHelper.newAttachmentProtocol.comments";
    private static final String HELPER_ATTACHMENT_PROTOCOL_NEW_FILE_ID = "notesAttachmentsHelper.newAttachmentProtocol.newFile";
    private static final String HELPER_ATTACHMENT_PROTOCOL_CONTACT_NAME_ID = "notesAttachmentsHelper.newAttachmentProtocol.contactName";
    private static final String HELPER_ATTACHMENT_PROTOCOL_CONTACT_EMAIL_ADDRESS_ID = "notesAttachmentsHelper.newAttachmentProtocol.contactEmailAddress";
    private static final String HELPER_ATTACHMENT_PROTOCOL_CONTACT_PHONE_NUMBER_ID = "notesAttachmentsHelper.newAttachmentProtocol.contactPhoneNumber";
    private static final String HELPER_ATTACHMENT_PROTOCOL_DESCRIPTION_ID = "notesAttachmentsHelper.newAttachmentProtocol.description";
    private static final String LIST_ATTACHMENT_PROTOCOL_STATUS_CODE_ID = "document.protocolList[0].attachmentProtocols[0].statusCode";
    private static final String LIST_ATTACHMENT_PROTOCOL_COMMENTS_ID = "document.protocolList[0].attachmentProtocols[0].comments";
    private static final String LIST_ATTACHMENT_PROTOCOL_NEW_FILE_ID = "document.protocolList[0].attachmentProtocols[0].newFile";
    private static final String LIST_ATTACHMENT_PROTOCOL_CONTACT_NAME_ID = "document.protocolList[0].attachmentProtocols[0].contactName";
    private static final String LIST_ATTACHMENT_PROTOCOL_CONTACT_EMAIL_ADDRESS_ID = "document.protocolList[0].attachmentProtocols[0].contactEmailAddress";
    private static final String LIST_ATTACHMENT_PROTOCOL_CONTACT_PHONE_NUMBER_ID = "document.protocolList[0].attachmentProtocols[0].contactPhoneNumber";
    private static final String LIST_ATTACHMENT_PROTOCOL_DESCRIPTION_ID = "document.protocolList[0].attachmentProtocols[0].description";
    private static final String PROTOCOL_ATTACHMENTS_LABEL = "Protocol Attachments (%d)";
    private static final String TYPE_CODE = "Informed Consent Document";
    private static final String STATUS_CODE = "Incomplete";
    private static final String COMMENTS = "some comments";
    private static final String NAME = "AxlRose";
    private static final String EMAIL = "axl@gnr.com";
    private static final String PHONE = "123-456-7890";
    private static final String DESCRIPTION = "a description";
    private static final String ADD_ATTACHMENT_PROTOCOL_BUTTON = "methodToCall.addAttachmentProtocol";
    private static final String REPLACE_ATTACHMENT_PROTOCOL_BUTTON = "replaceButton%d";
    private static final String DELETE_ATTACHMENT_PROTOCOL_BUTTON = "methodToCall.deleteAttachmentProtocol";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testProtocolAttachment() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolNotesAndAttachmentsPage();
        this.helper.openTab(TAB_ID);
        this.helper.assertPageContains(String.format(PROTOCOL_ATTACHMENTS_LABEL, 0));
        this.helper.set(HELPER_ATTACHMENT_PROTOCOL_TYPE_CODE_ID, TYPE_CODE);
        this.helper.set(HELPER_ATTACHMENT_PROTOCOL_STATUS_CODE_ID, STATUS_CODE);
        this.helper.set(HELPER_ATTACHMENT_PROTOCOL_COMMENTS_ID, COMMENTS);
        this.helper.set(HELPER_ATTACHMENT_PROTOCOL_NEW_FILE_ID, this.helper.getAbsoluteFilePath(ProtocolNotesAndAttachmentsSeleniumTest.class));
        this.helper.set(HELPER_ATTACHMENT_PROTOCOL_CONTACT_NAME_ID, NAME);
        this.helper.set(HELPER_ATTACHMENT_PROTOCOL_CONTACT_EMAIL_ADDRESS_ID, EMAIL);
        this.helper.set(HELPER_ATTACHMENT_PROTOCOL_CONTACT_PHONE_NUMBER_ID, PHONE);
        this.helper.set(HELPER_ATTACHMENT_PROTOCOL_DESCRIPTION_ID, DESCRIPTION);
        this.helper.click(ADD_ATTACHMENT_PROTOCOL_BUTTON);
        this.helper.clickExpandAll();
        this.helper.assertPageContains(String.format(PROTOCOL_ATTACHMENTS_LABEL, 1));
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_STATUS_CODE_ID, STATUS_CODE);
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_COMMENTS_ID, COMMENTS);
        this.helper.assertSelectorContains(String.format(FILE_NAME_ID, 0), this.helper.getSimpleFilePath(ProtocolNotesAndAttachmentsSeleniumTest.class));
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_CONTACT_NAME_ID, NAME);
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_CONTACT_EMAIL_ADDRESS_ID, EMAIL);
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_CONTACT_PHONE_NUMBER_ID, PHONE);
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_DESCRIPTION_ID, DESCRIPTION);
        this.helper.click(String.format(REPLACE_ATTACHMENT_PROTOCOL_BUTTON, 0));
        this.helper.set(LIST_ATTACHMENT_PROTOCOL_NEW_FILE_ID, this.helper.getAbsoluteFilePath(KcSeleniumTestBase.class));
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.clickExpandAll();
        this.helper.assertPageContains(String.format(PROTOCOL_ATTACHMENTS_LABEL, 1));
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_STATUS_CODE_ID, STATUS_CODE);
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_COMMENTS_ID, COMMENTS);
        this.helper.assertSelectorContains(String.format(FILE_NAME_ID, 0), this.helper.getSimpleFilePath(KcSeleniumTestBase.class));
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_CONTACT_NAME_ID, NAME);
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_CONTACT_EMAIL_ADDRESS_ID, EMAIL);
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_CONTACT_PHONE_NUMBER_ID, PHONE);
        this.helper.assertElementContains(LIST_ATTACHMENT_PROTOCOL_DESCRIPTION_ID, DESCRIPTION);
        this.helper.click(DELETE_ATTACHMENT_PROTOCOL_BUTTON);
        this.helper.clickYesAnswer();
        this.helper.assertSelectorDoesNotContain(String.format(FILE_NAME_ID, 0), this.helper.getSimpleFilePath(KcSeleniumTestBase.class));
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.clickExpandAll();
        this.helper.assertSelectorDoesNotContain(String.format(FILE_NAME_ID, 1), this.helper.getSimpleFilePath(KcSeleniumTestBase.class));
    }
}

