/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.protocol.participant.ProtocolParticipant;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolParticipantPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Participant Types";
    private static final String ERROR_PANEL_ID = "tab-ParticipantTypes-div";
    private static final String TABLE_ID = "participants-table";
    private static final String HELPER_PREFIX = "protocolHelper.newProtocolParticipant.";
    private static final String LIST_PREFIX = "document.protocolList[0].protocolParticipants[0].";
    private static final String PARTICIPANT_TYPE_CODE_ID = "participantTypeCode";
    private static final String PARTICPANT_COUNT_ID = "participantCount";
    private static final String HELPER_PARTICIPANT_TYPE_CODE_ID = "protocolHelper.newProtocolParticipant.participantTypeCode";
    private static final String HELPER_PARTICIPANT_COUNT_ID = "protocolHelper.newProtocolParticipant.participantCount";
    private static final String LIST_PARTICIPANT_COUNT_ID = "document.protocolList[0].protocolParticipants[0].participantCount";
    private static final String PARTICIPANT_TYPE_CODE_PRISONERS = "Prisoners";
    private static final String PARTICIPANT_TYPE_CODE_STUDENTS = "Students";
    private static final String PARTICIPANT_COUNT_1 = "142";
    private static final String PARTICIPANT_COUNT_2 = "58";
    private static final String PARTICIPANT_COUNT_EMPTY = "0";
    private static final String PARTICIPANT_COUNT_NEGATIVE = "-7";
    private static final String PARTICIPANT_COUNT_NON_NUMERIC = "a";
    private static final String ADD_PROTOCOL_PARTICIPANT_BUTTON = "methodToCall.addProtocolParticipant";
    private static final String DELETE_PROTOCOL_PARTICIPANT_BUTTON = "methodToCall.deleteProtocolParticipant.line%d";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testAddParticipantNonEmptyCount() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.assertTableRowCount(TABLE_ID, 2);
        this.helper.set(HELPER_PARTICIPANT_TYPE_CODE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.set(HELPER_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_1);
        this.helper.click(ADD_PROTOCOL_PARTICIPANT_BUTTON);
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.helper.assertTableCellValueContains(TABLE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.assertElementContains(LIST_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_1);
        this.helper.assertOptionsDoNotContain(HELPER_PARTICIPANT_TYPE_CODE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.helper.assertTableCellValueContains(TABLE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.assertElementContains(LIST_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_1);
        this.helper.assertOptionsDoNotContain(HELPER_PARTICIPANT_TYPE_CODE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
    }

    public void testAddParticipantEmptyCount() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_PARTICIPANT_TYPE_CODE_ID, PARTICIPANT_TYPE_CODE_PRISONERS);
        this.helper.set(HELPER_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_EMPTY);
        this.helper.click(ADD_PROTOCOL_PARTICIPANT_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableCellValueContains(TABLE_ID, PARTICIPANT_TYPE_CODE_PRISONERS);
        this.helper.assertTableCellValueContains(TABLE_ID, PARTICIPANT_COUNT_EMPTY);
    }

    @Test
    public void testAddParticipantBlank() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.click(ADD_PROTOCOL_PARTICIPANT_BUTTON);
        this.helper.assertErrorCount(ERROR_PANEL_ID, 1);
    }

    @Test
    public void testModifyParticipant() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_PARTICIPANT_TYPE_CODE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.set(HELPER_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_1);
        this.helper.click(ADD_PROTOCOL_PARTICIPANT_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableCellValueContains(TABLE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.assertElementContains(LIST_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_1);
        this.helper.set(LIST_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_2);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableCellValueContains(TABLE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.assertElementContains(LIST_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_2);
    }

    @Test
    public void testDeleteParticipant() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.assertTableRowCount(TABLE_ID, 2);
        this.helper.set(HELPER_PARTICIPANT_TYPE_CODE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.set(HELPER_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_1);
        this.helper.click(ADD_PROTOCOL_PARTICIPANT_BUTTON);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 3);
        this.helper.assertTableCellValueContains(TABLE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.assertElementContains(LIST_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_1);
        this.helper.click(String.format(DELETE_PROTOCOL_PARTICIPANT_BUTTON, 0));
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertTableRowCount(TABLE_ID, 2);
    }

    @Test
    public void testAddParticipantNegativeCount() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_PARTICIPANT_TYPE_CODE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.set(HELPER_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_NEGATIVE);
        this.helper.click(ADD_PROTOCOL_PARTICIPANT_BUTTON);
        this.helper.assertErrorCount(ERROR_PANEL_ID, 1);
    }

    @Test
    public void testAddParticipantNonNumericCount() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_PARTICIPANT_TYPE_CODE_ID, PARTICIPANT_TYPE_CODE_STUDENTS);
        this.helper.set(HELPER_PARTICIPANT_COUNT_ID, PARTICIPANT_COUNT_NON_NUMERIC);
        this.helper.click(ADD_PROTOCOL_PARTICIPANT_BUTTON);
        this.helper.assertErrorCount(ERROR_PANEL_ID, 1);
    }

    @Test
    public void testParticipantHelpLink() throws Exception {
        this.helper.createProtocol();
        this.helper.openTab(TAB_ID);
        this.helper.assertHelpLink(ProtocolParticipant.class);
    }
}

