/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolPersonnelSeleniumTest
extends KcSeleniumTestBase {
    private static final String PROTOCOL_PERSON_HELPER_PREFIX = "personnelHelper.newProtocolPerson.";
    private static final String PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_PREFIX = "personnelHelper.newProtocolAttachmentPersonnels[%d].";
    private static final String PROTOCOL_PERSON_UNITS_HELPER_PREFIX = "personnelHelper.newProtocolPersonUnits[%d].";
    private static final String PROTOCOL_PERSONS_LIST_PREFIX = "document.protocolList[0].protocolPersons[%d].";
    private static final String PERSON_ID_ID = "personId";
    private static final String PROTOCOL_PERSON_ROLE_ID_ID = "protocolPersonRoleId";
    private static final String TYPE_CODE_ID = "typeCode";
    private static final String DESCRIPTION_ID = "description";
    private static final String NEW_FILE_ID = "newFile";
    private static final String UNIT_NUMBER_ID = "unitNumber";
    private static final String DELETE_ID = "delete";
    private static final String PROTOCOL_PERSON_HELPER_PROTOCOL_PERSON_ROLE_ID_ID = "personnelHelper.newProtocolPerson.protocolPersonRoleId";
    private static final String PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_TYPE_CODE_ID = "personnelHelper.newProtocolAttachmentPersonnels[%d].typeCode";
    private static final String PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_DESCRIPTION_ID = "personnelHelper.newProtocolAttachmentPersonnels[%d].description";
    private static final String PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_NEW_FILE_ID = "personnelHelper.newProtocolAttachmentPersonnels[%d].newFile";
    private static final String PROTOCOL_PERSON_UNITS_HELPER_UNIT_NUMBER_ID = "personnelHelper.newProtocolPersonUnits[%d].unitNumber";
    private static final String PROTOCOL_PERSONS_LIST_DELETE_ID = "document.protocolList[0].protocolPersons[%d].delete";
    private static final String PROTOCOL_PERSONS_LIST_PROTOCOL_PERSON_ROLE_ID_ID = "document.protocolList[0].protocolPersons[%d].protocolPersonRoleId";
    private static final String PERSON_ID_PRINCIPAL_INVESTIGATOR_NAME = "Nicholas Majors";
    private static final String PERSON_ID_CO_INVESTIGATOR = "10000000005";
    private static final String PERSON_ID_CO_INVESTIGATOR_NAME = "Inez Chew";
    private static final String PROTOCOL_PERSON_ROLE_CO_INVESTIGATOR = "Co-Investigator";
    private static final String PROTOCOL_ATTACHMENT_PERSONNELS_TYPE_CODE = "Biography";
    private static final String PROTOCOL_ATTACHMENT_PERSONNELS_DESCRIPTION = "Biography attachment";
    private static final String UNIT_NUMBER = "IU-UNIV";
    private static final String CHECKBOX_CHECKED = "on";
    private static final String ERROR_PRINCIPAL_INVESTIGATOR_REQUIRED = "A Principal Investigator must be assigned to the Protocol.";
    private static final String ADD_PROTOCOL_PERSON_BUTTON = "methodToCall.addProtocolPerson";
    private static final String CLEAR_PROTOCOL_PERSON_BUTTON = "methodToCall.clearProtocolPerson";
    private static final String DELETE_PROTOCOL_PERSON_BUTTON = "methodToCall.deleteProtocolPerson";
    private static final String ADD_PERSONNEL_ATTACHMENT_BUTTON = "methodToCall.addPersonnelAttachment.document.protocolList[0].protocolPersons[%d].line";
    private static final String DELETE_PERSONNEL_ATTACHMENT_BUTTON = "methodToCall.deletePersonnelAttachment.document.protocolList[0].protocolPersons[%d].line%d";
    private static final String ADD_PROTOCOL_PERSON_UNIT_BUTTON = "methodToCall.addProtocolPersonUnit.document.protocolList[0].protocolPersons[%d].line";
    private static final String DELETE_PROTOCOL_PERSON_UNIT_BUTTON = "methodToCall.deleteProtocolPersonUnit.document.protocolList[0].protocolPersons[%d].line%d";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testPrincipalInvestigatorExists() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.assertPageContains(PERSON_ID_PRINCIPAL_INVESTIGATOR_NAME);
    }

    @Test
    public void testAddCoInvestigator() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.assertPageDoesNotContain(PERSON_ID_CO_INVESTIGATOR_NAME);
        this.helper.lookup(PERSON_ID_ID, PERSON_ID_ID, PERSON_ID_CO_INVESTIGATOR);
        this.helper.assertPageContains(PERSON_ID_CO_INVESTIGATOR_NAME);
        this.helper.set(PROTOCOL_PERSON_HELPER_PROTOCOL_PERSON_ROLE_ID_ID, PROTOCOL_PERSON_ROLE_CO_INVESTIGATOR);
        this.helper.click(ADD_PROTOCOL_PERSON_BUTTON);
        this.helper.assertNoPageErrors();
    }

    @Test
    public void testClearPerson() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.assertPageDoesNotContain(PERSON_ID_CO_INVESTIGATOR_NAME);
        this.helper.lookup(PERSON_ID_ID, PERSON_ID_ID, PERSON_ID_CO_INVESTIGATOR);
        this.helper.set(PROTOCOL_PERSON_HELPER_PROTOCOL_PERSON_ROLE_ID_ID, PROTOCOL_PERSON_ROLE_CO_INVESTIGATOR);
        this.helper.assertPageContains(PERSON_ID_CO_INVESTIGATOR_NAME);
        this.helper.click(CLEAR_PROTOCOL_PERSON_BUTTON);
        this.helper.assertPageDoesNotContain(PERSON_ID_CO_INVESTIGATOR_NAME);
    }

    @Test
    public void testAddAttachmentForPerson() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.assertPageDoesNotContain(PROTOCOL_ATTACHMENT_PERSONNELS_DESCRIPTION);
        this.helper.set(String.format(PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_TYPE_CODE_ID, 0), PROTOCOL_ATTACHMENT_PERSONNELS_TYPE_CODE);
        this.helper.set(String.format(PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_DESCRIPTION_ID, 0), PROTOCOL_ATTACHMENT_PERSONNELS_DESCRIPTION);
        this.helper.set(String.format(PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_NEW_FILE_ID, 0), this.helper.getAbsoluteFilePath(ProtocolPersonnelSeleniumTest.class));
        this.helper.click(String.format(ADD_PERSONNEL_ATTACHMENT_BUTTON, 0));
        this.helper.assertPageContains(PROTOCOL_ATTACHMENT_PERSONNELS_DESCRIPTION);
    }

    @Test
    public void testDeleteAttachmentForPerson() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.openTab(0);
        this.helper.openTab(3);
        this.helper.set(String.format(PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_TYPE_CODE_ID, 0), PROTOCOL_ATTACHMENT_PERSONNELS_TYPE_CODE);
        this.helper.set(String.format(PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_DESCRIPTION_ID, 0), PROTOCOL_ATTACHMENT_PERSONNELS_DESCRIPTION);
        this.helper.set(String.format(PROTOCOL_ATTACHMENT_PERSONNELS_HELPER_NEW_FILE_ID, 0), this.helper.getAbsoluteFilePath(ProtocolPersonnelSeleniumTest.class));
        this.helper.click(String.format(ADD_PERSONNEL_ATTACHMENT_BUTTON, 0));
        this.helper.assertPageContains(PROTOCOL_ATTACHMENT_PERSONNELS_DESCRIPTION);
        this.helper.click(String.format(DELETE_PERSONNEL_ATTACHMENT_BUTTON, 0, 0));
        this.helper.clickYesAnswer();
        this.helper.assertPageDoesNotContain(PROTOCOL_ATTACHMENT_PERSONNELS_DESCRIPTION);
    }

    @Test
    public void testAddUnitForPerson() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.assertPageDoesNotContain(UNIT_NUMBER);
        this.helper.set(String.format(PROTOCOL_PERSON_UNITS_HELPER_UNIT_NUMBER_ID, 0), UNIT_NUMBER);
        this.helper.click(String.format(ADD_PROTOCOL_PERSON_UNIT_BUTTON, 0));
        this.helper.assertPageContains(UNIT_NUMBER);
    }

    @Test
    public void testDeleteUnitFromPerson() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.openTab(0);
        this.helper.openTab(4);
        this.helper.set(String.format(PROTOCOL_PERSON_UNITS_HELPER_UNIT_NUMBER_ID, 0), UNIT_NUMBER);
        this.helper.click(String.format(ADD_PROTOCOL_PERSON_UNIT_BUTTON, 0));
        this.helper.assertPageContains(UNIT_NUMBER);
        this.helper.click(String.format(DELETE_PROTOCOL_PERSON_UNIT_BUTTON, 0, 1));
        this.helper.assertPageDoesNotContain(UNIT_NUMBER);
    }

    @Test
    public void testDeletePersonFailure() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.set(String.format(PROTOCOL_PERSONS_LIST_DELETE_ID, 0), CHECKBOX_CHECKED);
        this.helper.click(DELETE_PROTOCOL_PERSON_BUTTON);
        this.helper.saveDocument();
        this.helper.assertPageErrors();
        this.helper.assertPageContains(ERROR_PRINCIPAL_INVESTIGATOR_REQUIRED);
    }

    @Test
    public void testDeletePersonSuccess() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.lookup(PERSON_ID_ID, PERSON_ID_ID, PERSON_ID_CO_INVESTIGATOR);
        this.helper.set(PROTOCOL_PERSON_HELPER_PROTOCOL_PERSON_ROLE_ID_ID, PROTOCOL_PERSON_ROLE_CO_INVESTIGATOR);
        this.helper.click(ADD_PROTOCOL_PERSON_BUTTON);
        this.helper.openTab(1);
        this.helper.openTab(5);
        this.helper.set(String.format(PROTOCOL_PERSON_UNITS_HELPER_UNIT_NUMBER_ID, 1), UNIT_NUMBER);
        this.helper.click(String.format(ADD_PROTOCOL_PERSON_UNIT_BUTTON, 1));
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageContains(PERSON_ID_CO_INVESTIGATOR_NAME);
        this.helper.set(String.format(PROTOCOL_PERSONS_LIST_DELETE_ID, 1), CHECKBOX_CHECKED);
        this.helper.click(DELETE_PROTOCOL_PERSON_BUTTON, true);
        this.helper.saveDocument();
        this.helper.assertNoPageErrors();
        this.helper.assertPageDoesNotContain(PERSON_ID_CO_INVESTIGATOR_NAME);
    }

    @Test
    public void testAtleastOnePI() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolPersonnelPage();
        this.helper.openTab(0);
        this.helper.openTab(1);
        this.helper.set(String.format(PROTOCOL_PERSONS_LIST_PROTOCOL_PERSON_ROLE_ID_ID, 0), PROTOCOL_PERSON_ROLE_CO_INVESTIGATOR);
        this.helper.saveDocument();
        this.helper.assertPageErrors();
        this.helper.assertPageContains(ERROR_PRINCIPAL_INVESTIGATOR_REQUIRED);
    }
}

