/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolRequiredFieldsPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String PAGE_TITLE = "Kuali :: KC Protocol";
    private static final String CREATE_PROTOCOL_LINK_NAME = "Create IRB Protocol";
    private static final String HEADER_STATUS_ID = "table[class='headerinfo'] tbody tr:nth-child(1) td:nth-child(4)";
    private static final String PRINCIPAL_INVESTIGATOR_NAME_DIV_ID = "div[id='principalInvestigatorName.div']";
    private static final String LEAD_UNIT_NAME_DIV_ID = "div[id='protocolHelper.leadUnitName.div']";
    private static final String ERROR_ID = "tab-RequiredFieldsforSavingDocument-div";
    private static final String HELPER_PREFIX = "protocolHelper.";
    private static final String LIST_PREFIX = "document.protocolList[0].";
    private static final String DOCUMENT_DESCRIPTION_ID = "document.documentHeader.documentDescription";
    private static final String TYPE_CODE_ID = "protocolTypeCode";
    private static final String TITLE_ID = "title";
    private static final String PERSON_ID_ID = "personId";
    private static final String LEAD_UNIT_NUMBER_ID = "leadUnitNumber";
    private static final String HELPER_PERSON_ID_ID = "protocolHelper.personId";
    private static final String HELPER_LEAD_UNIT_NUMBER_ID = "protocolHelper.leadUnitNumber";
    private static final String LIST_TYPE_CODE_ID = "document.protocolList[0].protocolTypeCode";
    private static final String LIST_TITLE_ID = "document.protocolList[0].title";
    private static final String DEFAULT_DOCUMENT_DESCRIPTION = "Protocol Document";
    private static final String DEFAULT_TYPE_CODE = "Standard";
    private static final String DEFAULT_TITLE = "New protocol test";
    private static final String DEFAULT_PERSON_ID = "10000000004";
    private static final String DEFAULT_PERSON_ID_NAME = "Nicholas Majors";
    private static final String DEFAULT_LEAD_UNIT_NUMBER = "000001";
    private static final String STATUS = "Pending/In Progress";
    private static final String LEAD_UNIT_NUMBER = "bogus";
    private static final String ERROR_PRINCIPAL_INVESTIGATOR_REQUIRED = "Principal Investigator (Principal Investigator) is a required field";
    private static final String ERROR_TITLE_REQUIRED = "Title (Title) is a required field";
    private static final String ERROR_LEAD_UNIT_NUMBER_REQUIRED = "Lead Unit (Lead Unit) is a required field";
    private static final String ERROR_LEAD_UNIT_NUMBER_INVALID = "Lead Unit is invalid";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testRequiredFields() throws Exception {
        this.helper.createProtocol();
        this.helper.assertNoPageErrors();
        this.helper.assertElementContains(DOCUMENT_DESCRIPTION_ID, DEFAULT_DOCUMENT_DESCRIPTION);
        this.helper.assertElementContains(LIST_TYPE_CODE_ID, DEFAULT_TYPE_CODE);
        this.helper.assertElementContains(LIST_TITLE_ID, DEFAULT_TITLE);
        this.helper.assertSelectorContains(PRINCIPAL_INVESTIGATOR_NAME_DIV_ID, DEFAULT_PERSON_ID_NAME);
        this.helper.assertSelectorContains(LEAD_UNIT_NAME_DIV_ID, DEFAULT_LEAD_UNIT_NUMBER);
        this.helper.assertSelectorContains(HEADER_STATUS_ID, STATUS);
    }

    @Test
    public void testRequiredFieldsNegativeInvestigatorId() throws Exception {
        this.helper.clickResearcherTab();
        this.helper.click(CREATE_PROTOCOL_LINK_NAME);
        this.helper.assertTitleContains(PAGE_TITLE);
        this.helper.set(DOCUMENT_DESCRIPTION_ID, DEFAULT_DOCUMENT_DESCRIPTION);
        this.helper.set(TYPE_CODE_ID, DEFAULT_TYPE_CODE);
        this.helper.set(TITLE_ID, DEFAULT_TITLE);
        this.helper.saveDocument();
        this.helper.assertPageErrors();
        this.helper.assertError(ERROR_ID, ERROR_PRINCIPAL_INVESTIGATOR_REQUIRED);
    }

    @Test
    public void testRequiredFieldsNegativeTitle() throws Exception {
        this.helper.createProtocol();
        this.helper.assertNoPageErrors();
        this.helper.set(LIST_TITLE_ID, "");
        this.helper.saveDocument();
        this.helper.assertPageErrors();
        this.helper.assertError(ERROR_ID, ERROR_TITLE_REQUIRED);
    }

    @Test
    public void testRequiredFieldsNegativeLeadUnit() throws Exception {
        this.helper.clickResearcherTab();
        this.helper.click(CREATE_PROTOCOL_LINK_NAME);
        this.helper.assertTitleContains(PAGE_TITLE);
        this.helper.set(DOCUMENT_DESCRIPTION_ID, DEFAULT_DOCUMENT_DESCRIPTION);
        this.helper.set(TYPE_CODE_ID, DEFAULT_TYPE_CODE);
        this.helper.set(TITLE_ID, DEFAULT_TITLE);
        this.helper.lookup(HELPER_PERSON_ID_ID, PERSON_ID_ID, DEFAULT_PERSON_ID);
        this.helper.set(HELPER_LEAD_UNIT_NUMBER_ID, "");
        this.helper.saveDocument();
        this.helper.assertPageErrors();
        this.helper.assertError(ERROR_ID, ERROR_LEAD_UNIT_NUMBER_REQUIRED);
    }

    @Test
    public void testRequiredFieldsNegativeInvalidLeadUnit() throws Exception {
        this.helper.clickResearcherTab();
        this.helper.click(CREATE_PROTOCOL_LINK_NAME);
        this.helper.assertTitleContains(PAGE_TITLE);
        this.helper.set(DOCUMENT_DESCRIPTION_ID, DEFAULT_DOCUMENT_DESCRIPTION);
        this.helper.set(TYPE_CODE_ID, DEFAULT_TYPE_CODE);
        this.helper.set(TITLE_ID, DEFAULT_TITLE);
        this.helper.lookup(HELPER_PERSON_ID_ID, PERSON_ID_ID, DEFAULT_PERSON_ID);
        this.helper.set(HELPER_LEAD_UNIT_NUMBER_ID, LEAD_UNIT_NUMBER);
        this.helper.saveDocument();
        this.helper.assertPageErrors();
        this.helper.assertError(ERROR_ID, ERROR_LEAD_UNIT_NUMBER_INVALID);
    }
}

