/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.kuali.kra.test.infrastructure.KcSeleniumHelper;
import org.openqa.selenium.WebDriver;

public class ProtocolSeleniumHelper
extends KcSeleniumHelper {
    private static final String PAGE_TITLE = "Kuali :: KC Protocol";
    private static final String CREATE_PROTOCOL_LINK_NAME = "Create IRB Protocol";
    private static final String PROTOCOL_LINK_NAME = "protocol";
    private static final String PERSONNEL_LINK_NAME = "personnel";
    private static final String QUESTIONNAIRE_LINK_NAME = "questionnaire";
    private static final String CUSTOM_DATA_LINK_NAME = "customData";
    private static final String SPECIAL_REVIEW_LINK_NAME = "specialReview";
    private static final String PERMISSIONS_LINK_NAME = "permissions";
    private static final String NOTES_AND_ATTACHMENTS_LINK_NAME = "noteAndAttachment";
    private static final String PROTOCOL_ACTIONS_LINK_NAME = "protocolActions";
    private static final String PERSON_ID_TAG = "protocolHelper.personId";
    private static final String DOCUMENT_DESCRIPTION_ID = "document.documentHeader.documentDescription";
    private static final String LIST_PREFIX = "document.protocolList[0].";
    private static final String TYPE_CODE_ID = "document.protocolList[0].protocolTypeCode";
    private static final String TITLE_ID = "document.protocolList[0].title";
    private static final String PERSON_ID = "personId";
    private static final String SUBMISSION_TYPE_CODE_ID = "actionHelper.protocolSubmitAction.submissionTypeCode";
    private static final String REVIEW_TYPE_CODE_ID = "actionHelper.protocolSubmitAction.protocolReviewTypeCode";
    private static final String DEFAULT_DOCUMENT_DESCRIPTION = "Protocol Document";
    private static final String DEFAULT_TYPE_CODE = "Standard";
    private static final String DEFAULT_TITLE = "New protocol test";
    private static final String DEFAULT_PERSON_ID = "10000000004";
    private static final String DEFAULT_SUBMISSION_TYPE = "Initial Protocol Application for Approval";
    private static final String DEFAULT_SUBMISSION_REVIEW_TYPE = "Full";
    private static final String SUBMIT_FOR_REVIEW_BUTTON = "methodToCall.submitForReview";
    private static ProtocolSeleniumHelper helper;

    public static ProtocolSeleniumHelper instance(WebDriver driver) {
        if (helper == null) {
            helper = new ProtocolSeleniumHelper(driver);
        }
        return helper;
    }

    private ProtocolSeleniumHelper(WebDriver driver) {
        super(driver);
    }

    public void clickProtocolProtocolPage() {
        this.click(PROTOCOL_LINK_NAME);
    }

    public void clickProtocolPersonnelPage() {
        this.click(PERSONNEL_LINK_NAME);
    }

    public void clickProtocolQuestionnairePage() {
        this.click(QUESTIONNAIRE_LINK_NAME);
    }

    public void clickProtocolCustomDataPage() {
        this.click(CUSTOM_DATA_LINK_NAME);
    }

    public void clickProtocolSpecialReviewPage() {
        this.click(SPECIAL_REVIEW_LINK_NAME);
    }

    public void clickProtocolPermissionsPage() {
        this.click(PERMISSIONS_LINK_NAME);
    }

    public void clickProtocolNotesAndAttachmentsPage() {
        this.click(NOTES_AND_ATTACHMENTS_LINK_NAME);
    }

    public void clickProtocolActionsPage() {
        this.click(PROTOCOL_ACTIONS_LINK_NAME);
    }

    public void createProtocol() {
        this.clickResearcherTab();
        this.click(CREATE_PROTOCOL_LINK_NAME);
        this.assertTitleContains(PAGE_TITLE);
        this.setDefaultRequiredFields();
        this.saveDocument();
        this.assertSave();
    }

    public void submit() throws Exception {
        this.clickProtocolActionsPage();
        this.setSubmissionRequiredFields();
        this.click(SUBMIT_FOR_REVIEW_BUTTON);
        this.assertRoute();
    }

    private void setDefaultRequiredFields() {
        this.set(DOCUMENT_DESCRIPTION_ID, DEFAULT_DOCUMENT_DESCRIPTION);
        this.set(TYPE_CODE_ID, DEFAULT_TYPE_CODE);
        this.set(TITLE_ID, DEFAULT_TITLE);
        this.lookup(PERSON_ID_TAG, PERSON_ID, DEFAULT_PERSON_ID);
    }

    private void setSubmissionRequiredFields() {
        this.clickExpandAll();
        this.set(SUBMISSION_TYPE_CODE_ID, DEFAULT_SUBMISSION_TYPE);
        this.set(REVIEW_TYPE_CODE_ID, DEFAULT_SUBMISSION_REVIEW_TYPE);
    }
}

