/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolStatusAndDatesPanelSeleniumTest
extends KcSeleniumTestBase {
    private static final String TAB_ID = "Status Dates";
    private static final String TABLE_ID = "status-dates-table";
    private static final String PROTOCOL_STATUS = "Pending/In Progress";
    private static final String INITIAL_APPROVAL_DATE = "Generated on Approval";
    private static final String LAST_APPROVAL_DATE = "Generated on Renewal Approval";
    private static final String INITIAL_SUBMISSION_DATE = "Generated on Initial Submission";
    private static final String EXPIRATION_DATE = "Generated on Approval";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testStatusAndDates() throws Exception {
        this.helper.createProtocol();
        this.helper.assertNoPageErrors();
        this.helper.openTab(TAB_ID);
        ProtocolStatusAndDatesPanelSeleniumTest.assertTrue((boolean)StringUtils.isNotBlank((String)this.helper.getTableCellValue(TABLE_ID, 0, 0)));
        this.helper.assertTableCellValueContains(TABLE_ID, 0, 1, PROTOCOL_STATUS);
        this.helper.assertTableCellValueContains(TABLE_ID, 1, 0, "Generated on Approval");
        this.helper.assertTableCellValueContains(TABLE_ID, 1, 1, LAST_APPROVAL_DATE);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 0, INITIAL_SUBMISSION_DATE);
        this.helper.assertTableCellValueContains(TABLE_ID, 2, 1, "Generated on Approval");
    }
}

