/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.irb.web;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.irb.web.ProtocolSeleniumHelper;
import org.kuali.kra.test.infrastructure.KcSeleniumTestBase;

public class ProtocolWithdrawActionSeleniumTest
extends KcSeleniumTestBase {
    private static final String ACTION_TAB_ID = "Request an Action";
    private static final String SUBMIT_TAB_ID = ": Submit for Review";
    private static final String TAB_ID = ": Withdraw Protocol";
    private static final String HEADER_STATUS_ID = "table[class='headerinfo'] tbody tr:nth-child(1) td:nth-child(4)";
    private static final String SUBMIT_HELPER_PREFIX = "actionHelper.protocolSubmitAction.";
    private static final String HELPER_PREFIX = "actionHelper.protocolWithdrawBean.";
    private static final String SUBMISSION_TYPE_CODE_ID = "submissionTypeCode";
    private static final String PROTOCOL_REVIEW_TYPE_CODE_ID = "protocolReviewTypeCode";
    private static final String REASON_ID = "reason";
    private static final String SUBMISSION_HELPER_SUBMISSION_TYPE_CODE_ID = "actionHelper.protocolSubmitAction.submissionTypeCode";
    private static final String SUBMISSION_HELPER_PROTOCOL_REVIEW_TYPE_CODE_ID = "actionHelper.protocolSubmitAction.protocolReviewTypeCode";
    private static final String HELPER_REASON_ID = "actionHelper.protocolWithdrawBean.reason";
    private static final String SUBMISSION_TYPE_CODE = "Initial Protocol Application for Approval";
    private static final String PROTOCOL_REVIEW_TYPE_CODE = "Full";
    private static final String REASON = "this is a test";
    private static final String STATUS = "Withdrawn";
    private static final String SUBMIT_FOR_REVIEW_BUTTON = "methodToCall.submitForReview";
    private static final String WITHDRAW_PROTOCOL_BUTTON = "methodToCall.withdrawProtocol";
    private ProtocolSeleniumHelper helper;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.helper = ProtocolSeleniumHelper.instance(driver);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.helper = null;
        super.tearDown();
    }

    @Test
    public void testWithdraw() throws Exception {
        this.helper.createProtocol();
        this.helper.clickProtocolActionsPage();
        this.helper.openTab(ACTION_TAB_ID);
        this.helper.openTab(SUBMIT_TAB_ID);
        this.helper.set(SUBMISSION_HELPER_SUBMISSION_TYPE_CODE_ID, SUBMISSION_TYPE_CODE);
        this.helper.set(SUBMISSION_HELPER_PROTOCOL_REVIEW_TYPE_CODE_ID, PROTOCOL_REVIEW_TYPE_CODE);
        this.helper.click(SUBMIT_FOR_REVIEW_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.openTab(TAB_ID);
        this.helper.set(HELPER_REASON_ID, REASON);
        this.helper.click(WITHDRAW_PROTOCOL_BUTTON);
        this.helper.assertNoPageErrors();
        this.helper.assertSelectorContains(HEADER_STATUS_ID, STATUS);
    }
}

