/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.keyvalue;

import java.util.ArrayList;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.util.ConcreteKeyValue;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.keyvalues.PersistableBusinessObjectValuesFinder;

public abstract class PersistableBusinessObjectValuesFinderTestBase
extends KcUnitTestBase {
    private Class valuesFinderClass;
    private Class businessObjectClass;
    private String keyAttributeName;
    private String labelAttributeName;
    private boolean includeKeyInDescription = false;
    protected List<KeyValue> testKeyValues = new ArrayList<KeyValue>();

    public PersistableBusinessObjectValuesFinderTestBase() {
        this.addKeyValues();
    }

    protected void addKeyValue(String typeCode, String typeValue) {
        this.testKeyValues.add((KeyValue)new ConcreteKeyValue(typeCode, typeValue));
    }

    protected abstract void addKeyValues();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Test
    public void testGetKeyValues() throws Exception {
        PersistableBusinessObjectValuesFinder persistableBusinessObjectValuesFinder = (PersistableBusinessObjectValuesFinder)this.getValuesFinderClass().newInstance();
        persistableBusinessObjectValuesFinder.setBusinessObjectClass(this.getBusinessObjectClass());
        persistableBusinessObjectValuesFinder.setIncludeKeyInDescription(this.isIncludeKeyInDescription());
        persistableBusinessObjectValuesFinder.setKeyAttributeName(this.getKeyAttributeName());
        persistableBusinessObjectValuesFinder.setLabelAttributeName(this.getLabelAttributeName());
        persistableBusinessObjectValuesFinder.getKeyValues();
        PersistableBusinessObjectValuesFinderTestBase.assertEquals((long)this.testKeyValues.size(), (long)persistableBusinessObjectValuesFinder.getKeyValues().size());
        for (int i = 0; i < this.testKeyValues.size(); ++i) {
            PersistableBusinessObjectValuesFinderTestBase.assertEquals((Object)this.testKeyValues.get(i).getValue(), (Object)persistableBusinessObjectValuesFinder.getKeyLabel(this.testKeyValues.get(i).getKey().toString()));
        }
    }

    public Class getValuesFinderClass() {
        return this.valuesFinderClass;
    }

    public void setValuesFinderClass(Class valuesFinderClass) {
        this.valuesFinderClass = valuesFinderClass;
    }

    public Class getBusinessObjectClass() {
        return this.businessObjectClass;
    }

    public void setBusinessObjectClass(Class businessObjectClass) {
        this.businessObjectClass = businessObjectClass;
    }

    public String getKeyAttributeName() {
        return this.keyAttributeName;
    }

    public void setKeyAttributeName(String keyAttributeName) {
        this.keyAttributeName = keyAttributeName;
    }

    public String getLabelAttributeName() {
        return this.labelAttributeName;
    }

    public void setLabelAttributeName(String labelAttributeName) {
        this.labelAttributeName = labelAttributeName;
    }

    public boolean isIncludeKeyInDescription() {
        return this.includeKeyInDescription;
    }

    public void setIncludeKeyInDescription(boolean includeKeyInDescription) {
        this.includeKeyInDescription = includeKeyInDescription;
    }
}

