/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.kim.service.impl;

import java.util.ArrayList;
import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.common.committee.bo.CommitteeBase;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.kim.service.impl.ActiveCommitteeMemberOnProtocolDerivedRoleTypeServiceImpl;
import org.kuali.kra.protocol.actions.submit.ProtocolSubmissionBase;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class ActiveCommitteeMemberOnProtocolDerivedRoleTypeServiceTest {
    private ActiveCommitteeMemberOnProtocolDerivedRoleTypeServiceImpl derivedRole;
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testHasApplicationRole() {
        String protocolNumber = "1107010007";
        final HashMap<String, String> keymap = new HashMap<String, String>();
        keymap.put("protocolNumber", protocolNumber);
        String principalId = "10000000005";
        String namespaceCode = "KC-PROTOCOL";
        String roleName = "View Protocol";
        HashMap<String, String> qualifications = new HashMap<String, String>();
        qualifications.put("protocol", protocolNumber);
        final Protocol protocol = this.createProtocolWithSubmission(protocolNumber);
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class, "bos1");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.allowing(businessObjectService)).findByPrimaryKey(Protocol.class, keymap);
                this.will(1.returnValue((Object)protocol));
            }
        });
        this.derivedRole = new ActiveCommitteeMemberOnProtocolDerivedRoleTypeServiceImpl(){

            public BusinessObjectService getBusinessObjectService() {
                return businessObjectService;
            }
        };
        Assert.assertTrue((boolean)this.derivedRole.hasDerivedRole(principalId, null, namespaceCode, roleName, new HashMap(qualifications)));
    }

    private Protocol createProtocolWithSubmission(String protocolNumber) {
        Protocol protocol = new Protocol(){
            private static final long serialVersionUID = -1273061983131550373L;

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocol.setProtocolNumber(protocolNumber);
        ProtocolSubmission submission = this.createProtocolSubmission();
        ArrayList<ProtocolSubmission> submissionList = new ArrayList<ProtocolSubmission>();
        submissionList.add(submission);
        protocol.setProtocolSubmission((ProtocolSubmissionBase)this.createProtocolSubmission());
        protocol.setProtocolSubmissions(submissionList);
        return protocol;
    }

    private ProtocolSubmission createProtocolSubmission() {
        ProtocolSubmission submission = new ProtocolSubmission(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        submission.setCommittee((CommitteeBase)this.createCommittee());
        return submission;
    }

    private Committee createCommittee() {
        Committee committee = new Committee();
        committee.setCommitteeName("KC IRB 1");
        ArrayList<CommitteeMembership> members = new ArrayList<CommitteeMembership>();
        members.add(this.createCommitteeMember("10000000005", "chew"));
        members.add(this.createCommitteeMember("10000000006", "woods"));
        members.add(this.createCommitteeMember("10000000007", "oblood"));
        members.add(this.createCommitteeMember("10000000008", "cate"));
        members.add(this.createCommitteeMember("10000000004", "majors"));
        committee.setCommitteeMemberships(members);
        return committee;
    }

    private CommitteeMembership createCommitteeMember(String personId, String personName) {
        CommitteeMembership member = new CommitteeMembership();
        member.setPersonId(personId);
        member.setPersonName(personName);
        return member;
    }
}

