/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.lookup.KcPersonLookupableHelperServiceImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.coreservice.framework.parameter.ParameterService;
import org.kuali.rice.kns.web.ui.Field;
import org.kuali.rice.kns.web.ui.Row;
import org.kuali.rice.krad.util.GlobalVariables;

public class KcPersonLookupableHelperServiceImplTest
extends KcUnitTestBase {
    private static final int LOOKUP_CRITERIA_FIELD_COUNT = 9;
    private static final String CAMPUS_CODE_FIELD = "code";
    private static final String CAMPUS_LOOKUPABLE_CLASS_NAME = "org.kuali.rice.location.impl.campus.CampusBo";
    private static final String CAMPUS_CODE = "BL";
    private KcPersonLookupableHelperServiceImpl service;
    private Mockery context = new JUnit4Mockery();

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.service = new KcPersonLookupableHelperServiceImpl();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.service = null;
    }

    @Test
    public void testNonMultiCampusRows() {
        this.service.setBusinessObjectClass(KcPerson.class);
        this.service.setParameterService(this.getMockParameterService(false));
        GlobalVariables.getUserSession().addObject("userCampusCode", (Object)CAMPUS_CODE);
        List rows = this.service.getRows();
        KcPersonLookupableHelperServiceImplTest.assertEquals((long)9L, (long)rows.size());
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals(CAMPUS_CODE_FIELD)) continue;
                this.assertFieldProperties(field, CAMPUS_CODE_FIELD, CAMPUS_LOOKUPABLE_CLASS_NAME);
                KcPersonLookupableHelperServiceImplTest.assertEquals((Object)"", (Object)field.getPropertyValue());
            }
        }
    }

    @Test
    public void testMultiCampusRows() {
        this.service.setBusinessObjectClass(KcPerson.class);
        this.service.setParameterService(this.getMockParameterService(true));
        GlobalVariables.getUserSession().addObject("userCampusCode", (Object)CAMPUS_CODE);
        List rows = this.service.getRows();
        KcPersonLookupableHelperServiceImplTest.assertEquals((long)9L, (long)rows.size());
        for (Row row : rows) {
            for (Field field : row.getFields()) {
                if (!field.getPropertyName().equals(CAMPUS_CODE_FIELD)) continue;
                this.assertFieldProperties(field, CAMPUS_CODE_FIELD, CAMPUS_LOOKUPABLE_CLASS_NAME);
                KcPersonLookupableHelperServiceImplTest.assertEquals((Object)CAMPUS_CODE, (Object)field.getPropertyValue());
            }
        }
    }

    private void assertFieldProperties(Field field, String keyName, String className) {
        KcPersonLookupableHelperServiceImplTest.assertEquals((Object)field.getFieldConversions(), (Object)(keyName + ":" + field.getPropertyName()));
        KcPersonLookupableHelperServiceImplTest.assertTrue((boolean)field.isFieldDirectInquiryEnabled());
        KcPersonLookupableHelperServiceImplTest.assertEquals((Object)field.getLookupParameters(), (Object)(field.getPropertyName() + ":" + keyName));
        KcPersonLookupableHelperServiceImplTest.assertEquals((Object)field.getInquiryParameters(), (Object)(field.getPropertyName() + ":" + keyName));
        KcPersonLookupableHelperServiceImplTest.assertEquals((Object)field.getQuickFinderClassNameImpl(), (Object)className);
    }

    private ParameterService getMockParameterService(final boolean multiCampusEnabled) {
        final ParameterService service = (ParameterService)this.context.mock(ParameterService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((ParameterService)this.allowing(service)).getParameterValueAsBoolean("KC-GEN", "All", "MULTI_CAMPUS_ENABLED");
                this.will(1.returnValue((Object)multiCampusEnabled));
            }
        });
        return service;
    }
}

