/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.lookup;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.lookup.KraPessimisticLockLookupableHelperServiceImpl;

public class KraPessimisticLockLookupableHelperServiceImplTest {
    private KraPessimisticLockLookupableHelperServiceImpl lockService;
    private Method addSingleDayDateRange;

    @Before
    public void setupService() throws Exception {
        this.lockService = new KraPessimisticLockLookupableHelperServiceImpl();
        this.addSingleDayDateRange = this.lockService.getClass().getDeclaredMethod("addSingleDayDateRange", Map.class);
        this.addSingleDayDateRange.setAccessible(true);
    }

    @Test
    public void testDateRangeValidDate() throws Exception {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("generatedTimestamp", "12/31/1981");
        this.addSingleDayDateRange.invoke((Object)this.lockService, fields);
        Assert.assertEquals((String)("does not contain valid date range " + (String)fields.get("generatedTimestamp")), (String)"12/31/1981..01/01/1982", (String)((String)fields.get("generatedTimestamp")));
    }

    @Test
    public void testDateRangeInvalidDate() throws Exception {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put("generatedTimestamp", "foo");
        this.addSingleDayDateRange.invoke((Object)this.lockService, fields);
        Assert.assertEquals((String)("should not have changed time field " + (String)fields.get("generatedTimestamp")), (String)"foo", (String)((String)fields.get("generatedTimestamp")));
    }

    @Test
    public void testDateRangeNoDate() throws Exception {
        HashMap fields = new HashMap();
        this.addSingleDayDateRange.invoke((Object)this.lockService, fields);
        Assert.assertNull((String)("should not contain a time " + (String)fields.get("generatedTimestamp")), fields.get("generatedTimestamp"));
    }
}

