/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.maintenance;

import java.sql.Timestamp;
import java.util.Date;
import org.junit.After;
import org.junit.Test;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.maintenance.KraMaintainableImpl;
import org.kuali.kra.proposaldevelopment.bo.MailType;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.util.GlobalVariables;

public class KraMaintainableImplTest
extends KcUnitTestBase {
    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        GlobalVariables.setUserSession(null);
    }

    @Test
    public void testPrepareForSaveInsertQuickstart() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        MailType kraPersistableBusinessObjectBase = new MailType();
        KraMaintainableImpl kraMaintainableImpl = new KraMaintainableImpl();
        kraMaintainableImpl.setBusinessObject((PersistableBusinessObject)kraPersistableBusinessObjectBase);
        KraMaintainableImplTest.assertNull((Object)kraPersistableBusinessObjectBase.getUpdateTimestamp());
        KraMaintainableImplTest.assertNull((Object)kraPersistableBusinessObjectBase.getUpdateUser());
        kraMaintainableImpl.prepareForSave();
        GlobalVariables.setUserSession((UserSession)new UserSession("jtester"));
        kraPersistableBusinessObjectBase.beforeInsert(null);
        this.updateAsserts("quickstart", (KraPersistableBusinessObjectBase)kraPersistableBusinessObjectBase);
    }

    @Test
    public void testPrepareForSaveUpdateQuickstart() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        MailType kraPersistableBusinessObjectBase = new MailType();
        KraMaintainableImpl kraMaintainableImpl = new KraMaintainableImpl();
        kraMaintainableImpl.setBusinessObject((PersistableBusinessObject)kraPersistableBusinessObjectBase);
        KraMaintainableImplTest.assertNull((Object)kraPersistableBusinessObjectBase.getUpdateTimestamp());
        KraMaintainableImplTest.assertNull((Object)kraPersistableBusinessObjectBase.getUpdateUser());
        kraMaintainableImpl.prepareForSave();
        GlobalVariables.setUserSession((UserSession)new UserSession("jtester"));
        kraPersistableBusinessObjectBase.beforeUpdate(null);
        this.updateAsserts("quickstart", (KraPersistableBusinessObjectBase)kraPersistableBusinessObjectBase);
    }

    @Test
    public void testPrepareForSaveInsertJtester() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("jtester"));
        MailType kraPersistableBusinessObjectBase = new MailType();
        KraMaintainableImpl kraMaintainableImpl = new KraMaintainableImpl();
        kraMaintainableImpl.setBusinessObject((PersistableBusinessObject)kraPersistableBusinessObjectBase);
        KraMaintainableImplTest.assertNull((Object)kraPersistableBusinessObjectBase.getUpdateTimestamp());
        KraMaintainableImplTest.assertNull((Object)kraPersistableBusinessObjectBase.getUpdateUser());
        kraMaintainableImpl.prepareForSave();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        kraPersistableBusinessObjectBase.beforeInsert(null);
        this.updateAsserts("jtester", (KraPersistableBusinessObjectBase)kraPersistableBusinessObjectBase);
    }

    @Test
    public void testPrepareForSaveUpdateJtester() throws Exception {
        GlobalVariables.setUserSession((UserSession)new UserSession("jtester"));
        MailType kraPersistableBusinessObjectBase = new MailType();
        KraMaintainableImpl kraMaintainableImpl = new KraMaintainableImpl();
        kraMaintainableImpl.setBusinessObject((PersistableBusinessObject)kraPersistableBusinessObjectBase);
        KraMaintainableImplTest.assertNull((Object)kraPersistableBusinessObjectBase.getUpdateTimestamp());
        KraMaintainableImplTest.assertNull((Object)kraPersistableBusinessObjectBase.getUpdateUser());
        kraMaintainableImpl.prepareForSave();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        kraPersistableBusinessObjectBase.beforeUpdate(null);
        this.updateAsserts("jtester", (KraPersistableBusinessObjectBase)kraPersistableBusinessObjectBase);
    }

    private void updateAsserts(String udpateUser, KraPersistableBusinessObjectBase kraPersistableBusinessObjectBase) {
        KraMaintainableImplTest.assertEquals((Object)udpateUser, (Object)kraPersistableBusinessObjectBase.getUpdateUser());
        Timestamp updateTimestamp = kraPersistableBusinessObjectBase.getUpdateTimestamp();
        KraMaintainableImplTest.assertNotNull((Object)kraPersistableBusinessObjectBase.getUpdateTimestamp());
        Date currentDate = new Date(System.currentTimeMillis());
        long diff = updateTimestamp.getTime() - currentDate.getTime();
        KraMaintainableImplTest.assertTrue((String)"Should be less than one second difference between dates", (diff < 1000L ? 1 : 0) != 0);
    }
}

