/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.maintenance;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kns.document.MaintenanceDocument;
import org.kuali.rice.kns.maintenance.KualiMaintainableImpl;
import org.kuali.rice.kns.rules.MaintenanceDocumentRule;
import org.kuali.rice.kns.service.DictionaryValidationService;
import org.kuali.rice.kns.service.KNSServiceLocator;
import org.kuali.rice.kns.service.MaintenanceDocumentDictionaryService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.maintenance.Maintainable;
import org.kuali.rice.krad.maintenance.MaintainableImpl;
import org.kuali.rice.krad.util.ErrorMessage;
import org.kuali.rice.krad.util.GlobalVariables;
import org.springframework.util.AutoPopulatingList;

public abstract class MaintenanceRuleTestBase
extends KcUnitTestBase {
    private static final Log LOG = LogFactory.getLog(MaintenanceRuleTestBase.class);
    private static final String DOCUMENT_ERRORS = "document.document*,document.explanation*,document.reversal*,document.selected*,document.header*";

    protected MaintenanceDocument newMaintDoc(PersistableBusinessObject newBo) throws Exception {
        return this.newMaintDoc(null, newBo);
    }

    protected MaintenanceDocument newMaintDoc(PersistableBusinessObject oldBo, PersistableBusinessObject newBo) throws Exception {
        if (null == newBo) {
            throw new IllegalArgumentException("Invalid value (null) for newBo.  This must always be a valid, populated BusinessObject instance.");
        }
        MaintenanceDocument document = null;
        try {
            document = (MaintenanceDocument)this.getDocumentService().getNewDocument(this.getMaintenanceDocumentDictionaryService().getDocumentTypeName(newBo.getClass()));
        }
        catch (WorkflowException e) {
            throw new RuntimeException(e);
        }
        document.getDocumentHeader().setDocumentDescription("test");
        if (null == oldBo) {
            document.setOldMaintainableObject((Maintainable)this.getNewMaintainableImpl(null));
        } else {
            document.setOldMaintainableObject((Maintainable)this.getNewMaintainableImpl(oldBo));
            document.getOldMaintainableObject().setBoClass(oldBo.getClass());
        }
        document.setNewMaintainableObject((Maintainable)this.getNewMaintainableImpl(newBo));
        document.getNewMaintainableObject().setBoClass(newBo.getClass());
        return document;
    }

    protected MaintainableImpl getNewMaintainableImpl(PersistableBusinessObject bo) {
        if (bo == null) {
            return new KualiMaintainableImpl();
        }
        return new KualiMaintainableImpl(bo);
    }

    protected <T extends MaintenanceDocumentRule> T setupMaintDocRule(PersistableBusinessObject newBo, Class<T> ruleClass) throws Exception {
        MaintenanceDocument maintDoc = this.newMaintDoc(newBo);
        return this.setupMaintDocRule(maintDoc, ruleClass);
    }

    protected <T extends MaintenanceDocumentRule> T setupMaintDocRule(PersistableBusinessObject oldBo, PersistableBusinessObject newBo, Class<T> ruleClass) throws Exception {
        MaintenanceDocument maintDoc = this.newMaintDoc(oldBo, newBo);
        return this.setupMaintDocRule(maintDoc, ruleClass);
    }

    protected <T extends MaintenanceDocumentRule> T setupMaintDocRule(MaintenanceDocument maintDoc, Class<T> ruleClass) {
        MaintenanceDocumentRule rule;
        try {
            rule = (MaintenanceDocumentRule)ruleClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        rule.setupBaseConvenienceObjects(maintDoc);
        MaintenanceRuleTestBase.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorMessages().size());
        return (T)rule;
    }

    protected void testDefaultExistenceCheck(PersistableBusinessObject bo, String fieldName, boolean shouldFail) {
        GlobalVariables.getMessageMap().addToErrorPath("document.newMaintainableObject");
        this.getDictionaryValidationService().validateDefaultExistenceChecks((BusinessObject)bo);
        GlobalVariables.getMessageMap().removeFromErrorPath("document.newMaintainableObject");
        this.assertFieldErrorExistence(fieldName, "error.existence", shouldFail);
    }

    protected void assertErrorCount(int expectedErrorCount) {
        MaintenanceRuleTestBase.assertEquals((long)expectedErrorCount, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    protected boolean doesFieldErrorExist(String fieldName, String errorKey) {
        return GlobalVariables.getMessageMap().fieldHasMessage("document.newMaintainableObject." + fieldName, errorKey);
    }

    protected void assertFieldErrorExistence(String fieldName, String errorKey, boolean expectedResult) {
        boolean result = this.doesFieldErrorExist(fieldName, errorKey);
        MaintenanceRuleTestBase.assertEquals((String)("Existence check for Error on fieldName/errorKey: " + fieldName + "/" + errorKey + ". " + GlobalVariables.getMessageMap()), (Object)expectedResult, (Object)result);
    }

    protected void assertFieldErrorDoesNotExist(String fieldName, String errorKey) {
        boolean result = this.doesFieldErrorExist(fieldName, errorKey);
        MaintenanceRuleTestBase.assertTrue((String)("FieldName (" + fieldName + ") should NOT contain errorKey: " + errorKey), (!result ? 1 : 0) != 0);
    }

    protected void assertFieldErrorExists(String fieldName, String errorKey) {
        boolean result = GlobalVariables.getMessageMap().fieldHasMessage("document.newMaintainableObject." + fieldName, errorKey);
        MaintenanceRuleTestBase.assertTrue((String)("FieldName (" + fieldName + ") should contain errorKey: " + errorKey), (boolean)result);
    }

    protected void assertGlobalErrorExists(String errorKey) {
        boolean result = GlobalVariables.getMessageMap().fieldHasMessage(DOCUMENT_ERRORS, errorKey);
        MaintenanceRuleTestBase.assertTrue((String)("Document should contain errorKey: " + errorKey), (boolean)result);
    }

    protected void showErrorMap() {
        if (GlobalVariables.getMessageMap().hasNoErrors()) {
            return;
        }
        for (Map.Entry e : GlobalVariables.getMessageMap().getErrorMessages().entrySet()) {
            AutoPopulatingList errorList = (AutoPopulatingList)e.getValue();
            for (ErrorMessage em : errorList) {
                if (em.getMessageParameters() == null) {
                    LOG.error((Object)(e.getKey().toString() + " = " + em.getErrorKey()));
                    continue;
                }
                StringBuffer messageParams = new StringBuffer();
                String delim = "";
                for (int k = 0; k < em.getMessageParameters().length; ++k) {
                    messageParams.append(delim + "'" + em.getMessageParameters()[k] + "'");
                    if (!"".equals(delim)) continue;
                    delim = ", ";
                }
                LOG.error((Object)(e.getKey().toString() + " = " + em.getErrorKey() + " : " + messageParams.toString()));
            }
        }
    }

    protected MaintenanceDocumentDictionaryService getMaintenanceDocumentDictionaryService() {
        return (MaintenanceDocumentDictionaryService)KraServiceLocator.getService(MaintenanceDocumentDictionaryService.class);
    }

    protected DictionaryValidationService getDictionaryValidationService() {
        return KNSServiceLocator.getKNSDictionaryValidationService();
    }
}

