/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.meeting;

import java.util.HashMap;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.meeting.MeetingEventBase;
import org.kuali.kra.common.committee.meeting.MeetingFormBase;
import org.kuali.kra.common.committee.meeting.ProtocolContingencyBase;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.meeting.MeetingAddMinuteEvent;
import org.kuali.kra.meeting.MeetingAddMinuteRule;
import org.kuali.kra.meeting.MeetingForm;
import org.kuali.kra.meeting.MeetingHelper;
import org.kuali.kra.meeting.ProtocolContingency;
import org.kuali.kra.rules.TemplateRuleTest;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class MeetingAddMinuteRuleTest {
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testMissingProtocol() {
        new TemplateRuleTest<MeetingAddMinuteEvent, MeetingAddMinuteRule>(){

            @Override
            protected void prerequisite() {
                CommitteeScheduleMinute committeeScheduleMinute = new CommitteeScheduleMinute();
                committeeScheduleMinute.setMinuteEntryTypeCode("3");
                committeeScheduleMinute.setMinuteEntry("Text");
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setNewCommitteeScheduleMinute((CommitteeScheduleMinuteBase)committeeScheduleMinute);
                this.event = new MeetingAddMinuteEvent("", null, meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingAddMinuteRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testOK() {
        new TemplateRuleTest<MeetingAddMinuteEvent, MeetingAddMinuteRule>(){

            @Override
            protected void prerequisite() {
                CommitteeScheduleMinute committeeScheduleMinute = new CommitteeScheduleMinute();
                committeeScheduleMinute.setMinuteEntryTypeCode("3");
                committeeScheduleMinute.setMinuteEntry("Text");
                committeeScheduleMinute.setProtocolIdFk(Long.valueOf(1L));
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setNewCommitteeScheduleMinute((CommitteeScheduleMinuteBase)committeeScheduleMinute);
                this.event = new MeetingAddMinuteEvent("", null, meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingAddMinuteRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testInvalidReviewCode() {
        new TemplateRuleTest<MeetingAddMinuteEvent, MeetingAddMinuteRule>(){

            @Override
            protected void prerequisite() {
                CommitteeScheduleMinute committeeScheduleMinute = new CommitteeScheduleMinute();
                committeeScheduleMinute.setMinuteEntryTypeCode("3");
                committeeScheduleMinute.setMinuteEntry("Text");
                committeeScheduleMinute.setProtocolIdFk(Long.valueOf(1L));
                ProtocolContingency protocolContingency = new ProtocolContingency();
                protocolContingency.setProtocolContingencyCode("111");
                committeeScheduleMinute.setProtocolContingency((ProtocolContingencyBase)protocolContingency);
                committeeScheduleMinute.setProtocolContingencyCode("111");
                final BusinessObjectService businessObjectService = (BusinessObjectService)MeetingAddMinuteRuleTest.this.context.mock(BusinessObjectService.class);
                MeetingAddMinuteRuleTest.this.context.checking((ExpectationBuilder)new Expectations(){
                    {
                        HashMap<String, String> queryMap = new HashMap<String, String>();
                        queryMap.put("protocolContingencyCode", "111");
                        ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(ProtocolContingency.class, queryMap);
                        this.will(1.returnValue(null));
                    }
                });
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setNewCommitteeScheduleMinute((CommitteeScheduleMinuteBase)committeeScheduleMinute);
                this.event = new MeetingAddMinuteEvent("", null, meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingAddMinuteRule();
                ((MeetingAddMinuteRule)this.rule).setBusinessObjectService(businessObjectService);
                this.expectedReturnValue = false;
            }
        };
    }
}

