/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.meeting;

import java.util.ArrayList;
import org.junit.Test;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.meeting.MeetingAddOtherEvent;
import org.kuali.kra.common.committee.meeting.MeetingAddOtherRule;
import org.kuali.kra.common.committee.meeting.MeetingEventBase;
import org.kuali.kra.common.committee.meeting.MeetingFormBase;
import org.kuali.kra.common.committee.meeting.MeetingHelperBase;
import org.kuali.kra.common.committee.meeting.MemberPresentBean;
import org.kuali.kra.common.committee.meeting.OtherPresentBeanBase;
import org.kuali.kra.meeting.CommitteeScheduleAttendance;
import org.kuali.kra.meeting.MeetingForm;
import org.kuali.kra.meeting.MeetingHelper;
import org.kuali.kra.meeting.OtherPresentBean;
import org.kuali.kra.rules.TemplateRuleTest;

public class MeetingAddOtherRuleTest {
    @Test
    public void testOK() {
        new TemplateRuleTest<MeetingAddOtherEvent, MeetingAddOtherRule>(){

            @Override
            protected void prerequisite() {
                OtherPresentBean newOtherPresentBean = new OtherPresentBean();
                CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
                newOtherPresentBean.setAttendance((CommitteeScheduleAttendanceBase)attendance);
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setNewOtherPresentBean((OtherPresentBeanBase)newOtherPresentBean);
                meetingHelper.setMemberPresentBeans(new ArrayList());
                attendance.setPersonName("tester 1");
                this.event = new MeetingAddOtherEvent("", null, (MeetingHelperBase)meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingAddOtherRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testAlternateForMatched() {
        new TemplateRuleTest<MeetingAddOtherEvent, MeetingAddOtherRule>(){

            @Override
            protected void prerequisite() {
                OtherPresentBean newOtherPresentBean = new OtherPresentBean();
                CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
                newOtherPresentBean.setAttendance((CommitteeScheduleAttendanceBase)attendance);
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setNewOtherPresentBean((OtherPresentBeanBase)newOtherPresentBean);
                meetingHelper.setMemberPresentBeans(new ArrayList());
                attendance.setPersonName("tester 1");
                meetingHelper.getMemberPresentBeans().add(MeetingAddOtherRuleTest.this.getMemberPresent("001", "tester 1"));
                newOtherPresentBean.getAttendance().setPersonId("001");
                newOtherPresentBean.getAttendance().setNonEmployeeFlag(false);
                newOtherPresentBean.getAttendance().setNonEmployeeFlag(true);
                newOtherPresentBean.getAttendance().setPersonId("002");
                newOtherPresentBean.getAttendance().setNonEmployeeFlag(false);
                ((MemberPresentBean)meetingHelper.getMemberPresentBeans().get(0)).getAttendance().setAlternateFor("002");
                this.event = new MeetingAddOtherEvent("", null, (MeetingHelperBase)meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingAddOtherRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testMemberPresentFound() {
        new TemplateRuleTest<MeetingAddOtherEvent, MeetingAddOtherRule>(){

            @Override
            protected void prerequisite() {
                OtherPresentBean newOtherPresentBean = new OtherPresentBean();
                CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
                newOtherPresentBean.setAttendance((CommitteeScheduleAttendanceBase)attendance);
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setNewOtherPresentBean((OtherPresentBeanBase)newOtherPresentBean);
                meetingHelper.setMemberPresentBeans(new ArrayList());
                attendance.setPersonName("tester 1");
                meetingHelper.getMemberPresentBeans().add(MeetingAddOtherRuleTest.this.getMemberPresent("001", "tester 1"));
                newOtherPresentBean.getAttendance().setPersonId("001");
                newOtherPresentBean.getAttendance().setNonEmployeeFlag(false);
                this.event = new MeetingAddOtherEvent("", null, (MeetingHelperBase)meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingAddOtherRule();
                this.expectedReturnValue = false;
            }
        };
    }

    private MemberPresentBean getMemberPresent(String personId, String personName) {
        MemberPresentBean memberPresentBean = new MemberPresentBean();
        CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
        attendance.setNonEmployeeFlag(false);
        attendance.setPersonId(personId);
        attendance.setPersonName(personName);
        memberPresentBean.setAttendance((CommitteeScheduleAttendanceBase)attendance);
        return memberPresentBean;
    }
}

