/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.meeting;

import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.meeting.MeetingEventBase;
import org.kuali.kra.common.committee.meeting.MeetingFormBase;
import org.kuali.kra.common.committee.meeting.MeetingHelperBase;
import org.kuali.kra.common.committee.meeting.MeetingSaveEvent;
import org.kuali.kra.common.committee.meeting.MeetingSaveRule;
import org.kuali.kra.common.committee.meeting.MemberPresentBean;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.meeting.CommitteeScheduleAttendance;
import org.kuali.kra.meeting.MeetingForm;
import org.kuali.kra.meeting.MeetingHelper;
import org.kuali.kra.rules.TemplateRuleTest;

public class MeetingSaveRuleTest {
    private Time12HrFmt viewStartTime;
    private Time12HrFmt viewEndTime;
    private Time12HrFmt viewTime;
    DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

    @Before
    public void setUp() throws Exception {
        this.viewTime = new Time12HrFmt("01:00", Time12HrFmt.MERIDIEM.PM);
        this.viewStartTime = new Time12HrFmt("01:00", Time12HrFmt.MERIDIEM.PM);
        this.viewEndTime = new Time12HrFmt("01:00", Time12HrFmt.MERIDIEM.PM);
    }

    @Test
    public void testOK() {
        new TemplateRuleTest<MeetingSaveEvent, MeetingSaveRule>(){

            @Override
            protected void prerequisite() {
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setMemberPresentBeans(new ArrayList());
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("001", "tester 1"));
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("002", "tester 2"));
                CommitteeSchedule committeeSchedule = new CommitteeSchedule();
                committeeSchedule.setViewStartTime(MeetingSaveRuleTest.this.viewStartTime);
                committeeSchedule.setViewEndTime(MeetingSaveRuleTest.this.viewEndTime);
                committeeSchedule.setViewTime(MeetingSaveRuleTest.this.viewTime);
                meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
                this.event = new MeetingSaveEvent("", null, (MeetingHelperBase)meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingSaveRule();
                this.expectedReturnValue = true;
            }
        };
    }

    @Test
    public void testTimeFormatIsNotOk() {
        new TemplateRuleTest<MeetingSaveEvent, MeetingSaveRule>(){

            @Override
            protected void prerequisite() {
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setMemberPresentBeans(new ArrayList());
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("001", "tester 1"));
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("002", "tester 2"));
                CommitteeSchedule committeeSchedule = new CommitteeSchedule();
                committeeSchedule.setViewStartTime(MeetingSaveRuleTest.this.viewStartTime);
                committeeSchedule.setViewEndTime(MeetingSaveRuleTest.this.viewEndTime);
                committeeSchedule.setViewTime(MeetingSaveRuleTest.this.viewTime);
                MeetingSaveRuleTest.this.viewTime.setTime("13:00");
                MeetingSaveRuleTest.this.viewEndTime.setTime("12:61");
                meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
                this.event = new MeetingSaveEvent("", null, (MeetingHelperBase)meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingSaveRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testEndTimeBeforeStartTime() {
        new TemplateRuleTest<MeetingSaveEvent, MeetingSaveRule>(){

            @Override
            protected void prerequisite() {
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setMemberPresentBeans(new ArrayList());
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("001", "tester 1"));
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("002", "tester 2"));
                CommitteeSchedule committeeSchedule = new CommitteeSchedule();
                committeeSchedule.setViewStartTime(MeetingSaveRuleTest.this.viewStartTime);
                committeeSchedule.setViewEndTime(MeetingSaveRuleTest.this.viewEndTime);
                committeeSchedule.setViewTime(MeetingSaveRuleTest.this.viewTime);
                MeetingSaveRuleTest.this.viewEndTime.setMeridiem("AM");
                MeetingSaveRuleTest.this.viewEndTime.setMeridiem("PM");
                MeetingSaveRuleTest.this.viewEndTime.setTime("12:30");
                MeetingSaveRuleTest.this.viewEndTime.setTime("01:30");
                MeetingSaveRuleTest.this.viewStartTime.setTime("02:30");
                meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
                this.event = new MeetingSaveEvent("", null, (MeetingHelperBase)meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingSaveRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testSubmissionDeadlineBeforeScheduledDate() {
        new TemplateRuleTest<MeetingSaveEvent, MeetingSaveRule>(){

            @Override
            protected void prerequisite() {
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setMemberPresentBeans(new ArrayList());
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("001", "tester 1"));
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("002", "tester 2"));
                CommitteeSchedule committeeSchedule = new CommitteeSchedule();
                committeeSchedule.setViewStartTime(MeetingSaveRuleTest.this.viewStartTime);
                committeeSchedule.setViewEndTime(MeetingSaveRuleTest.this.viewEndTime);
                committeeSchedule.setViewTime(MeetingSaveRuleTest.this.viewTime);
                try {
                    committeeSchedule.setScheduledDate(new Date(MeetingSaveRuleTest.this.dateFormat.parse("12/24/2012").getTime()));
                    committeeSchedule.setProtocolSubDeadline(new Date(MeetingSaveRuleTest.this.dateFormat.parse("12/25/2012").getTime()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
                this.event = new MeetingSaveEvent("", null, (MeetingHelperBase)meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingSaveRule();
                this.expectedReturnValue = false;
            }
        };
    }

    @Test
    public void testDuplicateAlternateFor() {
        new TemplateRuleTest<MeetingSaveEvent, MeetingSaveRule>(){

            @Override
            protected void prerequisite() {
                MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
                meetingHelper.setMemberPresentBeans(new ArrayList());
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("001", "tester 1"));
                meetingHelper.getMemberPresentBeans().add(MeetingSaveRuleTest.this.getMemberPresent("002", "tester 2"));
                ((MemberPresentBean)meetingHelper.getMemberPresentBeans().get(0)).getAttendance().setAlternateFor("003");
                ((MemberPresentBean)meetingHelper.getMemberPresentBeans().get(0)).getAttendance().setAlternateFlag(true);
                ((MemberPresentBean)meetingHelper.getMemberPresentBeans().get(1)).getAttendance().setAlternateFor("004");
                ((MemberPresentBean)meetingHelper.getMemberPresentBeans().get(1)).getAttendance().setAlternateFlag(true);
                ((MemberPresentBean)meetingHelper.getMemberPresentBeans().get(1)).getAttendance().setAlternateFor("003");
                CommitteeSchedule committeeSchedule = new CommitteeSchedule();
                committeeSchedule.setViewStartTime(MeetingSaveRuleTest.this.viewStartTime);
                committeeSchedule.setViewEndTime(MeetingSaveRuleTest.this.viewEndTime);
                committeeSchedule.setViewTime(MeetingSaveRuleTest.this.viewTime);
                meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
                this.event = new MeetingSaveEvent("", null, (MeetingHelperBase)meetingHelper, MeetingEventBase.ErrorType.HARDERROR);
                this.rule = new MeetingSaveRule();
                this.expectedReturnValue = false;
            }
        };
    }

    private MemberPresentBean getMemberPresent(String personId, String personName) {
        MemberPresentBean memberPresentBean = new MemberPresentBean();
        CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
        attendance.setNonEmployeeFlag(false);
        attendance.setPersonId(personId);
        attendance.setPersonName(personName);
        memberPresentBean.setAttendance((CommitteeScheduleAttendanceBase)attendance);
        return memberPresentBean;
    }
}

