/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.meeting;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeMembership;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.common.committee.bo.CommitteeMembershipRole;
import org.kuali.kra.common.committee.bo.CommitteeScheduleBase;
import org.kuali.kra.common.committee.bo.MembershipRole;
import org.kuali.kra.common.committee.meeting.CommScheduleActItemBase;
import org.kuali.kra.common.committee.meeting.CommScheduleMinuteDocBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleAttendanceBase;
import org.kuali.kra.common.committee.meeting.CommitteeScheduleMinuteBase;
import org.kuali.kra.common.committee.meeting.MeetingFormBase;
import org.kuali.kra.common.committee.meeting.MeetingHelperBase;
import org.kuali.kra.common.committee.meeting.MemberAbsentBean;
import org.kuali.kra.common.committee.meeting.MemberPresentBean;
import org.kuali.kra.common.committee.meeting.MinuteEntryType;
import org.kuali.kra.common.committee.meeting.OtherPresentBeanBase;
import org.kuali.kra.common.committee.meeting.ScheduleActItemType;
import org.kuali.kra.common.committee.web.struts.form.schedule.Time12HrFmt;
import org.kuali.kra.irb.Protocol;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.irb.personnel.ProtocolPerson;
import org.kuali.kra.meeting.CommScheduleActItem;
import org.kuali.kra.meeting.CommScheduleMinuteDoc;
import org.kuali.kra.meeting.CommitteeScheduleAttendance;
import org.kuali.kra.meeting.CommitteeScheduleMinute;
import org.kuali.kra.meeting.MeetingForm;
import org.kuali.kra.meeting.MeetingHelper;
import org.kuali.kra.meeting.MeetingServiceImpl;
import org.kuali.kra.meeting.OtherPresentBean;
import org.kuali.kra.meeting.ProtocolContingency;
import org.kuali.kra.meeting.ScheduleAgenda;
import org.kuali.kra.protocol.ProtocolBase;
import org.kuali.kra.protocol.correspondence.ProtocolCorrespondence;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.SequenceAccessorService;

public class MeetingServiceTest
extends KcUnitTestBase {
    private Mockery context = new JUnit4Mockery();
    DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    private static final String PERSON_ID = "jtester";
    private static final String PERSON_ID_1 = "1";
    private static final String PERSON_ID_2 = "2";
    private static final String PERSON_ID_3 = "3";
    private static final String PERSON_NAME_1 = "test 1";
    private static final String PERSON_NAME_2 = "test 2";
    private static final String PERSON_NAME_3 = "test 3";
    private static final Integer ROLODEX_ID = 1746;
    private static final String MEMBERSHIP_TYPE_CD = "1";
    private static final Date TERM_START_DATE = Date.valueOf("2009-01-01");
    private static final Date TERM_END_DATE = Date.valueOf("2009-01-31");
    private static final Date SCHEDULE_DATE = Date.valueOf("2009-01-15");
    private static final String MEMBERSHIP_ROLE_CD_1 = "1";
    private static final String MEMBERSHIP_ROLE_CD_4 = "4";
    private static final Date ROLE_START_DATE = Date.valueOf("2009-01-10");
    private static final Date ROLE_END_DATE = Date.valueOf("2009-01-20");

    private CommitteeSchedule getCommitteeSchedule() throws Exception {
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setId(Long.valueOf(1L));
        committeeSchedule.setCommittee(this.createCommittee("test", "committeeName"));
        committeeSchedule.setScheduledDate(new Date(this.dateFormat.parse("10/01/2009").getTime()));
        committeeSchedule.setTime(new Timestamp(committeeSchedule.getScheduledDate().getTime()));
        committeeSchedule.setPlace("iu - poplar");
        committeeSchedule.setScheduleStatusCode(Integer.valueOf(1));
        return committeeSchedule;
    }

    private Committee createCommittee(String committeeId, String committeeName) {
        Committee committee = new Committee();
        committee.setCommitteeId(committeeId);
        committee.setCommitteeName(committeeName);
        committee.setMaxProtocols(Integer.valueOf(5));
        return committee;
    }

    private List<ScheduleAgenda> getAgendas() throws Exception {
        ArrayList<ScheduleAgenda> scheduleAgendas = new ArrayList<ScheduleAgenda>();
        ScheduleAgenda scheduleAgenda = new ScheduleAgenda();
        scheduleAgenda.setScheduleIdFk(Long.valueOf(1L));
        scheduleAgenda.setAgendaNumber(Integer.valueOf(3));
        scheduleAgenda.setAgendaName("test");
        scheduleAgenda.setScheduleAgendaId(Long.valueOf(3L));
        scheduleAgenda.setCreateTimestamp(new Timestamp(new Date(this.dateFormat.parse("10/08/2009").getTime()).getTime()));
        scheduleAgendas.add(scheduleAgenda);
        scheduleAgenda = new ScheduleAgenda();
        scheduleAgenda.setScheduleIdFk(Long.valueOf(1L));
        scheduleAgenda.setAgendaNumber(Integer.valueOf(2));
        scheduleAgenda.setAgendaName("test");
        scheduleAgenda.setScheduleAgendaId(Long.valueOf(2L));
        scheduleAgenda.setCreateTimestamp(new Timestamp(new Date(this.dateFormat.parse("10/05/2009").getTime()).getTime()));
        scheduleAgendas.add(scheduleAgenda);
        scheduleAgenda = new ScheduleAgenda();
        scheduleAgenda.setScheduleIdFk(Long.valueOf(1L));
        scheduleAgenda.setAgendaNumber(Integer.valueOf(1));
        scheduleAgenda.setAgendaName("test");
        scheduleAgenda.setScheduleAgendaId(Long.valueOf(1L));
        scheduleAgenda.setCreateTimestamp(new Timestamp(new Date(this.dateFormat.parse("10/02/2009").getTime()).getTime()));
        scheduleAgendas.add(scheduleAgenda);
        return scheduleAgendas;
    }

    @Test
    public void testSaveCommitteeSchedule() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final CommitteeSchedule committeeSchedule = this.getCommitteeSchedule();
        committeeSchedule.setEndTime(committeeSchedule.getTime());
        committeeSchedule.setStartTime(committeeSchedule.getTime());
        committeeSchedule.setViewTime(new Time12HrFmt("01:00", Time12HrFmt.MERIDIEM.PM));
        committeeSchedule.setViewStartTime(new Time12HrFmt("01:00", Time12HrFmt.MERIDIEM.PM));
        committeeSchedule.setViewEndTime(new Time12HrFmt("02:00", Time12HrFmt.MERIDIEM.PM));
        final ArrayList<CommScheduleActItem> deletedOtherActions = new ArrayList<CommScheduleActItem>();
        CommScheduleActItem actItem = new CommScheduleActItem();
        deletedOtherActions.add(actItem);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((BusinessObjectService)this.one(businessObjectService)).delete(deletedOtherActions);
                ((BusinessObjectService)this.one(businessObjectService)).save((PersistableBusinessObject)committeeSchedule);
            }
        });
        meetingService.setBusinessObjectService(businessObjectService);
        meetingService.saveMeetingDetails((CommitteeScheduleBase)committeeSchedule, deletedOtherActions);
        Assert.assertEquals((Object)committeeSchedule.getParentCommittee().getCommitteeId(), (Object)"test");
        Assert.assertEquals((Object)committeeSchedule.getParentCommittee().getCommitteeName(), (Object)"committeeName");
        Assert.assertEquals((Object)committeeSchedule.getPlace(), (Object)"iu - poplar");
        Assert.assertEquals((Object)committeeSchedule.getScheduledDate(), (Object)new Date(this.dateFormat.parse("10/01/2009").getTime()));
        Assert.assertEquals((Object)committeeSchedule.getMaxProtocols(), (Object)new Integer(5));
        Assert.assertEquals((Object)committeeSchedule.getId(), (Object)new Long(1L));
        Assert.assertNotSame((Object)committeeSchedule.getTime(), (Object)new Timestamp(committeeSchedule.getScheduledDate().getTime()));
        Assert.assertEquals((Object)committeeSchedule.getScheduleStatusCode(), (Object)new Integer(1));
    }

    @Test
    public void testgetStandardReviewComment() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final ProtocolContingency protocolContingency = new ProtocolContingency();
        protocolContingency.setProtocolContingencyCode("1");
        protocolContingency.setDescription("Protocol Contingency comment #1");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> queryMap = new HashMap<String, String>();
                queryMap.put("protocolContingencyCode", "1");
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(ProtocolContingency.class, queryMap);
                this.will(2.returnValue((Object)protocolContingency));
            }
        });
        meetingService.setBusinessObjectService(businessObjectService);
        String description = meetingService.getStandardReviewComment("1");
        Assert.assertEquals((Object)description, (Object)"Protocol Contingency comment #1");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> queryMap = new HashMap<String, String>();
                queryMap.put("protocolContingencyCode", MeetingServiceTest.PERSON_ID_2);
                ((BusinessObjectService)this.one(businessObjectService)).findByPrimaryKey(ProtocolContingency.class, queryMap);
                this.will(3.returnValue(null));
            }
        });
        description = meetingService.getStandardReviewComment(PERSON_ID_2);
        Assert.assertTrue((description == null ? 1 : 0) != 0);
    }

    @Test
    public void testAddOtherAction() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        final SequenceAccessorService sequenceAccessorService = (SequenceAccessorService)this.context.mock(SequenceAccessorService.class);
        final CommScheduleActItem newOtherAction = this.getOtherActionItem(1L, "1", 0);
        newOtherAction.setScheduleActItemTypeCode("1");
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((SequenceAccessorService)this.one(sequenceAccessorService)).getNextAvailableSequenceNumber("SEQ_MEETING_ID");
                this.will(4.returnValue((Object)newOtherAction.getCommScheduleActItemsId()));
            }
        });
        meetingService.setSequenceAccessorService(sequenceAccessorService);
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setCommScheduleActItems(new ArrayList());
        meetingService.addOtherAction((CommScheduleActItemBase)newOtherAction, (CommitteeScheduleBase)committeeSchedule);
        Assert.assertTrue((committeeSchedule.getCommScheduleActItems().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((CommScheduleActItemBase)committeeSchedule.getCommScheduleActItems().get(0)).getScheduleActItemTypeCode(), (Object)"1");
        Assert.assertEquals((Object)((CommScheduleActItemBase)committeeSchedule.getCommScheduleActItems().get(0)).getActionItemNumber(), (Object)new Integer(1));
    }

    @Test
    public void testDeleteOtherAction() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        ArrayList<CommScheduleActItem> items = new ArrayList<CommScheduleActItem>();
        ArrayList deletedItems = new ArrayList();
        CommScheduleActItem otherAction1 = this.getOtherActionItem(1L, "1", 1);
        items.add(otherAction1);
        CommScheduleActItem otherAction2 = this.getOtherActionItem(2L, PERSON_ID_2, 2);
        items.add(otherAction2);
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setCommScheduleActItems(items);
        meetingService.deleteOtherAction((CommitteeScheduleBase)committeeSchedule, 1, deletedItems);
        Assert.assertTrue((committeeSchedule.getCommScheduleActItems().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((CommScheduleActItemBase)committeeSchedule.getCommScheduleActItems().get(0)).getScheduleActItemTypeCode(), (Object)"1");
        Assert.assertEquals((Object)((CommScheduleActItemBase)committeeSchedule.getCommScheduleActItems().get(0)).getActionItemNumber(), (Object)new Integer(1));
        Assert.assertTrue((deletedItems.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((CommScheduleActItem)deletedItems.get(0)).getScheduleActItemTypeCode(), (Object)PERSON_ID_2);
        Assert.assertEquals((Object)((CommScheduleActItem)deletedItems.get(0)).getActionItemNumber(), (Object)new Integer(2));
    }

    private CommScheduleActItem getOtherActionItem(Long commScheduleActItemsId, String scheduleActItemTypeCode, int actionItemNumber) {
        CommScheduleActItem otherAction = new CommScheduleActItem(){

            public void refreshReferenceObject(String referenceObjectName) {
                if (referenceObjectName.equals("scheduleActItemType")) {
                    ScheduleActItemType scheduleActItemType = new ScheduleActItemType();
                    scheduleActItemType.setScheduleActItemTypeCode(this.getScheduleActItemTypeCode());
                }
            }
        };
        otherAction.setActionItemNumber(Integer.valueOf(actionItemNumber));
        otherAction.setScheduleActItemTypeCode(scheduleActItemTypeCode);
        otherAction.setCommScheduleActItemsId(commScheduleActItemsId);
        return otherAction;
    }

    @Test
    public void testMarkAbsent() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        ArrayList<MemberPresentBean> memberPresentBeans = new ArrayList<MemberPresentBean>();
        ArrayList memberAbsentBeans = new ArrayList();
        memberPresentBeans.add(this.getMemberPresentBean("1", PERSON_NAME_1));
        memberPresentBeans.add(this.getMemberPresentBean(PERSON_ID_2, PERSON_NAME_2));
        memberPresentBeans.add(this.getMemberPresentBean(PERSON_ID_3, PERSON_NAME_3));
        meetingService.markAbsent(memberPresentBeans, memberAbsentBeans, 1);
        Assert.assertTrue((memberPresentBeans.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((memberAbsentBeans.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((MemberPresentBean)memberPresentBeans.get(0)).getAttendance().getPersonId(), (Object)"1");
        Assert.assertEquals((Object)((MemberPresentBean)memberPresentBeans.get(0)).getAttendance().getPersonName(), (Object)PERSON_NAME_1);
        Assert.assertEquals((Object)((MemberPresentBean)memberPresentBeans.get(1)).getAttendance().getPersonId(), (Object)PERSON_ID_3);
        Assert.assertEquals((Object)((MemberPresentBean)memberPresentBeans.get(1)).getAttendance().getPersonName(), (Object)PERSON_NAME_3);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(0)).getAttendance().getPersonId(), (Object)PERSON_ID_2);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(0)).getAttendance().getPersonName(), (Object)PERSON_NAME_2);
    }

    private MemberPresentBean getMemberPresentBean(String personId, String personName) {
        MemberPresentBean memberPresentBean = new MemberPresentBean();
        CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
        attendance.setPersonId(personId);
        attendance.setPersonName(personName);
        memberPresentBean.setAttendance((CommitteeScheduleAttendanceBase)attendance);
        return memberPresentBean;
    }

    @Test
    public void testPresentVoting() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        ArrayList memberPresentBeans = new ArrayList();
        ArrayList<MemberAbsentBean> memberAbsentBeans = new ArrayList<MemberAbsentBean>();
        memberAbsentBeans.add(this.getMemberAbsentBean("1", PERSON_NAME_1));
        memberAbsentBeans.add(this.getMemberAbsentBean(PERSON_ID_2, PERSON_NAME_2));
        memberAbsentBeans.add(this.getMemberAbsentBean(PERSON_ID_3, PERSON_NAME_3));
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setCommittee(this.getCommitteeWithMember());
        committeeSchedule.setScheduledDate(SCHEDULE_DATE);
        MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
        meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        meetingHelper.setMemberAbsentBeans(memberAbsentBeans);
        meetingHelper.setMemberPresentBeans(memberPresentBeans);
        meetingService.presentVoting((MeetingHelperBase)meetingHelper, 1);
        Assert.assertTrue((memberPresentBeans.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((memberAbsentBeans.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(0)).getAttendance().getPersonId(), (Object)"1");
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(0)).getAttendance().getPersonName(), (Object)PERSON_NAME_1);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(1)).getAttendance().getPersonId(), (Object)PERSON_ID_3);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(1)).getAttendance().getPersonName(), (Object)PERSON_NAME_3);
        Assert.assertEquals((Object)((MemberPresentBean)memberPresentBeans.get(0)).getAttendance().getPersonId(), (Object)PERSON_ID_2);
        Assert.assertEquals((Object)((MemberPresentBean)memberPresentBeans.get(0)).getAttendance().getPersonName(), (Object)PERSON_NAME_2);
    }

    @Test
    public void testPresentOther() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        ArrayList otherPresentBeans = new ArrayList();
        ArrayList<MemberAbsentBean> memberAbsentBeans = new ArrayList<MemberAbsentBean>();
        memberAbsentBeans.add(this.getMemberAbsentBean("1", PERSON_NAME_1));
        memberAbsentBeans.add(this.getMemberAbsentBean(PERSON_ID_2, PERSON_NAME_2));
        memberAbsentBeans.add(this.getMemberAbsentBean(PERSON_ID_3, PERSON_NAME_3));
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setCommittee(this.getCommitteeWithMember());
        committeeSchedule.setScheduledDate(SCHEDULE_DATE);
        MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
        meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        meetingHelper.setMemberAbsentBeans(memberAbsentBeans);
        meetingHelper.setOtherPresentBeans(otherPresentBeans);
        meetingService.presentOther((MeetingHelperBase)meetingHelper, 1);
        Assert.assertTrue((otherPresentBeans.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((memberAbsentBeans.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(0)).getAttendance().getPersonId(), (Object)"1");
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(0)).getAttendance().getPersonName(), (Object)PERSON_NAME_1);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(1)).getAttendance().getPersonId(), (Object)PERSON_ID_3);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(1)).getAttendance().getPersonName(), (Object)PERSON_NAME_3);
        Assert.assertEquals((Object)((OtherPresentBean)otherPresentBeans.get(0)).getAttendance().getPersonId(), (Object)PERSON_ID_2);
        Assert.assertEquals((Object)((OtherPresentBean)otherPresentBeans.get(0)).getAttendance().getPersonName(), (Object)PERSON_NAME_2);
    }

    private CommitteeMembership getMembership(String personID, Integer rolodexID, String membershipTypeCode, Date termStartDate, Date termEndDate) {
        CommitteeMembership committeeMembership = new CommitteeMembership();
        committeeMembership.setPersonId(personID);
        committeeMembership.setRolodexId(rolodexID);
        committeeMembership.setMembershipTypeCode(membershipTypeCode);
        committeeMembership.setTermStartDate(termStartDate);
        committeeMembership.setTermEndDate(termEndDate);
        return committeeMembership;
    }

    private MemberAbsentBean getMemberAbsentBean(String personId, String personName) {
        MemberAbsentBean memberAbsentBean = new MemberAbsentBean();
        CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
        attendance.setPersonId(personId);
        attendance.setPersonName(personName);
        memberAbsentBean.setAttendance((CommitteeScheduleAttendanceBase)attendance);
        return memberAbsentBean;
    }

    private CommitteeMembershipRole getRole(String membershipRoleCode, Date startDate, Date endDate) {
        CommitteeMembershipRole committeeMembershipRole = new CommitteeMembershipRole();
        committeeMembershipRole.setMembershipRoleCode(membershipRoleCode);
        committeeMembershipRole.setStartDate(startDate);
        committeeMembershipRole.setEndDate(endDate);
        MembershipRole membershipRole = new MembershipRole();
        membershipRole.setMembershipRoleCode(membershipRoleCode);
        membershipRole.setDescription("Role " + membershipRoleCode);
        committeeMembershipRole.setMembershipRole(membershipRole);
        return committeeMembershipRole;
    }

    @Test
    public void testAddOtherPresent() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        OtherPresentBean newOtherPresentBean = this.getOtherPresentBean("1", PERSON_NAME_1, true);
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        ArrayList otherPresentBeans = new ArrayList();
        ArrayList<MemberAbsentBean> memberAbsentBeans = new ArrayList<MemberAbsentBean>();
        memberAbsentBeans.add(this.getMemberAbsentBean("1", PERSON_NAME_1));
        committeeSchedule.setCommittee(this.getCommitteeWithMember());
        committeeSchedule.setScheduledDate(SCHEDULE_DATE);
        MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
        meetingHelper.setMemberAbsentBeans(memberAbsentBeans);
        meetingHelper.setOtherPresentBeans(otherPresentBeans);
        meetingHelper.setNewOtherPresentBean((OtherPresentBeanBase)newOtherPresentBean);
        meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        meetingService.addOtherPresent((MeetingHelperBase)meetingHelper);
        Assert.assertTrue((otherPresentBeans.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((memberAbsentBeans.size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((OtherPresentBean)otherPresentBeans.get(0)).getAttendance().getPersonId(), (Object)"1");
        Assert.assertEquals((Object)((OtherPresentBean)otherPresentBeans.get(0)).getAttendance().getPersonName(), (Object)PERSON_NAME_1);
    }

    private Committee getCommitteeWithMember() {
        Committee committee = new Committee();
        CommitteeMembership committeeMembership = this.getMembership("1", null, "1", TERM_START_DATE, TERM_END_DATE);
        committeeMembership.getMembershipRoles().add(this.getRole("1", ROLE_START_DATE, ROLE_END_DATE));
        committee.getCommitteeMemberships().add(committeeMembership);
        committee.getCommitteeMemberships().add(this.getMembership(null, ROLODEX_ID, "1", TERM_START_DATE, TERM_END_DATE));
        committeeMembership.getMembershipRoles().add(this.getRole(MEMBERSHIP_ROLE_CD_4, ROLE_START_DATE, ROLE_END_DATE));
        return committee;
    }

    @Test
    public void testdeleteOtherPresent() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        ArrayList<OtherPresentBean> otherPresentBeans = new ArrayList<OtherPresentBean>();
        otherPresentBeans.add(this.getOtherPresentBean("1", PERSON_NAME_1, true));
        otherPresentBeans.add(this.getOtherPresentBean(PERSON_ID_3, PERSON_NAME_3, false));
        ArrayList<MemberAbsentBean> memberAbsentBeans = new ArrayList<MemberAbsentBean>();
        memberAbsentBeans.add(this.getMemberAbsentBean(PERSON_ID_2, PERSON_NAME_2));
        committeeSchedule.setCommittee(this.getCommitteeWithMember());
        committeeSchedule.setScheduledDate(SCHEDULE_DATE);
        MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
        meetingHelper.setMemberAbsentBeans(memberAbsentBeans);
        meetingHelper.setOtherPresentBeans(otherPresentBeans);
        meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        meetingService.deleteOtherPresent((MeetingHelperBase)meetingHelper, 0);
        Assert.assertTrue((otherPresentBeans.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((memberAbsentBeans.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((OtherPresentBean)otherPresentBeans.get(0)).getAttendance().getPersonId(), (Object)PERSON_ID_3);
        Assert.assertEquals((Object)((OtherPresentBean)otherPresentBeans.get(0)).getAttendance().getPersonName(), (Object)PERSON_NAME_3);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(0)).getAttendance().getPersonId(), (Object)PERSON_ID_2);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(0)).getAttendance().getPersonName(), (Object)PERSON_NAME_2);
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(1)).getAttendance().getPersonId(), (Object)"1");
        Assert.assertEquals((Object)((MemberAbsentBean)memberAbsentBeans.get(1)).getAttendance().getPersonName(), (Object)PERSON_NAME_1);
    }

    private OtherPresentBean getOtherPresentBean(String personId, String personName, boolean isMember) {
        OtherPresentBean otherPresentBean = new OtherPresentBean();
        CommitteeScheduleAttendance attendance = new CommitteeScheduleAttendance();
        attendance.setPersonId(personId);
        attendance.setPersonName(personName);
        otherPresentBean.setAttendance((CommitteeScheduleAttendanceBase)attendance);
        otherPresentBean.setMember(isMember);
        return otherPresentBean;
    }

    @Test
    public void testAddCommitteeScheduleMinute() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        final DateTimeService dateTimeService = (DateTimeService)this.context.mock(DateTimeService.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((DateTimeService)this.one(dateTimeService)).getCurrentTimestamp();
                this.will(6.returnValue((Object)new Timestamp(System.currentTimeMillis())));
            }
        });
        meetingService.setDateTimeService(dateTimeService);
        CommitteeScheduleMinute newCommitteeScheduleMinute = this.getCommitteeScheduleMinute(1L, "1", 1, 2L);
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setId(Long.valueOf(1L));
        committeeSchedule.setCommitteeScheduleMinutes(new ArrayList());
        ArrayList<ProtocolSubmission> protocolSubmissions = new ArrayList<ProtocolSubmission>();
        protocolSubmissions.add(this.getProtocolSubmission(1L));
        committeeSchedule.setProtocolSubmissions(protocolSubmissions);
        MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
        meetingHelper.setNewCommitteeScheduleMinute((CommitteeScheduleMinuteBase)newCommitteeScheduleMinute);
        meetingHelper.setCommitteeSchedule((CommitteeScheduleBase)committeeSchedule);
        meetingService.addCommitteeScheduleMinute((MeetingHelperBase)meetingHelper);
        Assert.assertTrue((committeeSchedule.getCommitteeScheduleMinutes().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((CommitteeScheduleMinute)committeeSchedule.getCommitteeScheduleMinutes().get(0)).getMinuteEntryTypeCode(), (Object)"1");
        Assert.assertEquals((Object)((CommitteeScheduleMinute)committeeSchedule.getCommitteeScheduleMinutes().get(0)).getEntryNumber(), (Object)new Integer(1));
    }

    @Test
    public void testDeleteCommitteeScheduleMinute() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        ArrayList<CommitteeScheduleMinute> items = new ArrayList<CommitteeScheduleMinute>();
        ArrayList deletedItems = new ArrayList();
        CommitteeScheduleMinute minute1 = this.getCommitteeScheduleMinute(1L, "1", 1, 3L);
        items.add(minute1);
        CommitteeScheduleMinute minute2 = this.getCommitteeScheduleMinute(2L, PERSON_ID_2, 2, 3L);
        items.add(minute2);
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        committeeSchedule.setCommitteeScheduleMinutes(items);
        meetingService.deleteCommitteeScheduleMinute((CommitteeScheduleBase)committeeSchedule, deletedItems, 1);
        Assert.assertTrue((committeeSchedule.getCommitteeScheduleMinutes().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((CommitteeScheduleMinute)committeeSchedule.getCommitteeScheduleMinutes().get(0)).getMinuteEntryTypeCode(), (Object)"1");
        Assert.assertEquals((Object)((CommitteeScheduleMinute)committeeSchedule.getCommitteeScheduleMinutes().get(0)).getEntryNumber(), (Object)new Integer(1));
        Assert.assertTrue((deletedItems.size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((CommitteeScheduleMinute)deletedItems.get(0)).getMinuteEntryTypeCode(), (Object)PERSON_ID_2);
        Assert.assertEquals((Object)((CommitteeScheduleMinute)deletedItems.get(0)).getEntryNumber(), (Object)new Integer(2));
    }

    private CommitteeScheduleMinute getCommitteeScheduleMinute(Long commScheduleMinutesId, String minuteEntryTypeCode, int entryNumber, Long submissionId) {
        CommitteeScheduleMinute committeeScheduleMinute = new CommitteeScheduleMinute(){

            public void refreshReferenceObject(String referenceObjectName) {
                if (referenceObjectName.equals("minuteEntryType")) {
                    MinuteEntryType minuteEntryType = new MinuteEntryType();
                    minuteEntryType.setMinuteEntryTypeCode(this.getMinuteEntryTypeCode());
                }
            }
        };
        ProtocolSubmission submission = this.getProtocolSubmission(submissionId);
        committeeScheduleMinute.setProtocol(submission.getProtocol());
        committeeScheduleMinute.setEntryNumber(Integer.valueOf(entryNumber));
        committeeScheduleMinute.setMinuteEntryTypeCode(minuteEntryTypeCode);
        committeeScheduleMinute.setCommScheduleMinutesId(commScheduleMinutesId);
        return committeeScheduleMinute;
    }

    @Test
    public void testPopulateFormHelper() throws Exception {
        MeetingServiceImpl meetingService = new MeetingServiceImpl();
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        Committee committee = new Committee();
        committee.setCommitteeId("1");
        committee.setCommitteeName("Test Committee");
        CommitteeMembership committeeMembership = this.getMembership(PERSON_ID, null, "1", TERM_START_DATE, TERM_END_DATE);
        committeeMembership.getMembershipRoles().add(this.getRole("1", ROLE_START_DATE, ROLE_END_DATE));
        committee.getCommitteeMemberships().add(committeeMembership);
        committee.getCommitteeMemberships().add(this.getMembership(null, ROLODEX_ID, "1", TERM_START_DATE, TERM_END_DATE));
        committeeMembership.getMembershipRoles().add(this.getRole(MEMBERSHIP_ROLE_CD_4, ROLE_START_DATE, ROLE_END_DATE));
        committeeSchedule.setCommittee(committee);
        committeeSchedule.setScheduledDate(SCHEDULE_DATE);
        committeeSchedule.setId(Long.valueOf(1L));
        ArrayList<ProtocolSubmission> protocolSubmissions = new ArrayList<ProtocolSubmission>();
        protocolSubmissions.add(this.getProtocolSubmission(1L));
        protocolSubmissions.add(this.getProtocolSubmission(2L));
        committeeSchedule.setProtocolSubmissions(protocolSubmissions);
        MeetingHelper meetingHelper = new MeetingHelper((MeetingFormBase)new MeetingForm());
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        final List<ScheduleAgenda> agendas = this.getAgendas();
        final List<CommScheduleMinuteDoc> minuteDocs = this.getMinuteDocs();
        final List<org.kuali.kra.irb.correspondence.ProtocolCorrespondence> correspondences = this.getCorrespondences();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, Long> queryMap = new HashMap<String, Long>();
                queryMap.put("scheduleIdFk", 1L);
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(ScheduleAgenda.class, queryMap, "createTimestamp", true);
                this.will(8.returnValue((Object)agendas));
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(ScheduleAgenda.class, queryMap, "createTimestamp", true);
                this.will(8.returnValue((Object)agendas));
                ((BusinessObjectService)this.one(businessObjectService)).findMatchingOrderBy(CommScheduleMinuteDoc.class, queryMap, "createTimestamp", true);
                this.will(8.returnValue((Object)minuteDocs));
                HashMap<String, Long> queryMap1 = new HashMap<String, Long>();
                queryMap1.put("protocolId", 1L);
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(org.kuali.kra.irb.correspondence.ProtocolCorrespondence.class, queryMap1);
                this.will(8.returnValue((Object)correspondences));
            }
        });
        meetingService.setBusinessObjectService(businessObjectService);
        meetingService.populateFormHelper((MeetingHelperBase)meetingHelper, (CommitteeScheduleBase)committeeSchedule, 1);
        Assert.assertTrue((meetingHelper.getMemberAbsentBeans().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((meetingHelper.getProtocolSubmittedBeans().size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((meetingHelper.getMemberPresentBeans().size() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((meetingHelper.getOtherPresentBeans().size() == 0 ? 1 : 0) != 0);
        Assert.assertEquals((Object)meetingHelper.getTabLabel(), (Object)("Test Committee #1 Meeting " + this.dateFormat.format(SCHEDULE_DATE)));
        Assert.assertTrue((meetingHelper.getMinuteDocs().size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((meetingHelper.getCorrespondences().size() == 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)((CommScheduleMinuteDocBase)meetingHelper.getMinuteDocs().get(0)).getScheduleIdFk().toString(), (Object)"1");
        Assert.assertEquals((Object)((ProtocolCorrespondence)meetingHelper.getCorrespondences().get(0)).getProtocolId().toString(), (Object)"1");
    }

    private List<CommScheduleMinuteDoc> getMinuteDocs() {
        ArrayList<CommScheduleMinuteDoc> minuteDocs = new ArrayList<CommScheduleMinuteDoc>();
        CommScheduleMinuteDoc minuteDoc = new CommScheduleMinuteDoc();
        minuteDoc.setScheduleIdFk(Long.valueOf(1L));
        minuteDocs.add(minuteDoc);
        return minuteDocs;
    }

    private List<org.kuali.kra.irb.correspondence.ProtocolCorrespondence> getCorrespondences() {
        ArrayList<org.kuali.kra.irb.correspondence.ProtocolCorrespondence> correspondences = new ArrayList<org.kuali.kra.irb.correspondence.ProtocolCorrespondence>();
        org.kuali.kra.irb.correspondence.ProtocolCorrespondence correspondence = new org.kuali.kra.irb.correspondence.ProtocolCorrespondence();
        correspondence.setProtocolId(Long.valueOf(1L));
        correspondences.add(correspondence);
        return correspondences;
    }

    private ProtocolSubmission getProtocolSubmission(Long submissionId) {
        ProtocolSubmission protocolSubmission = new ProtocolSubmission(){

            public void refreshReferenceObject(String referenceObjectName) {
            }
        };
        protocolSubmission.setProtocol((ProtocolBase)this.getProtocol());
        protocolSubmission.setSubmissionId(submissionId);
        protocolSubmission.setProtocolId(Long.valueOf(1L));
        return protocolSubmission;
    }

    private Protocol getProtocol() {
        Protocol protocol = new Protocol(){

            public void refreshReferenceObject(String referenceObjectName) {
            }

            public ProtocolPerson getPrincipalInvestigator() {
                ProtocolPerson protocolPerson = new ProtocolPerson();
                protocolPerson.setPersonId("1");
                protocolPerson.setPersonName(MeetingServiceTest.PERSON_NAME_1);
                return protocolPerson;
            }
        };
        return protocol;
    }
}

