/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.meeting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.Assert;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kuali.kra.irb.actions.submit.ProtocolSubmission;
import org.kuali.kra.meeting.ProtocolValuesFinder;
import org.kuali.rice.core.api.util.KeyValue;
import org.kuali.rice.krad.service.BusinessObjectService;

@RunWith(value=JMock.class)
public class ProtocolValuesFinderTest {
    private Mockery context = new JUnit4Mockery();

    @Test
    public void testGetKeyValues() throws Exception {
        final BusinessObjectService businessObjectService = (BusinessObjectService)this.context.mock(BusinessObjectService.class);
        ProtocolValuesFinder protocolValuesFinder = new ProtocolValuesFinder(){

            protected BusinessObjectService getBusinessObjectService() {
                return businessObjectService;
            }
        };
        final ArrayList<ProtocolSubmission> protocolSubmissions = new ArrayList<ProtocolSubmission>();
        ProtocolSubmission protocolSubmission = new ProtocolSubmission();
        protocolSubmission.setScheduleIdFk(Long.valueOf(1L));
        protocolSubmission.setProtocolId(Long.valueOf(1L));
        protocolSubmission.setProtocolNumber("1001");
        protocolSubmissions.add(protocolSubmission);
        protocolSubmission = new ProtocolSubmission();
        protocolSubmission.setScheduleIdFk(Long.valueOf(1L));
        protocolSubmission.setProtocolId(Long.valueOf(2L));
        protocolSubmission.setProtocolNumber("1002");
        protocolSubmissions.add(protocolSubmission);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                HashMap<String, String> fieldValues = new HashMap<String, String>();
                fieldValues.put("scheduleIdFk", "1");
                ((BusinessObjectService)this.one(businessObjectService)).findMatching(ProtocolSubmission.class, fieldValues);
                this.will(2.returnValue((Object)protocolSubmissions));
            }
        });
        protocolValuesFinder.setScheduleId("1");
        List keyValues = protocolValuesFinder.getKeyValues();
        Assert.assertEquals((int)keyValues.size(), (int)3);
        Assert.assertEquals((String)((KeyValue)keyValues.get(1)).getKey().toString(), (String)"1");
        Assert.assertEquals((String)((KeyValue)keyValues.get(1)).getValue(), (String)"1001");
        Assert.assertEquals((String)((KeyValue)keyValues.get(2)).getKey().toString(), (String)"2");
        Assert.assertEquals((String)((KeyValue)keyValues.get(2)).getValue(), (String)"1002");
    }
}

