/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.meeting;

import org.junit.Assert;
import org.junit.Test;
import org.kuali.kra.committee.bo.Committee;
import org.kuali.kra.committee.bo.CommitteeSchedule;
import org.kuali.kra.committee.document.authorization.CommitteeScheduleTask;
import org.kuali.kra.common.committee.document.authorization.CommitteeTaskBase;
import org.kuali.kra.meeting.ViewScheduleAuthorizer;
import org.kuali.kra.service.KraAuthorizationService;
import org.kuali.kra.service.impl.mocks.KraAuthorizationServiceMock;

public class ViewScheduleAuthorizerTest {
    private static final String USERNAME = "quickstart";
    private static final String PERSON_ID = "jtester";

    @Test
    public void testViewSchedulePermission() throws Exception {
        ViewScheduleAuthorizer authorizer = new ViewScheduleAuthorizer();
        KraAuthorizationServiceMock kraAuthorizationService = new KraAuthorizationServiceMock(true);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService);
        Committee committee = this.createCommittee("viewschedule1", "view schedule test");
        CommitteeTaskBase<Committee> task = new CommitteeTaskBase<Committee>("committee", "viewSchedule", committee){};
        Assert.assertEquals((Object)true, (Object)authorizer.isAuthorized(USERNAME, (CommitteeTaskBase)task));
        KraAuthorizationServiceMock kraAuthorizationService1 = new KraAuthorizationServiceMock(false);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService1);
        Assert.assertEquals((Object)false, (Object)authorizer.isAuthorized("tdurkin", (CommitteeTaskBase)task));
        CommitteeSchedule committeeSchedule = new CommitteeSchedule();
        KraAuthorizationServiceMock kraAuthorizationService2 = new KraAuthorizationServiceMock(true);
        authorizer.setKraAuthorizationService((KraAuthorizationService)kraAuthorizationService2);
        task = new CommitteeScheduleTask("viewSchedule", committeeSchedule.getParentCommittee(), committeeSchedule);
        Assert.assertEquals((Object)false, (Object)authorizer.isAuthorized(PERSON_ID, (CommitteeTaskBase)task));
        committeeSchedule.setAvailableToReviewers(true);
        task = new CommitteeScheduleTask("viewSchedule", committeeSchedule.getParentCommittee(), committeeSchedule);
        Assert.assertEquals((Object)true, (Object)authorizer.isAuthorized(PERSON_ID, (CommitteeTaskBase)task));
    }

    private Committee createCommittee(String committeeId, String committeeName) {
        Committee committee = new Committee();
        committee.setCommitteeId(committeeId);
        committee.setCommitteeName(committeeName);
        return committee;
    }
}

