/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.auth;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.authorization.ApplicationTask;
import org.kuali.kra.authorization.Task;
import org.kuali.kra.award.budget.AwardBudgetService;
import org.kuali.kra.award.document.AwardDocument;
import org.kuali.kra.award.home.Award;
import org.kuali.kra.award.home.AwardAmountInfo;
import org.kuali.kra.award.home.AwardService;
import org.kuali.kra.award.home.AwardType;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.negotiations.auth.NegotiationTask;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationAgreementType;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.bo.NegotiationStatus;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.document.NegotiationDocument;
import org.kuali.kra.proposaldevelopment.bo.ActivityType;
import org.kuali.kra.service.TaskAuthorizationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.kra.timeandmoney.transactions.AwardTransactionType;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;
import org.kuali.rice.krad.util.GlobalVariables;
import org.kuali.rice.krad.workflow.service.WorkflowDocumentService;

public class TestNegotiationAuthorizers
extends KcUnitTestBase {
    TaskAuthorizationService taskAuthorizationService;
    BusinessObjectService businessObjectService;
    DocumentService documentService;
    Person quickstart;
    Person jtester;
    Person woods;
    Person ospAdmin;
    Person negotiator;

    @Override
    @Before
    public void setUp() throws Exception {
        this.taskAuthorizationService = (TaskAuthorizationService)KraServiceLocator.getService(TaskAuthorizationService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.quickstart = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("quickstart");
        this.jtester = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("jtester");
        this.woods = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("woods");
        this.ospAdmin = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("borst");
        this.negotiator = ((PersonService)KraServiceLocator.getService(PersonService.class)).getPersonByPrincipalName("oblood");
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.taskAuthorizationService = null;
        this.businessObjectService = null;
        this.documentService = null;
        this.quickstart = null;
        this.jtester = null;
        this.woods = null;
        this.ospAdmin = null;
    }

    @Test
    public void testCreateNegotiationAuthorizer() throws WorkflowException {
        NegotiationDocument negotiationDoc = this.getNewNegotiationWithUnassociatedDetail();
        ApplicationTask task = new ApplicationTask("createNegotiation");
        boolean retVal = this.taskAuthorizationService.isAuthorized(this.quickstart.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.jtester.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.woods.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.ospAdmin.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
    }

    @Test
    public void testModifyNegotiationAuthorizer() throws WorkflowException {
        NegotiationDocument negotiationDoc = this.getNewNegotiationWithUnassociatedDetail();
        NegotiationTask task = new NegotiationTask("modifyNegotiation", negotiationDoc);
        boolean retVal = this.taskAuthorizationService.isAuthorized(this.quickstart.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.jtester.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.woods.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.ospAdmin.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
    }

    @Test
    public void testCreateActivitiesAuthorizer() throws WorkflowException {
        NegotiationDocument negotiationDoc = this.getNewNegotiationWithUnassociatedDetail();
        NegotiationTask task = new NegotiationTask("createNegotiationActivities", negotiationDoc);
        boolean retVal = this.taskAuthorizationService.isAuthorized(this.quickstart.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.jtester.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.negotiator.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.woods.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.ospAdmin.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
    }

    @Test
    public void testModifyActivitiesAuthorizer() throws WorkflowException {
        NegotiationDocument negotiationDoc = this.getNewNegotiationWithUnassociatedDetail();
        NegotiationTask task = new NegotiationTask("modifyNegotiationActivities", negotiationDoc);
        boolean retVal = this.taskAuthorizationService.isAuthorized(this.quickstart.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.jtester.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.negotiator.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.woods.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.ospAdmin.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
    }

    @Test
    public void testViewNegotiationUnRestrictedAuthorizer() throws WorkflowException {
        NegotiationDocument negotiationDoc = this.getNewNegotiationWithUnassociatedDetail();
        NegotiationTask task = new NegotiationTask("viewNegotiationUnRestricted", negotiationDoc);
        boolean retVal = this.taskAuthorizationService.isAuthorized(this.quickstart.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.jtester.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.woods.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.ospAdmin.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
    }

    @Test
    public void testViewNegotiationAuthorizer() throws WorkflowException {
        NegotiationDocument negotiationDoc = this.getNewNegotiationWithUnassociatedDetail();
        NegotiationTask task = new NegotiationTask("viewNegotiation", negotiationDoc);
        boolean retVal = this.taskAuthorizationService.isAuthorized(this.quickstart.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.jtester.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.woods.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertFalse((boolean)retVal);
        retVal = this.taskAuthorizationService.isAuthorized(this.ospAdmin.getPrincipalId(), (Task)task);
        TestNegotiationAuthorizers.assertTrue((boolean)retVal);
    }

    private NegotiationDocument getNewNegotiationWithUnassociatedDetail() throws WorkflowException {
        NegotiationDocument document = (NegotiationDocument)this.getDocumentService().getNewDocument(NegotiationDocument.class);
        Negotiation negotiation = document.getNegotiation();
        NegotiationStatus status = (NegotiationStatus)this.businessObjectService.findAll(NegotiationStatus.class).iterator().next();
        NegotiationAgreementType agreementType = (NegotiationAgreementType)this.businessObjectService.findAll(NegotiationAgreementType.class).iterator().next();
        HashMap<String, String> primaryKey = new HashMap<String, String>();
        primaryKey.put("code", "NO");
        NegotiationAssociationType associationType = (NegotiationAssociationType)this.businessObjectService.findMatching(NegotiationAssociationType.class, primaryKey).iterator().next();
        negotiation.setNegotiationAgreementType(agreementType);
        negotiation.setNegotiationAssociationType(associationType);
        negotiation.setNegotiationAssociationTypeId(associationType.getId());
        negotiation.setNegotiationStatus(status);
        Date testEndDate = new Date(2011, 12, 31);
        Date testStartDate = new Date(2009, 12, 31);
        negotiation.setAnticipatedAwardDate(testEndDate);
        negotiation.setNegotiationEndDate(testEndDate);
        negotiation.setNegotiationStartDate(testStartDate);
        negotiation.setDocumentFolder("document folder");
        negotiation.setDocumentNumber("123321");
        negotiation.setNegotiatorPersonId(this.negotiator.getPrincipalId());
        this.businessObjectService.save((PersistableBusinessObject)negotiation);
        NegotiationUnassociatedDetail detail = new NegotiationUnassociatedDetail();
        detail.setNegotiation(negotiation);
        detail.setNegotiationId(negotiation.getNegotiationId());
        detail.setTitle("super cool title");
        primaryKey = new HashMap();
        primaryKey.put("unit_number", "000001");
        Unit unit = (Unit)this.businessObjectService.findByPrimaryKey(Unit.class, primaryKey);
        detail.setLeadUnit(unit);
        detail.setLeadUnitNumber(unit.getUnitNumber());
        this.businessObjectService.save((PersistableBusinessObject)detail);
        negotiation.setAssociatedDocumentId(detail.getNegotiationId().toString());
        negotiation.setUnAssociatedDetail(detail);
        this.businessObjectService.save((PersistableBusinessObject)negotiation);
        return document;
    }

    private NegotiationDocument getNewNegotiationWithAward() throws WorkflowException {
        NegotiationDocument document = (NegotiationDocument)this.getDocumentService().getNewDocument(NegotiationDocument.class);
        Negotiation negotiation = document.getNegotiation();
        NegotiationStatus status = (NegotiationStatus)this.businessObjectService.findAll(NegotiationStatus.class).iterator().next();
        NegotiationAgreementType agreementType = (NegotiationAgreementType)this.businessObjectService.findAll(NegotiationAgreementType.class).iterator().next();
        HashMap<String, String> primaryKey = new HashMap<String, String>();
        primaryKey.put("code", "AWD");
        NegotiationAssociationType associationType = (NegotiationAssociationType)this.businessObjectService.findMatching(NegotiationAssociationType.class, primaryKey).iterator().next();
        negotiation.setNegotiationAgreementType(agreementType);
        negotiation.setNegotiationAssociationType(associationType);
        negotiation.setNegotiationAssociationTypeId(associationType.getId());
        negotiation.setNegotiationStatus(status);
        Date testEndDate = new Date(2011, 12, 31);
        Date testStartDate = new Date(2009, 12, 31);
        negotiation.setAnticipatedAwardDate(testEndDate);
        negotiation.setNegotiationEndDate(testEndDate);
        negotiation.setNegotiationStartDate(testStartDate);
        negotiation.setDocumentFolder("document folder");
        negotiation.setDocumentNumber("123321");
        this.businessObjectService.save((PersistableBusinessObject)negotiation);
        Award award = new Award();
        award.setTitle("super awesome cool title");
        primaryKey = new HashMap();
        primaryKey.put("unit_number", "000001");
        Unit unit = (Unit)this.businessObjectService.findByPrimaryKey(Unit.class, primaryKey);
        award.setUnitNumber(unit.getUnitNumber());
        award.setLeadUnit(unit);
        Sponsor sponsor = (Sponsor)this.businessObjectService.findAll(Sponsor.class).iterator().next();
        award.setSponsor(sponsor);
        ActivityType activityType = (ActivityType)this.businessObjectService.findAll(ActivityType.class).iterator().next();
        award.setActivityType(activityType);
        award.setActivityTypeCode(activityType.getActivityTypeCode());
        AwardTransactionType awardTransactionType = (AwardTransactionType)this.businessObjectService.findAll(AwardTransactionType.class).iterator().next();
        award.setAwardTransactionType(awardTransactionType);
        award.setAwardTransactionTypeCode(awardTransactionType.getAwardTransactionTypeCode());
        AwardType awardType = (AwardType)this.businessObjectService.findAll(AwardType.class).iterator().next();
        award.setAwardType(awardType);
        award.setAwardTypeCode(awardType.getAwardTypeCode());
        award.setStatusCode(Integer.valueOf(1));
        Date finalExpirationDate = new Date(2011, 9, 27);
        ((AwardAmountInfo)award.getAwardAmountInfos().get(0)).setFinalExpirationDate(finalExpirationDate);
        award.setSequenceNumber(Integer.valueOf(1));
        award.setSequenceOwner(award);
        AwardDocument awardDocument = new AwardDocument();
        awardDocument.setAward(award);
        awardDocument.setDocumentNumber("123");
        awardDocument.getDocumentHeader().setDocumentNumber("123");
        awardDocument.getDocumentHeader().setDocumentDescription("doc header descr.");
        awardDocument.setVersionNumber(new Long(1L));
        awardDocument.setUpdateTimestamp(new Timestamp(2011, 11, 11, 0, 0, 0, 0));
        awardDocument.setUpdateUser(this.quickstart.getPrincipalId());
        WorkflowDocumentService wds = (WorkflowDocumentService)GlobalResourceLoader.getService((String)"workflowDocumentService");
        WorkflowDocument wd = wds.createWorkflowDocument("AwardDocument", this.quickstart);
        wd.setTitle("doc ttitle");
        awardDocument.getDocumentHeader().setWorkflowDocument(wd);
        award.setAwardDocument(awardDocument);
        GlobalVariables.getMessageMap().clearErrorMessages();
        this.businessObjectService.save((PersistableBusinessObject)awardDocument);
        this.businessObjectService.save((PersistableBusinessObject)award);
        Award dbAward1 = ((AwardBudgetService)KraServiceLocator.getService(AwardBudgetService.class)).getActiveOrNewestAward(award.getAwardNumber());
        System.err.println("dbAward1 == null: " + (dbAward1 == null));
        List dbAwards = ((AwardService)KraServiceLocator.getService(AwardService.class)).findAwardsForAwardNumber(award.getAwardNumber());
        System.err.println("dbAwards.size(): " + dbAwards.size());
        negotiation.setAssociatedDocumentId(award.getAwardNumber());
        this.businessObjectService.save((PersistableBusinessObject)negotiation);
        return document;
    }
}

