/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.bo;

import java.sql.Date;
import java.util.Collection;
import java.util.HashMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationActivityType;
import org.kuali.kra.negotiations.bo.NegotiationAgreementType;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.bo.NegotiationLocation;
import org.kuali.kra.negotiations.bo.NegotiationStatus;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NegotiationBasicTests
extends KcUnitTestBase {
    BusinessObjectService businessObjectService;
    NegotiationStatus status;
    NegotiationAgreementType agreementType;
    NegotiationAssociationType associationType;
    NegotiationLocation location;
    NegotiationActivityType activityType;

    @Override
    @Before
    public void setUp() throws Exception {
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.status = (NegotiationStatus)this.businessObjectService.findAll(NegotiationStatus.class).iterator().next();
        this.agreementType = (NegotiationAgreementType)this.businessObjectService.findAll(NegotiationAgreementType.class).iterator().next();
        this.associationType = (NegotiationAssociationType)this.businessObjectService.findAll(NegotiationAssociationType.class).iterator().next();
        this.activityType = (NegotiationActivityType)this.businessObjectService.findAll(NegotiationActivityType.class).iterator().next();
        this.location = (NegotiationLocation)this.businessObjectService.findAll(NegotiationLocation.class).iterator().next();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.businessObjectService = null;
    }

    @Test
    public void testNegotiationStatuses() throws Exception {
        Collection statuses = this.businessObjectService.findAll(NegotiationStatus.class);
        NegotiationBasicTests.assertTrue((statuses.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNegotiationAgreementTypes() throws Exception {
        Collection types = this.businessObjectService.findAll(NegotiationAgreementType.class);
        NegotiationBasicTests.assertTrue((types.size() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNegotiationAssociationTypes() throws Exception {
        Collection types = this.businessObjectService.findAll(NegotiationAssociationType.class);
        NegotiationBasicTests.assertTrue((types.size() > 0 ? 1 : 0) != 0);
    }

    protected Negotiation getNewNegotiation() {
        Negotiation negotiation = new Negotiation();
        negotiation.setNegotiationStatus(this.status);
        negotiation.setNegotiationAgreementType(this.agreementType);
        negotiation.setNegotiationAssociationType(this.associationType);
        Date testEndDate = new Date(2011, 12, 31);
        Date testStartDate = new Date(2009, 12, 31);
        negotiation.setAnticipatedAwardDate(testEndDate);
        negotiation.setNegotiationEndDate(testEndDate);
        negotiation.setNegotiationStartDate(testStartDate);
        negotiation.setDocumentFolder("document folder");
        negotiation.setDocumentNumber("123321");
        negotiation.setNegotiatorPersonId("jdh34");
        negotiation.setNegotiatorName("quickstart");
        NegotiationBasicTests.assertNull((Object)negotiation.getUpdateUser());
        this.businessObjectService.save((PersistableBusinessObject)negotiation);
        NegotiationBasicTests.assertNotNull((Object)negotiation.getUpdateUser());
        return negotiation;
    }

    @Test
    public void testNegotiation() throws Exception {
        Negotiation negotiation = this.getNewNegotiation();
        HashMap<String, Long> primaryKey = new HashMap<String, Long>();
        primaryKey.put("negotiationId", negotiation.getNegotiationId());
        Negotiation dbNegotation = (Negotiation)this.businessObjectService.findByPrimaryKey(Negotiation.class, primaryKey);
        NegotiationBasicTests.assertNotNull((Object)dbNegotation.getNegotiationStatus());
        NegotiationBasicTests.assertEquals((Object)this.status.getId(), (Object)dbNegotation.getNegotiationStatus().getId());
        NegotiationBasicTests.assertEquals((Object)this.status.getId(), (Object)dbNegotation.getNegotiationStatusId());
        NegotiationBasicTests.assertEquals((Object)this.agreementType.getId(), (Object)dbNegotation.getNegotiationAgreementType().getId());
        NegotiationBasicTests.assertEquals((Object)this.agreementType.getId(), (Object)dbNegotation.getNegotiationAgreementTypeId());
        NegotiationBasicTests.assertEquals((Object)this.associationType.getId(), (Object)dbNegotation.getNegotiationAssociationType().getId());
        NegotiationBasicTests.assertEquals((Object)this.associationType.getId(), (Object)dbNegotation.getNegotiationAssociationTypeId());
    }

    @Test
    public void testNegotiationUnassociatedDetail() throws Exception {
        HashMap<String, Object> primaryKey = new HashMap<String, Object>();
        primaryKey.put("code", "NO");
        this.associationType = (NegotiationAssociationType)this.businessObjectService.findMatching(NegotiationAssociationType.class, primaryKey).iterator().next();
        Negotiation negotiation = new Negotiation();
        negotiation.setNegotiationStatus(this.status);
        negotiation.setNegotiationAgreementType(this.agreementType);
        negotiation.setNegotiationAssociationType(this.associationType);
        Date testEndDate = new Date(2011, 12, 31);
        Date testStartDate = new Date(2009, 12, 31);
        negotiation.setAnticipatedAwardDate(testEndDate);
        negotiation.setNegotiationEndDate(testEndDate);
        negotiation.setNegotiationStartDate(testStartDate);
        negotiation.setDocumentFolder("document folder");
        negotiation.setDocumentNumber("123321");
        negotiation.setNegotiatorPersonId("jdh34");
        negotiation.setNegotiatorName("quickstart");
        this.businessObjectService.save((PersistableBusinessObject)negotiation);
        primaryKey = new HashMap();
        primaryKey.put("negotiationId", negotiation.getNegotiationId());
        Negotiation dbNegotation = (Negotiation)this.businessObjectService.findByPrimaryKey(Negotiation.class, primaryKey);
        Organization org = (Organization)this.businessObjectService.findAll(Organization.class).iterator().next();
        Sponsor sponsor = (Sponsor)this.businessObjectService.findAll(Sponsor.class).iterator().next();
        Unit unit = (Unit)this.businessObjectService.findAll(Unit.class).iterator().next();
        NegotiationUnassociatedDetail detail = new NegotiationUnassociatedDetail();
        detail.setNegotiation(dbNegotation);
        detail.setLeadUnit(unit);
        detail.setSponsor(sponsor);
        detail.setSponsorCode(sponsor.getSponsorCode());
        detail.setPrimeSponsor(sponsor);
        detail.setSubAwardOrganization(org);
        detail.setTitle("super awesome title");
        detail.setPiPersonId("10000000001");
        detail.setPiRolodexId("212");
        detail.setSponsorAwardNumber("1590431");
        detail.setContactAdminPersonId("jdh34");
        this.businessObjectService.save((PersistableBusinessObject)detail);
        dbNegotation.setAssociatedDocumentId(detail.getNegotiationUnassociatedDetailId().toString());
        this.businessObjectService.save((PersistableBusinessObject)detail);
        primaryKey = new HashMap();
        primaryKey.put("negotiationUnassociatedDetailId", detail.getNegotiationUnassociatedDetailId());
        NegotiationUnassociatedDetail dbDetail = (NegotiationUnassociatedDetail)this.businessObjectService.findByPrimaryKey(NegotiationUnassociatedDetail.class, primaryKey);
        NegotiationBasicTests.assertEquals((Object)dbDetail.getNegotiationUnassociatedDetailId().toString(), (Object)dbDetail.getNegotiation().getAssociatedDocumentId());
        NegotiationBasicTests.assertEquals((Object)this.associationType.getId(), (Object)dbDetail.getNegotiation().getNegotiationAssociationType().getId());
        NegotiationBasicTests.assertEquals((Object)sponsor.getSponsorCode(), (Object)dbDetail.getSponsorCode());
        NegotiationBasicTests.assertEquals((Object)detail.getContactAdminPersonId(), (Object)dbDetail.getContactAdminPersonId());
    }

    @Test
    public void testActivities() {
        Negotiation negotiation = this.getNewNegotiation();
        NegotiationActivity activity = new NegotiationActivity();
        activity.setLocation(this.location);
        activity.setActivityType(this.activityType);
        activity.setStartDate(new Date(2011, 1, 1));
        activity.setDescription("Test Description");
        activity.setCreateDate(new Date(new java.util.Date().getTime()));
        activity.setLastModifiedDate(new Date(new java.util.Date().getTime()));
        activity.setLastModifiedUsername("quickstart");
        negotiation.getActivities().add(activity);
        this.businessObjectService.save((PersistableBusinessObject)negotiation);
        Negotiation negotiation2 = (Negotiation)this.businessObjectService.findBySinglePrimaryKey(Negotiation.class, (Object)negotiation.getNegotiationId());
        NegotiationBasicTests.assertTrue((negotiation2.getActivities().size() == 1 ? 1 : 0) != 0);
    }
}

