/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.rules;

import java.sql.Date;
import java.util.Calendar;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationActivity;
import org.kuali.kra.negotiations.bo.NegotiationFixtureFactory;
import org.kuali.kra.negotiations.rules.NegotiationActivityRuleImpl;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.util.GlobalVariables;

public class NegotiationActivityRuleTest
extends KcUnitTestBase {
    private NegotiationActivityRuleImpl rule;
    private Negotiation negotiation;
    private NegotiationActivity activity;

    @Override
    @Before
    public void setUp() {
        this.rule = new NegotiationActivityRuleImpl();
        this.negotiation = NegotiationFixtureFactory.createNegotiationFixture();
        this.activity = new NegotiationActivity();
        this.activity.setActivityTypeId(Long.valueOf(1L));
        this.activity.setLocationId(Long.valueOf(1L));
        this.activity.setDescription("Testing");
        this.activity.setStartDate(this.negotiation.getNegotiationStartDate());
    }

    @Override
    @After
    public void tearDown() {
    }

    @Test
    public void testActivityRuleSuccess() {
        NegotiationActivityRuleTest.assertTrue((boolean)this.rule.validateNegotiationActivity(this.activity, this.negotiation));
        NegotiationActivityRuleTest.assertEquals((long)0L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testStartDateBefore() {
        Calendar startDate = Calendar.getInstance();
        startDate.setTime(this.activity.getStartDate());
        startDate.add(6, -1);
        this.activity.setStartDate(new Date(startDate.getTime().getTime()));
        NegotiationActivityRuleTest.assertFalse((boolean)this.rule.validateNegotiationActivity(this.activity, this.negotiation));
        NegotiationActivityRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testFollowupBefore() {
        Calendar date = Calendar.getInstance();
        date.add(6, -1);
        this.activity.setFollowupDate(new Date(date.getTime().getTime()));
        NegotiationActivityRuleTest.assertFalse((boolean)this.rule.validateNegotiationActivity(this.activity, this.negotiation));
        NegotiationActivityRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testEndBeforeStart() {
        Calendar date = Calendar.getInstance();
        date.add(6, -1);
        this.activity.setEndDate(new Date(date.getTime().getTime()));
        NegotiationActivityRuleTest.assertFalse((boolean)this.rule.validateNegotiationActivity(this.activity, this.negotiation));
        NegotiationActivityRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }

    @Test
    public void testEndAfterNegotiationEnd() {
        Calendar date = Calendar.getInstance();
        this.negotiation.setNegotiationEndDate(new Date(date.getTime().getTime()));
        date = Calendar.getInstance();
        date.add(6, -1);
        this.activity.setEndDate(new Date(date.getTime().getTime()));
        NegotiationActivityRuleTest.assertFalse((boolean)this.rule.validateNegotiationActivity(this.activity, this.negotiation));
        NegotiationActivityRuleTest.assertEquals((long)1L, (long)GlobalVariables.getMessageMap().getErrorCount());
    }
}

