/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.rules;

import java.sql.Date;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationFixtureFactory;
import org.kuali.kra.negotiations.rules.NegotiationDocumentRule;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.negotiations.service.NegotiationServiceImpl;

public class NegotiationDocumentRuleTest {
    protected Negotiation negotiation;
    protected NegotiationDocumentRule rule;

    @Before
    public void setUp() {
        this.negotiation = NegotiationFixtureFactory.createNegotiationFixture();
        this.rule = new NegotiationDocumentRule();
        this.rule.setNegotiationService((NegotiationService)new NegotiationServiceMock());
    }

    @After
    public void tearDown() {
        this.negotiation = null;
    }

    @Test
    public void testEndDateRule_inProgress() {
        this.negotiation.setNegotiationEndDate(null);
        Assert.assertTrue((boolean)this.rule.validateEndDate(this.negotiation));
    }

    @Test
    public void testEndDateRule_inProgressFailure() {
        Assert.assertFalse((boolean)this.rule.validateEndDate(this.negotiation));
    }

    @Test
    public void testEndDateRule_CompletedFailure() {
        this.negotiation.setNegotiationEndDate(null);
        this.negotiation.getNegotiationStatus().setCode("COM");
        Assert.assertFalse((boolean)this.rule.validateEndDate(this.negotiation));
    }

    @Test
    public void testEndDateRule_Completed() {
        this.negotiation.getNegotiationStatus().setCode("COM");
        Assert.assertTrue((boolean)this.rule.validateEndDate(this.negotiation));
    }

    @Test
    public void testEndDateRule_EndDateBeforeStart() {
        this.negotiation.setNegotiationEndDate(new Date(2005, 1, 1));
        this.negotiation.getNegotiationStatus().setCode("COM");
        Assert.assertFalse((boolean)this.rule.validateEndDate(this.negotiation));
    }

    class NegotiationServiceMock
    extends NegotiationServiceImpl {
        NegotiationServiceMock() {
        }

        public List<String> getInProgressStatusCodes() {
            return Arrays.asList("IP", "TESTIP");
        }

        public List<String> getCompletedStatusCodes() {
            return Arrays.asList("SUP", "COM");
        }
    }
}

