/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.negotiations.service;

import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.Organization;
import org.kuali.kra.bo.Sponsor;
import org.kuali.kra.bo.Unit;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.negotiations.bo.Negotiation;
import org.kuali.kra.negotiations.bo.NegotiationAgreementType;
import org.kuali.kra.negotiations.bo.NegotiationAssociatedDetailBean;
import org.kuali.kra.negotiations.bo.NegotiationAssociationType;
import org.kuali.kra.negotiations.bo.NegotiationStatus;
import org.kuali.kra.negotiations.bo.NegotiationUnassociatedDetail;
import org.kuali.kra.negotiations.service.NegotiationService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.service.BusinessObjectService;

public class NegotiationServiceImplTest
extends KcUnitTestBase {
    private NegotiationService negotiationService;
    private BusinessObjectService businessObjectService;

    @Override
    @Before
    public void setUp() throws Exception {
        this.negotiationService = (NegotiationService)KraServiceLocator.getService(NegotiationService.class);
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.negotiationService = null;
        this.businessObjectService = null;
    }

    @Test
    public void testGetInProgressStatusCodes() {
        List inProgressCodes = this.negotiationService.getInProgressStatusCodes();
        NegotiationServiceImplTest.assertEquals((long)1L, (long)inProgressCodes.size());
    }

    @Test
    public void testGetCompletedStatusCodes() {
        List completed = this.negotiationService.getCompletedStatusCodes();
        NegotiationServiceImplTest.assertEquals((long)2L, (long)completed.size());
    }

    @Test
    public void testBuildNegotiationAssociatedDetailBean1() {
        Negotiation negotiation = this.getBasicNegotiation();
        negotiation.setNegotiationAssociationType(this.getNegotiationAssociationType("NO"));
        this.businessObjectService.save((PersistableBusinessObject)negotiation);
        Organization org = (Organization)this.businessObjectService.findAll(Organization.class).iterator().next();
        Sponsor sponsor = (Sponsor)this.businessObjectService.findAll(Sponsor.class).iterator().next();
        Unit unit = (Unit)this.businessObjectService.findAll(Unit.class).iterator().next();
        NegotiationUnassociatedDetail detail = new NegotiationUnassociatedDetail();
        detail.setNegotiation(negotiation);
        detail.setLeadUnit(unit);
        detail.setLeadUnitNumber(unit.getUnitNumber());
        detail.setSponsor(sponsor);
        detail.setSponsorCode(sponsor.getSponsorCode());
        detail.setPrimeSponsor(sponsor);
        detail.setPrimeSponsorCode(sponsor.getSponsorCode());
        detail.setSubAwardOrganization(org);
        detail.setSubAwardOrganizationId(org.getOrganizationId());
        detail.setTitle("super awesome title");
        detail.setPiPersonId("10000000001");
        detail.setPiRolodexId("306");
        detail.setSponsorAwardNumber("1590431");
        detail.setContactAdminPersonId("10000000001");
        this.businessObjectService.save((PersistableBusinessObject)detail);
        detail.refresh();
        negotiation.setAssociatedDocumentId(detail.getNegotiationId().toString());
        negotiation.setUnAssociatedDetail(detail);
        this.businessObjectService.save((PersistableBusinessObject)negotiation);
        NegotiationAssociatedDetailBean bean = this.negotiationService.buildNegotiationAssociatedDetailBean(negotiation);
    }

    private Negotiation getBasicNegotiation() {
        NegotiationStatus status = (NegotiationStatus)this.businessObjectService.findAll(NegotiationStatus.class).iterator().next();
        NegotiationAgreementType agreementType = (NegotiationAgreementType)this.businessObjectService.findAll(NegotiationAgreementType.class).iterator().next();
        Negotiation negotiation = new Negotiation();
        negotiation.setNegotiationStatus(status);
        negotiation.setNegotiationAgreementType(agreementType);
        Date testEndDate = new Date(2011, 12, 31);
        Date testStartDate = new Date(2009, 12, 31);
        negotiation.setAnticipatedAwardDate(testEndDate);
        negotiation.setNegotiationEndDate(testEndDate);
        negotiation.setNegotiationStartDate(testStartDate);
        negotiation.setDocumentFolder("document folder");
        negotiation.setDocumentNumber("123321");
        negotiation.setNegotiatorPersonId("10000000001");
        return negotiation;
    }

    private NegotiationAssociationType getNegotiationAssociationType(String code) {
        HashMap<String, String> codes = new HashMap<String, String>();
        codes.put("NEGOTIATION_ASSC_TYPE_CODE", code);
        return (NegotiationAssociationType)this.businessObjectService.findMatching(NegotiationAssociationType.class, codes).iterator().next();
    }

    @Test
    public void testIsAwardLinkingEnabled() {
        boolean checkVal = this.negotiationService.isAwardLinkingEnabled();
        NegotiationServiceImplTest.assertTrue((boolean)checkVal);
        NegotiationAssociationType awardType = this.negotiationService.getNegotiationAssociationType("AWD");
        awardType.setActive(false);
        this.businessObjectService.save((PersistableBusinessObject)awardType);
        checkVal = this.negotiationService.isAwardLinkingEnabled();
        NegotiationServiceImplTest.assertFalse((boolean)checkVal);
    }

    @Test
    public void testIsInstitutionalProposalLinkingEnabled() {
        boolean checkVal = this.negotiationService.isInstitutionalProposalLinkingEnabled();
        NegotiationServiceImplTest.assertTrue((boolean)checkVal);
    }

    @Test
    public void testIsNoModuleLinkingEnabled() {
        boolean checkVal = this.negotiationService.isNoModuleLinkingEnabled();
        NegotiationServiceImplTest.assertTrue((boolean)checkVal);
    }

    @Test
    public void testIsProposalLogLinkingEnabled() {
        boolean checkVal = this.negotiationService.isProposalLogLinkingEnabled();
        NegotiationServiceImplTest.assertTrue((boolean)checkVal);
    }

    @Test
    public void testIsSubawardLinkingEnabled() {
        boolean checkVal = this.negotiationService.isSubawardLinkingEnabled();
        NegotiationServiceImplTest.assertTrue((boolean)checkVal);
    }
}

