/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.printing.util;

import java.util.ArrayList;
import java.util.Map;
import org.apache.xmlbeans.XmlObject;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.KraPersistableBusinessObjectBase;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.printing.util.PrintingTestUtils;
import org.kuali.kra.printing.xmlstream.XmlStream;
import org.kuali.kra.s2s.service.S2SValidatorService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.UserSession;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.util.GlobalVariables;

public abstract class XmlStreamTestBase<T>
extends KcUnitTestBase {
    protected XmlStream xmlStream;
    protected XmlObject xmlObject;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        GlobalVariables.setUserSession((UserSession)new UserSession("quickstart"));
        this.xmlStream = (XmlStream)this.getXmlStream().newInstance();
        this.xmlStream.setBusinessObjectService((BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class));
        this.xmlStream.setDateTimeService((DateTimeService)KraServiceLocator.getService(DateTimeService.class));
        this.createXmlObject();
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.xmlStream = null;
        this.xmlObject = null;
        GlobalVariables.setUserSession(null);
        super.tearDown();
    }

    protected void createXmlObject() {
        this.xmlObject = (XmlObject)this.xmlStream.generateXmlStream(this.prepareData(), this.getReportParameters()).values().iterator().next();
        PrintingTestUtils.saveXml(this.xmlObject, this.getClass().getSimpleName());
    }

    @Test
    public void testValidateXmlStream() throws Exception {
        ArrayList errors = new ArrayList();
        this.getService(S2SValidatorService.class).validate(this.xmlObject, errors);
        XmlStreamTestBase.assertTrue((boolean)errors.isEmpty());
    }

    protected abstract Map<String, Object> getReportParameters();

    protected abstract KraPersistableBusinessObjectBase prepareData();

    protected abstract Class<T> getXmlStream();
}

