/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kra.proposaldevelopment;

import java.sql.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kra.bo.KcPerson;
import org.kuali.kra.infrastructure.KraServiceLocator;
import org.kuali.kra.proposaldevelopment.bo.DevelopmentProposal;
import org.kuali.kra.proposaldevelopment.bo.ProposalPerson;
import org.kuali.kra.proposaldevelopment.bo.ProposalPersonRole;
import org.kuali.kra.proposaldevelopment.document.ProposalDevelopmentDocument;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonModuleQuestionnaireBean;
import org.kuali.kra.proposaldevelopment.questionnaire.ProposalPersonQuestionnaireHelper;
import org.kuali.kra.proposaldevelopment.service.ProposalDevelopmentService;
import org.kuali.kra.proposaldevelopment.web.struts.form.ProposalDevelopmentForm;
import org.kuali.kra.questionnaire.Questionnaire;
import org.kuali.kra.questionnaire.QuestionnaireQuestion;
import org.kuali.kra.questionnaire.answer.Answer;
import org.kuali.kra.questionnaire.answer.AnswerHeader;
import org.kuali.kra.questionnaire.answer.QuestionnaireAnswerService;
import org.kuali.kra.questionnaire.question.Question;
import org.kuali.kra.service.KcPersonService;
import org.kuali.kra.test.infrastructure.KcUnitTestBase;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.PersistableBusinessObject;
import org.kuali.rice.krad.document.Document;
import org.kuali.rice.krad.service.BusinessObjectService;
import org.kuali.rice.krad.service.DocumentService;

public class ProposalPersonQuestionnaireTest
extends KcUnitTestBase {
    private BusinessObjectService businessObjectService;
    private QuestionnaireAnswerService questionnaireAnswerService;
    private DocumentService documentService;
    private ProposalDevelopmentService proposalDevelopmentService;
    private DevelopmentProposal proposal;
    private ProposalPersonQuestionnaireHelper questionnaireHelper;
    private ProposalDevelopmentForm form;
    private static final String q1 = "Can you certify that the information submitted within this application is true, complete and accurate to the best of your knowledge? That any false, fictitious, or fraudulent statements or claims may subject you, as the PI/Co-PI/Co-I to criminal, civil or administrative penalties? That you agree to accept responsibility for the scientific conduct of the project and to provide the required progress reports if an award is made as a result of this application.";
    private static final String q2 = "Is there any potential for a perceived or real conflict of interest as defined in MIT's Policies and Procedures with regard to this proposal?";
    private static final String q3 = "If this is a NIH/NSF proposal have you submitted the required financial disclosures in the web based Coeus Conflict of Interest module?";
    private static final String q4 = "Have lobbying activities been conducted on behalf of this proposal?";
    private static final String q5 = "Are you currently debarred, suspended, proposed for debarment, declared ineligible or voluntarily excluded from current transactions by a federal department or agency?";
    private static final String q6 = "Are you familiar with the requirements of the Procurement Liabilities Act?";

    @Override
    @Before
    public void setUp() throws Exception {
        this.businessObjectService = (BusinessObjectService)KraServiceLocator.getService(BusinessObjectService.class);
        this.questionnaireAnswerService = (QuestionnaireAnswerService)KraServiceLocator.getService(QuestionnaireAnswerService.class);
        this.documentService = (DocumentService)KraServiceLocator.getService(DocumentService.class);
        this.proposalDevelopmentService = (ProposalDevelopmentService)KraServiceLocator.getService(ProposalDevelopmentService.class);
        this.proposal = this.getDocument().getDevelopmentProposal();
        this.proposal = this.getDocument().getDevelopmentProposal();
        this.form = new ProposalDevelopmentForm();
        this.form.setDocument((Document)this.proposal.getProposalDocument());
        this.form.initialize();
        this.questionnaireHelper = new ProposalPersonQuestionnaireHelper(this.form, this.getPerson());
    }

    @Override
    @After
    public void tearDown() throws Exception {
        this.businessObjectService = null;
        this.questionnaireAnswerService = null;
        this.documentService = null;
        this.proposalDevelopmentService = null;
        this.proposal = null;
        this.questionnaireHelper = null;
        this.form = null;
    }

    private ProposalDevelopmentDocument getDocument() throws WorkflowException {
        ProposalDevelopmentDocument document = (ProposalDevelopmentDocument)this.documentService.getNewDocument("ProposalDevelopmentDocument");
        document.initialize();
        Date requestedStartDateInitial = new Date(System.currentTimeMillis());
        Date requestedEndDateInitial = new Date(System.currentTimeMillis());
        this.setBaseDocumentFields(document, "ProposalDevelopmentDocumentTest test doc", "005770", "project title", requestedStartDateInitial, requestedEndDateInitial, "1", "1", "000001", "000120");
        this.documentService.saveDocument((Document)document);
        if (document.getDevelopmentProposal().getProposalPersons().isEmpty()) {
            KcPerson person = ((KcPersonService)KraServiceLocator.getService(KcPersonService.class)).getKcPersonByUserName("quickstart");
            ProposalPerson pp = new ProposalPerson();
            pp.setPersonId(person.getPersonId());
            pp.setDevelopmentProposal(document.getDevelopmentProposal());
            pp.setProposalNumber(document.getDevelopmentProposal().getProposalNumber());
            pp.setProposalPersonNumber(new Integer(0));
            ProposalPersonRole role = (ProposalPersonRole)this.businessObjectService.findAll(ProposalPersonRole.class).iterator().next();
            pp.setRole(role);
            pp.setProposalPersonRoleId(role.getRoleCode());
            pp.setOptInUnitStatus("Y");
            pp.setOptInCertificationStatus("Y");
            pp.setUserName(person.getUserName());
            pp.setLastName(person.getLastName());
            pp.setFullName(person.getFullName());
            document.getDevelopmentProposal().getProposalPersons().add(pp);
        }
        this.documentService.saveDocument((Document)document);
        ProposalDevelopmentDocument savedDocument = (ProposalDevelopmentDocument)this.documentService.getByDocumentHeaderId(document.getDocumentNumber());
        return savedDocument;
    }

    private void setBaseDocumentFields(ProposalDevelopmentDocument document, String description, String sponsorCode, String title, Date requestedStartDateInitial, Date requestedEndDateInitial, String activityTypeCode, String proposalTypeCode, String ownedByUnit, String primeSponsorCode) {
        document.getDocumentHeader().setDocumentDescription(description);
        document.getDevelopmentProposal().setSponsorCode(sponsorCode);
        document.getDevelopmentProposal().setTitle(title);
        document.getDevelopmentProposal().setRequestedStartDateInitial(requestedStartDateInitial);
        document.getDevelopmentProposal().setRequestedEndDateInitial(requestedEndDateInitial);
        document.getDevelopmentProposal().setActivityTypeCode(activityTypeCode);
        document.getDevelopmentProposal().setProposalTypeCode(proposalTypeCode);
        document.getDevelopmentProposal().setOwnedByUnitNumber(ownedByUnit);
        document.getDevelopmentProposal().setPrimeSponsorCode(primeSponsorCode);
        this.proposalDevelopmentService.initializeUnitOrganizationLocation(document);
        this.proposalDevelopmentService.initializeProposalSiteNumbers(document);
    }

    private ProposalPerson getPerson() {
        return (ProposalPerson)this.proposal.getProposalPersons().get(0);
    }

    @Test
    public void testProposalReady() throws WorkflowException {
        ProposalPersonQuestionnaireTest.assertEquals((long)1L, (long)this.proposal.getProposalPersons().size());
        ProposalPersonQuestionnaireTest.assertEquals((Object)"project title", (Object)this.proposal.getTitle());
        ProposalPersonQuestionnaireTest.assertEquals((Object)"McGregor", (Object)this.getPerson().getLastName());
        ProposalPersonQuestionnaireTest.assertTrue((boolean)this.proposal.getProposalDocument().getDocumentHeader().hasWorkflowDocument());
        ProposalPersonQuestionnaireTest.assertEquals((Object)this.proposal.getProposalNumber(), (Object)this.getPerson().getProposalNumber());
        ProposalPersonQuestionnaireTest.assertNotSame((Object)this.getPerson().getProposalPersonNumber().toString(), (Object)this.getDocument().getDevelopmentProposal().getProposalPerson(0).getProposalNumber().toString());
    }

    @Test
    public void testProposalPersonModuleQuestionnaireBean() {
        ProposalPersonModuleQuestionnaireBean bean = new ProposalPersonModuleQuestionnaireBean(this.proposal, this.getPerson());
        ProposalPersonQuestionnaireTest.assertEquals((Object)"3", (Object)bean.getModuleItemCode());
    }

    @Test
    public void testQuestionnaire() {
        AnswerHeader header = (AnswerHeader)this.questionnaireAnswerService.getQuestionnaireAnswer(this.questionnaireHelper.getModuleQnBean()).get(0);
        Questionnaire questionnaire = header.getQuestionnaire();
        ProposalPersonQuestionnaireTest.assertEquals((long)6L, (long)questionnaire.getQuestionnaireQuestions().size());
        boolean q1Found = false;
        boolean q2Found = false;
        boolean q3Found = false;
        boolean q4Found = false;
        boolean q5Found = false;
        boolean q6Found = false;
        for (QuestionnaireQuestion q : questionnaire.getQuestionnaireQuestions()) {
            ProposalPersonQuestionnaireTest.assertFalse((boolean)StringUtils.isEmpty((String)q.getQuestion().getAffirmativeStatementConversion()));
            ProposalPersonQuestionnaireTest.assertFalse((boolean)StringUtils.isEmpty((String)q.getQuestion().getNegativeStatementConversion()));
            if (StringUtils.equals((String)q1, (String)q.getQuestion().getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)q.getQuestion().getAnswerMaxLength().toString());
                q1Found = true;
                continue;
            }
            if (StringUtils.equals((String)q2, (String)q.getQuestion().getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"Yes/No", (Object)q.getQuestion().getQuestionType().getQuestionTypeName());
                q2Found = true;
                continue;
            }
            if (StringUtils.equals((String)q3, (String)q.getQuestion().getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)q.getQuestion().getMaxAnswers().toString());
                q3Found = true;
                continue;
            }
            if (StringUtils.equals((String)q4, (String)q.getQuestion().getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)q.getQuestion().getAnswerMaxLength().toString());
                q4Found = true;
                continue;
            }
            if (StringUtils.equals((String)q5, (String)q.getQuestion().getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)q.getQuestion().getAnswerMaxLength().toString());
                q5Found = true;
                continue;
            }
            if (StringUtils.equals((String)q6, (String)q.getQuestion().getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)q.getQuestion().getAnswerMaxLength().toString());
                q6Found = true;
                continue;
            }
            ProposalPersonQuestionnaireTest.assertTrue((String)("Unknown Question: " + q.getQuestion().getQuestion()), (boolean)false);
        }
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q1Found);
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q2Found);
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q3Found);
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q4Found);
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q5Found);
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q6Found);
    }

    @Test
    public void testGetNewAnswerHeader() throws Exception {
        AnswerHeader header = (AnswerHeader)this.questionnaireAnswerService.getQuestionnaireAnswer(this.questionnaireHelper.getModuleQnBean()).get(0);
        ProposalPersonQuestionnaireTest.assertEquals((long)6L, (long)header.getAnswers().size());
        for (Answer answer : header.getAnswers()) {
            answer.setAnswer("1");
        }
        this.businessObjectService.save((PersistableBusinessObject)header);
        List headers = this.questionnaireAnswerService.getQuestionnaireAnswer(this.questionnaireHelper.getModuleQnBean());
        ProposalPersonQuestionnaireTest.assertEquals((long)1L, (long)headers.size());
        List answers = ((AnswerHeader)headers.get(0)).getAnswers();
        ProposalPersonQuestionnaireTest.assertEquals((long)6L, (long)answers.size());
        boolean q1Found = false;
        boolean q2Found = false;
        boolean q3Found = false;
        boolean q4Found = false;
        boolean q5Found = false;
        boolean q6Found = false;
        for (Answer answer : answers) {
            Question thisQuestion = answer.getQuestion();
            if (StringUtils.equals((String)q1, (String)thisQuestion.getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)thisQuestion.getAnswerMaxLength().toString());
                q1Found = true;
                continue;
            }
            if (StringUtils.equals((String)q2, (String)thisQuestion.getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"Yes/No", (Object)thisQuestion.getQuestionType().getQuestionTypeName());
                q2Found = true;
                continue;
            }
            if (StringUtils.equals((String)q3, (String)thisQuestion.getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)thisQuestion.getMaxAnswers().toString());
                q3Found = true;
                continue;
            }
            if (StringUtils.equals((String)q4, (String)thisQuestion.getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)thisQuestion.getAnswerMaxLength().toString());
                q4Found = true;
                continue;
            }
            if (StringUtils.equals((String)q5, (String)thisQuestion.getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)thisQuestion.getAnswerMaxLength().toString());
                q5Found = true;
                continue;
            }
            if (StringUtils.equals((String)q6, (String)thisQuestion.getQuestion())) {
                ProposalPersonQuestionnaireTest.assertEquals((Object)"1", (Object)thisQuestion.getAnswerMaxLength().toString());
                q6Found = true;
                continue;
            }
            ProposalPersonQuestionnaireTest.assertTrue((String)("Unknown Question: " + thisQuestion.getQuestion()), (boolean)false);
        }
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q1Found);
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q2Found);
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q3Found);
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q4Found);
        ProposalPersonQuestionnaireTest.assertTrue((boolean)q5Found);
    }
}

